/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.rules.action;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.application.rules.QueryRulesIndexService;
import org.elasticsearch.xpack.application.rules.action.DeleteQueryRuleAction;

public class TransportDeleteQueryRuleAction
extends HandledTransportAction<DeleteQueryRuleAction.Request, AcknowledgedResponse> {
    protected final QueryRulesIndexService systemIndexService;

    @Inject
    public TransportDeleteQueryRuleAction(TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, Client client) {
        super("cluster:admin/xpack/query_rules/rule/delete", transportService, actionFilters, DeleteQueryRuleAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.systemIndexService = new QueryRulesIndexService(client, clusterService.getClusterSettings());
    }

    protected void doExecute(Task task, DeleteQueryRuleAction.Request request, ActionListener<AcknowledgedResponse> listener) {
        String rulesetId = request.rulesetId();
        String ruleId = request.ruleId();
        this.systemIndexService.deleteQueryRule(rulesetId, ruleId, (ActionListener<DeleteQueryRuleAction.Response>)listener.map(v -> AcknowledgedResponse.TRUE));
    }
}

