/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.application.connector.Connector;
import org.elasticsearch.xpack.application.connector.ConnectorIngestPipeline;
import org.elasticsearch.xpack.application.connector.action.ConnectorActionRequest;
import org.elasticsearch.xpack.application.connector.action.ConnectorUpdateActionResponse;

public class UpdateConnectorPipelineAction {
    public static final String NAME = "cluster:admin/xpack/connector/update_pipeline";
    public static final ActionType<ConnectorUpdateActionResponse> INSTANCE = new ActionType("cluster:admin/xpack/connector/update_pipeline");

    private UpdateConnectorPipelineAction() {
    }

    public static class Request
    extends ConnectorActionRequest
    implements ToXContentObject {
        private final String connectorId;
        private final ConnectorIngestPipeline pipeline;
        private static final ConstructingObjectParser<Request, String> PARSER = new ConstructingObjectParser("connector_update_pipeline_request", false, (args, connectorId) -> new Request((String)connectorId, (ConnectorIngestPipeline)args[0]));

        public Request(String connectorId, ConnectorIngestPipeline pipeline) {
            this.connectorId = connectorId;
            this.pipeline = pipeline;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.connectorId = in.readString();
            this.pipeline = (ConnectorIngestPipeline)in.readOptionalWriteable(ConnectorIngestPipeline::new);
        }

        public String getConnectorId() {
            return this.connectorId;
        }

        public ConnectorIngestPipeline getPipeline() {
            return this.pipeline;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (Strings.isNullOrEmpty((String)this.connectorId)) {
                validationException = ValidateActions.addValidationError((String)"[connector_id] cannot be [null] or [\"\"].", validationException);
            }
            if (Objects.isNull(this.pipeline)) {
                validationException = ValidateActions.addValidationError((String)"[pipeline] cannot be [null].", (ActionRequestValidationException)validationException);
            }
            return validationException;
        }

        public static Request fromXContent(XContentParser parser, String connectorId) throws IOException {
            return (Request)((Object)PARSER.parse(parser, (Object)connectorId));
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Connector.PIPELINE_FIELD.getPreferredName(), (ToXContent)this.pipeline);
            builder.endObject();
            return builder;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.connectorId);
            out.writeOptionalWriteable((Writeable)this.pipeline);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.connectorId, request.connectorId) && Objects.equals(this.pipeline, request.pipeline);
        }

        public int hashCode() {
            return Objects.hash(this.connectorId, this.pipeline);
        }

        static {
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> ConnectorIngestPipeline.fromXContent(p), Connector.PIPELINE_FIELD);
        }
    }
}

