/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.script.Metadata;

public class UpdateMetadata
extends Metadata {
    protected static final String LEGACY_NOOP_STRING = "none";
    static final Map<String, Metadata.FieldProperty<?>> PROPERTIES = Map.of("_index", StringField.withNullable(), "_id", StringField.withNullable(), "_version", LongField, "_routing", StringField.withNullable(), "_type", StringField.withNullable(), "op", StringField.withWritable().withNullable(), "_now", LongField);
    protected final Set<String> validOps;

    public UpdateMetadata(String index, String id, long version, String routing, String type, String op, long now) {
        this(UpdateMetadata.metadataMap(index, id, version, routing, type, op, now), Set.of("noop", "index", "delete"), PROPERTIES);
    }

    protected UpdateMetadata(Map<String, Object> metadata, Set<String> validOps, Map<String, Metadata.FieldProperty<?>> properties) {
        super(metadata, properties);
        this.validOps = validOps;
    }

    protected static Map<String, Object> metadataMap(String index, String id, long version, String routing, String type, String op, long now) {
        Map<String, Object> metadata = Maps.newHashMapWithExpectedSize(PROPERTIES.size());
        metadata.put("_index", index);
        metadata.put("_id", id);
        metadata.put("_version", version);
        metadata.put("_routing", routing);
        metadata.put("_type", type);
        metadata.put("op", op);
        metadata.put("_now", now);
        return metadata;
    }

    @Override
    public String getOp() {
        String op = super.getOp();
        if (LEGACY_NOOP_STRING.equals(op) || op == null || !this.validOps.contains(op)) {
            return "noop";
        }
        return op;
    }

    @Override
    public void setOp(String op) {
        if (LEGACY_NOOP_STRING.equals(op)) {
            throw new IllegalArgumentException("'none' is not allowed, use 'noop' instead");
        }
        if (op == null || !this.validOps.contains(op)) {
            throw new IllegalArgumentException("op must be one of [" + this.validOps.stream().sorted().collect(Collectors.joining(", ")) + "], not [" + op + "]");
        }
        super.setOp(op);
    }
}

