/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.DiffableUtils;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.script.StoredScriptSource;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentParser;

public final class ScriptMetadata
implements Metadata.Custom,
Writeable {
    private static final Logger logger = LogManager.getLogger(ScriptMetadata.class);
    public static final String TYPE = "stored_scripts";
    private final Map<String, StoredScriptSource> scripts;

    static ScriptMetadata putStoredScript(ScriptMetadata previous, String id, StoredScriptSource source) {
        Builder builder = new Builder(previous);
        builder.storeScript(id, source);
        return builder.build();
    }

    static ScriptMetadata deleteStoredScript(ScriptMetadata previous, String id) {
        Builder builder = new Builder(previous);
        builder.deleteScript(id);
        return builder.build();
    }

    public static ScriptMetadata fromXContent(XContentParser parser) throws IOException {
        HashMap<String, StoredScriptSource> scripts = new HashMap<String, StoredScriptSource>();
        String id = null;
        XContentParser.Token token = parser.currentToken();
        if (token == null) {
            token = parser.nextToken();
        }
        if (token != XContentParser.Token.START_OBJECT) {
            throw new ParsingException(parser.getTokenLocation(), "unexpected token [" + String.valueOf(token) + "], expected [{]", new Object[0]);
        }
        token = parser.nextToken();
        while (token != XContentParser.Token.END_OBJECT) {
            switch (token) {
                case FIELD_NAME: {
                    id = parser.currentName();
                    break;
                }
                case START_OBJECT: {
                    if (id == null) {
                        throw new ParsingException(parser.getTokenLocation(), "unexpected token [" + String.valueOf(token) + "], expected [<id>, <code>, {]", new Object[0]);
                    }
                    StoredScriptSource source = StoredScriptSource.fromXContent(parser, true);
                    if (source.getSource().isEmpty()) {
                        if ("mustache".equals(source.getLang())) {
                            logger.warn("empty template [" + id + "] found and dropped");
                        } else {
                            logger.warn("empty script [" + id + "] found and dropped");
                        }
                    } else {
                        scripts.put(id, source);
                    }
                    id = null;
                    break;
                }
                default: {
                    throw new ParsingException(parser.getTokenLocation(), "unexpected token [" + String.valueOf(token) + "], expected [<id>, <code>, {]", new Object[0]);
                }
            }
            token = parser.nextToken();
        }
        return new ScriptMetadata(scripts);
    }

    public static NamedDiff<Metadata.Custom> readDiffFrom(StreamInput in) throws IOException {
        return new ScriptMetadataDiff(in);
    }

    ScriptMetadata(Map<String, StoredScriptSource> scripts) {
        this.scripts = Collections.unmodifiableMap(scripts);
    }

    public ScriptMetadata(StreamInput in) throws IOException {
        HashMap<String, StoredScriptSource> scripts = new HashMap<String, StoredScriptSource>();
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            String id = in.readString();
            StoredScriptSource source = new StoredScriptSource(in);
            scripts.put(id, source);
        }
        this.scripts = Collections.unmodifiableMap(scripts);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.scripts, StreamOutput::writeWriteable);
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params ignored) {
        return Iterators.map(this.scripts.entrySet().iterator(), entry -> (builder, params) -> {
            builder.field((String)entry.getKey());
            return ((StoredScriptSource)entry.getValue()).toXContent(builder, params);
        });
    }

    @Override
    public Diff<Metadata.Custom> diff(Metadata.Custom before) {
        return new ScriptMetadataDiff((ScriptMetadata)before, this);
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.minimumCompatible();
    }

    @Override
    public EnumSet<Metadata.XContentContext> context() {
        return Metadata.ALL_CONTEXTS;
    }

    Map<String, StoredScriptSource> getStoredScripts() {
        return this.scripts;
    }

    StoredScriptSource getStoredScript(String id) {
        return this.scripts.get(id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScriptMetadata that = (ScriptMetadata)o;
        return this.scripts.equals(that.scripts);
    }

    public int hashCode() {
        return this.scripts.hashCode();
    }

    public String toString() {
        return "ScriptMetadata{scripts=" + String.valueOf(this.scripts) + "}";
    }

    public static final class Builder {
        private final Map<String, StoredScriptSource> scripts;

        public Builder(ScriptMetadata previous) {
            this.scripts = previous == null ? new HashMap<String, StoredScriptSource>() : new HashMap<String, StoredScriptSource>(previous.scripts);
        }

        public Builder storeScript(String id, StoredScriptSource source) {
            this.scripts.put(id, source);
            return this;
        }

        public Builder deleteScript(String id) {
            StoredScriptSource deleted = this.scripts.remove(id);
            if (deleted == null) {
                throw new ResourceNotFoundException("stored script [" + id + "] does not exist and cannot be deleted", new Object[0]);
            }
            return this;
        }

        public ScriptMetadata build() {
            return new ScriptMetadata(this.scripts);
        }
    }

    static final class ScriptMetadataDiff
    implements NamedDiff<Metadata.Custom> {
        final Diff<Map<String, StoredScriptSource>> pipelines;

        ScriptMetadataDiff(ScriptMetadata before, ScriptMetadata after) {
            this.pipelines = DiffableUtils.diff(before.scripts, after.scripts, DiffableUtils.getStringKeySerializer());
        }

        ScriptMetadataDiff(StreamInput in) throws IOException {
            this.pipelines = DiffableUtils.readJdkMapDiff(in, DiffableUtils.getStringKeySerializer(), StoredScriptSource::new, StoredScriptSource::readDiffFrom);
        }

        @Override
        public String getWriteableName() {
            return ScriptMetadata.TYPE;
        }

        @Override
        public Metadata.Custom apply(Metadata.Custom part) {
            return new ScriptMetadata(this.pipelines.apply(((ScriptMetadata)part).scripts));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.pipelines.writeTo(out);
        }

        @Override
        public TransportVersion getMinimalSupportedVersion() {
            return TransportVersion.minimumCompatible();
        }
    }
}

