/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.inference;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.VersionedNamedWriteable;
import org.elasticsearch.inference.ChunkingSettings;
import org.elasticsearch.inference.EmptyTaskSettings;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.inference.ToFilteredXContentObject;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class ModelConfigurations
implements ToFilteredXContentObject,
VersionedNamedWriteable {
    public static final String INDEX_ONLY_ID_FIELD_NAME = "model_id";
    public static final String INFERENCE_ID_FIELD_NAME = "inference_id";
    public static final String USE_ID_FOR_INDEX = "for_index";
    public static final String SERVICE = "service";
    public static final String SERVICE_SETTINGS = "service_settings";
    public static final String TASK_SETTINGS = "task_settings";
    public static final String CHUNKING_SETTINGS = "chunking_settings";
    private static final String NAME = "inference_model";
    private final String inferenceEntityId;
    private final TaskType taskType;
    private final String service;
    private final ServiceSettings serviceSettings;
    private final TaskSettings taskSettings;
    private final ChunkingSettings chunkingSettings;

    public static ModelConfigurations of(Model model, TaskSettings taskSettings) {
        Objects.requireNonNull(model);
        Objects.requireNonNull(taskSettings);
        return new ModelConfigurations(model.getConfigurations().getInferenceEntityId(), model.getConfigurations().getTaskType(), model.getConfigurations().getService(), model.getServiceSettings(), taskSettings, model.getConfigurations().getChunkingSettings());
    }

    public static ModelConfigurations of(Model model, ServiceSettings serviceSettings) {
        Objects.requireNonNull(model);
        Objects.requireNonNull(serviceSettings);
        return new ModelConfigurations(model.getConfigurations().getInferenceEntityId(), model.getConfigurations().getTaskType(), model.getConfigurations().getService(), serviceSettings, model.getTaskSettings(), model.getConfigurations().getChunkingSettings());
    }

    public ModelConfigurations(String inferenceEntityId, TaskType taskType, String service, ServiceSettings serviceSettings) {
        this(inferenceEntityId, taskType, service, serviceSettings, EmptyTaskSettings.INSTANCE);
    }

    public ModelConfigurations(String inferenceEntityId, TaskType taskType, String service, ServiceSettings serviceSettings, ChunkingSettings chunkingSettings) {
        this(inferenceEntityId, taskType, service, serviceSettings, EmptyTaskSettings.INSTANCE, chunkingSettings);
    }

    public ModelConfigurations(String inferenceEntityId, TaskType taskType, String service, ServiceSettings serviceSettings, TaskSettings taskSettings) {
        this.inferenceEntityId = Objects.requireNonNull(inferenceEntityId);
        this.taskType = Objects.requireNonNull(taskType);
        this.service = Objects.requireNonNull(service);
        this.serviceSettings = Objects.requireNonNull(serviceSettings);
        this.taskSettings = Objects.requireNonNull(taskSettings);
        this.chunkingSettings = null;
    }

    public ModelConfigurations(String inferenceEntityId, TaskType taskType, String service, ServiceSettings serviceSettings, TaskSettings taskSettings, ChunkingSettings chunkingSettings) {
        this.inferenceEntityId = Objects.requireNonNull(inferenceEntityId);
        this.taskType = Objects.requireNonNull(taskType);
        this.service = Objects.requireNonNull(service);
        this.serviceSettings = Objects.requireNonNull(serviceSettings);
        this.taskSettings = Objects.requireNonNull(taskSettings);
        this.chunkingSettings = chunkingSettings;
    }

    public ModelConfigurations(StreamInput in) throws IOException {
        this.inferenceEntityId = in.readString();
        this.taskType = in.readEnum(TaskType.class);
        this.service = in.readString();
        this.serviceSettings = in.readNamedWriteable(ServiceSettings.class);
        this.taskSettings = in.readNamedWriteable(TaskSettings.class);
        this.chunkingSettings = in.getTransportVersion().onOrAfter(TransportVersions.V_8_16_0) ? in.readOptionalNamedWriteable(ChunkingSettings.class) : null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.inferenceEntityId);
        out.writeEnum(this.taskType);
        out.writeString(this.service);
        out.writeNamedWriteable(this.serviceSettings);
        out.writeNamedWriteable(this.taskSettings);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_16_0)) {
            out.writeOptionalNamedWriteable(this.chunkingSettings);
        }
    }

    public String getInferenceEntityId() {
        return this.inferenceEntityId;
    }

    public TaskType getTaskType() {
        return this.taskType;
    }

    public String getService() {
        return this.service;
    }

    public ServiceSettings getServiceSettings() {
        return this.serviceSettings;
    }

    public TaskSettings getTaskSettings() {
        return this.taskSettings;
    }

    public ChunkingSettings getChunkingSettings() {
        return this.chunkingSettings;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (params.paramAsBoolean(USE_ID_FOR_INDEX, false)) {
            builder.field(INDEX_ONLY_ID_FIELD_NAME, this.inferenceEntityId);
        } else {
            builder.field(INFERENCE_ID_FIELD_NAME, this.inferenceEntityId);
        }
        builder.field("task_type", this.taskType.toString());
        builder.field(SERVICE, this.service);
        builder.field(SERVICE_SETTINGS, (ToXContent)this.serviceSettings);
        if (params.paramAsBoolean(USE_ID_FOR_INDEX, false) || this.taskSettings != null && !this.taskSettings.isEmpty()) {
            builder.field(TASK_SETTINGS, (ToXContent)this.taskSettings);
        }
        if (this.chunkingSettings != null) {
            builder.field(CHUNKING_SETTINGS, (ToXContent)this.chunkingSettings);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public XContentBuilder toFilteredXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (params.paramAsBoolean(USE_ID_FOR_INDEX, false)) {
            builder.field(INDEX_ONLY_ID_FIELD_NAME, this.inferenceEntityId);
        } else {
            builder.field(INFERENCE_ID_FIELD_NAME, this.inferenceEntityId);
        }
        builder.field("task_type", this.taskType.toString());
        builder.field(SERVICE, this.service);
        builder.field(SERVICE_SETTINGS, (ToXContent)this.serviceSettings.getFilteredXContentObject());
        if (params.paramAsBoolean(USE_ID_FOR_INDEX, false) || this.taskSettings != null && !this.taskSettings.isEmpty()) {
            builder.field(TASK_SETTINGS, (ToXContent)this.taskSettings);
        }
        if (this.chunkingSettings != null) {
            builder.field(CHUNKING_SETTINGS, (ToXContent)this.chunkingSettings);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_11_X;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelConfigurations model = (ModelConfigurations)o;
        return Objects.equals(this.inferenceEntityId, model.inferenceEntityId) && this.taskType == model.taskType && Objects.equals(this.service, model.service) && Objects.equals(this.serviceSettings, model.serviceSettings) && Objects.equals(this.taskSettings, model.taskSettings);
    }

    public int hashCode() {
        return Objects.hash(this.inferenceEntityId, this.taskType, this.service, this.serviceSettings, this.taskSettings);
    }
}

