/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.text.ParseException;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.geo.GeometryParser;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.geo.SpatialStrategy;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.index.mapper.GeoShapeQueryable;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.AbstractGeometryQueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class GeoShapeQueryBuilder
extends AbstractGeometryQueryBuilder<GeoShapeQueryBuilder> {
    public static final String NAME = "geo_shape";
    protected static final ParseField STRATEGY_FIELD = new ParseField("strategy", new String[0]);
    private SpatialStrategy strategy;

    public GeoShapeQueryBuilder(String fieldName, Geometry shape) {
        super(fieldName, shape);
    }

    public GeoShapeQueryBuilder(String fieldName, Supplier<Geometry> shapeSupplier, String indexedShapeId) {
        super(fieldName, shapeSupplier, indexedShapeId);
    }

    public GeoShapeQueryBuilder(String fieldName, String indexedShapeId) {
        super(fieldName, indexedShapeId);
    }

    public GeoShapeQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.strategy = in.readOptionalWriteable(SpatialStrategy::readFromStream);
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        super.doWriteTo(out);
        out.writeOptionalWriteable(this.strategy);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public GeoShapeQueryBuilder relation(ShapeRelation relation) {
        if (relation == null) {
            throw new IllegalArgumentException("No Shape Relation defined");
        }
        if (SpatialStrategy.TERM.equals(this.strategy) && relation != ShapeRelation.INTERSECTS) {
            throw new IllegalArgumentException("current strategy [" + this.strategy.getStrategyName() + "] only supports relation [" + ShapeRelation.INTERSECTS.getRelationName() + "] found relation [" + relation.getRelationName() + "]");
        }
        this.relation = relation;
        return this;
    }

    public GeoShapeQueryBuilder strategy(SpatialStrategy strategy) {
        if (strategy == SpatialStrategy.TERM && this.relation != ShapeRelation.INTERSECTS) {
            throw new IllegalArgumentException("strategy [" + strategy.getStrategyName() + "] only supports relation [" + ShapeRelation.INTERSECTS.getRelationName() + "] found relation [" + this.relation.getRelationName() + "]");
        }
        this.strategy = strategy;
        return this;
    }

    public SpatialStrategy strategy() {
        return this.strategy;
    }

    @Override
    public void doShapeQueryXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.strategy != null) {
            builder.field(STRATEGY_FIELD.getPreferredName(), this.strategy.getStrategyName());
        }
    }

    protected GeoShapeQueryBuilder newShapeQueryBuilder(String fieldName, Geometry shape) {
        return new GeoShapeQueryBuilder(fieldName, shape);
    }

    protected GeoShapeQueryBuilder newShapeQueryBuilder(String fieldName, Supplier<Geometry> shapeSupplier, String indexedShapeId) {
        return new GeoShapeQueryBuilder(fieldName, shapeSupplier, indexedShapeId);
    }

    @Override
    public Query buildShapeQuery(SearchExecutionContext context, MappedFieldType fieldType) {
        if (!(fieldType instanceof GeoShapeQueryable)) {
            throw new QueryShardException((QueryRewriteContext)context, "Field [" + this.fieldName + "] is of unsupported type [" + fieldType.typeName() + "] for [geo_shape] query", new Object[0]);
        }
        GeoShapeQueryable ft = (GeoShapeQueryable)((Object)fieldType);
        return new ConstantScoreQuery(ft.geoShapeQuery(context, fieldType.name(), this.strategy, this.relation, this.shape));
    }

    @Override
    protected boolean doEquals(GeoShapeQueryBuilder other) {
        return super.doEquals(other) && Objects.equals(this.strategy, other.strategy);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(super.doHashCode(), this.strategy);
    }

    @Override
    protected GeoShapeQueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
        GeoShapeQueryBuilder builder = (GeoShapeQueryBuilder)super.doRewrite(queryRewriteContext);
        builder.strategy(this.strategy);
        return builder;
    }

    public static GeoShapeQueryBuilder fromXContent(XContentParser parser) throws IOException {
        ParsedGeoShapeQueryParams pgsqp = (ParsedGeoShapeQueryParams)AbstractGeometryQueryBuilder.parsedParamsFromXContent(parser, new ParsedGeoShapeQueryParams());
        GeoShapeQueryBuilder builder = pgsqp.shape != null ? new GeoShapeQueryBuilder(pgsqp.fieldName, pgsqp.shape) : new GeoShapeQueryBuilder(pgsqp.fieldName, pgsqp.id);
        if (pgsqp.index != null) {
            builder.indexedShapeIndex(pgsqp.index);
        }
        if (pgsqp.shapePath != null) {
            builder.indexedShapePath(pgsqp.shapePath);
        }
        if (pgsqp.shapeRouting != null) {
            builder.indexedShapeRouting(pgsqp.shapeRouting);
        }
        if (pgsqp.relation != null) {
            builder.relation(pgsqp.relation);
        }
        if (pgsqp.strategy != null) {
            builder.strategy(pgsqp.strategy);
        }
        if (pgsqp.queryName != null) {
            builder.queryName(pgsqp.queryName);
        }
        builder.boost(pgsqp.boost);
        builder.ignoreUnmapped(pgsqp.ignoreUnmapped);
        return builder;
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.zero();
    }

    private static class ParsedGeoShapeQueryParams
    extends AbstractGeometryQueryBuilder.ParsedGeometryQueryParams {
        SpatialStrategy strategy;
        private final GeometryParser geometryParser = new GeometryParser(true, true, true);

        private ParsedGeoShapeQueryParams() {
        }

        @Override
        protected boolean parseXContentField(XContentParser parser) throws IOException {
            if (AbstractGeometryQueryBuilder.SHAPE_FIELD.match(parser.currentName(), parser.getDeprecationHandler())) {
                try {
                    this.shape = this.geometryParser.parse(parser);
                }
                catch (ParseException e) {
                    throw new IOException(e);
                }
                return true;
            }
            if (STRATEGY_FIELD.match(parser.currentName(), parser.getDeprecationHandler())) {
                SpatialStrategy strategy;
                String strategyName = parser.text();
                this.strategy = strategy = SpatialStrategy.fromString(strategyName);
                return true;
            }
            return false;
        }
    }
}

