/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.health.node.tracker;

import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.indices.stats.CommonStatsFlags;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.DiskUsage;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.health.HealthStatus;
import org.elasticsearch.health.metadata.HealthMetadata;
import org.elasticsearch.health.node.DiskHealthInfo;
import org.elasticsearch.health.node.UpdateHealthInfoCacheAction;
import org.elasticsearch.health.node.tracker.HealthTracker;
import org.elasticsearch.node.NodeService;

public class DiskHealthTracker
extends HealthTracker<DiskHealthInfo> {
    private static final Logger logger = LogManager.getLogger(DiskHealthTracker.class);
    private final NodeService nodeService;
    private final ClusterService clusterService;

    public DiskHealthTracker(NodeService nodeService, ClusterService clusterService) {
        this.nodeService = nodeService;
        this.clusterService = clusterService;
    }

    @Override
    protected DiskHealthInfo determineCurrentHealth() {
        ClusterState clusterState = this.clusterService.state();
        HealthMetadata healthMetadata = HealthMetadata.getFromClusterState(clusterState);
        DiscoveryNode node = clusterState.getNodes().getLocalNode();
        HealthMetadata.Disk diskMetadata = healthMetadata.getDiskMetadata();
        DiskUsage usage = this.getDiskUsage();
        if (usage == null) {
            return new DiskHealthInfo(HealthStatus.UNKNOWN, DiskHealthInfo.Cause.NODE_HAS_NO_DISK_STATS);
        }
        ByteSizeValue totalBytes = ByteSizeValue.ofBytes(usage.totalBytes());
        if (node.isDedicatedFrozenNode() || DiskHealthTracker.isDedicatedSearchNode(node)) {
            long frozenFloodStageThreshold = diskMetadata.getFreeBytesFrozenFloodStageWatermark(totalBytes).getBytes();
            if (usage.freeBytes() < frozenFloodStageThreshold) {
                logger.debug("Flood stage disk watermark [{}] exceeded on {}", (Object)frozenFloodStageThreshold, (Object)usage);
                return new DiskHealthInfo(HealthStatus.RED, DiskHealthInfo.Cause.FROZEN_NODE_OVER_FLOOD_STAGE_THRESHOLD);
            }
            return new DiskHealthInfo(HealthStatus.GREEN);
        }
        long floodStageThreshold = diskMetadata.getFreeBytesFloodStageWatermark(totalBytes).getBytes();
        if (usage.freeBytes() < floodStageThreshold) {
            logger.debug("Flood stage disk watermark [{}] exceeded on {}", (Object)floodStageThreshold, (Object)usage);
            return new DiskHealthInfo(HealthStatus.RED, DiskHealthInfo.Cause.NODE_OVER_THE_FLOOD_STAGE_THRESHOLD);
        }
        long highThreshold = diskMetadata.getFreeBytesHighWatermark(totalBytes).getBytes();
        if (usage.freeBytes() < highThreshold) {
            if (node.canContainData()) {
                if (!DiskHealthTracker.hasRelocatingShards(clusterState, node)) {
                    logger.debug("High disk watermark [{}] exceeded on {}", (Object)highThreshold, (Object)usage);
                    return new DiskHealthInfo(HealthStatus.YELLOW, DiskHealthInfo.Cause.NODE_OVER_HIGH_THRESHOLD);
                }
            } else {
                logger.debug("High disk watermark [{}] exceeded on {}", (Object)highThreshold, (Object)usage);
                return new DiskHealthInfo(HealthStatus.YELLOW, DiskHealthInfo.Cause.NODE_OVER_HIGH_THRESHOLD);
            }
        }
        return new DiskHealthInfo(HealthStatus.GREEN);
    }

    @Override
    protected void addToRequestBuilder(UpdateHealthInfoCacheAction.Request.Builder builder, DiskHealthInfo healthInfo) {
        builder.diskHealthInfo(healthInfo);
    }

    private static boolean isDedicatedSearchNode(DiscoveryNode node) {
        Set<DiscoveryNodeRole> roles = node.getRoles();
        return roles.contains(DiscoveryNodeRole.SEARCH_ROLE) && !roles.stream().filter(DiscoveryNodeRole::canContainData).anyMatch(r -> r != DiscoveryNodeRole.SEARCH_ROLE);
    }

    private DiskUsage getDiskUsage() {
        NodeStats nodeStats = this.nodeService.stats(CommonStatsFlags.NONE, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false);
        return DiskUsage.findLeastAvailablePath(nodeStats);
    }

    static boolean hasRelocatingShards(ClusterState clusterState, DiscoveryNode node) {
        RoutingNode routingNode = clusterState.getRoutingNodes().node(node.getId());
        if (routingNode == null) {
            return false;
        }
        return routingNode.numberOfShardsWithState(ShardRoutingState.RELOCATING) > 0;
    }
}

