/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.features;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.Strings;
import org.elasticsearch.features.FeatureSpecification;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;

public class FeatureData {
    private static final Logger Log = LogManager.getLogger(FeatureData.class);
    private static final boolean INCLUDE_TEST_FEATURES = System.getProperty("tests.testfeatures.enabled", "").equals("true");
    private final Map<String, NodeFeature> nodeFeatures;

    private FeatureData(Map<String, NodeFeature> nodeFeatures) {
        this.nodeFeatures = nodeFeatures;
    }

    public static FeatureData createFromSpecifications(List<? extends FeatureSpecification> specs) {
        HashMap<String, FeatureSpecification> allFeatures = new HashMap<String, FeatureSpecification>();
        HashMap<String, NodeFeature> nodeFeatures = new HashMap<String, NodeFeature>();
        for (FeatureSpecification featureSpecification : specs) {
            Set<NodeFeature> specFeatures = featureSpecification.getFeatures();
            if (INCLUDE_TEST_FEATURES) {
                specFeatures = new HashSet<NodeFeature>(specFeatures);
                specFeatures.addAll(featureSpecification.getTestFeatures());
            }
            for (NodeFeature f : specFeatures) {
                FeatureSpecification existing = allFeatures.putIfAbsent(f.id(), featureSpecification);
                if (existing != null && existing.getClass() != featureSpecification.getClass()) {
                    throw new IllegalArgumentException(Strings.format("Duplicate feature - [%s] is declared by both [%s] and [%s]", f.id(), existing, featureSpecification));
                }
                nodeFeatures.put(f.id(), f);
            }
        }
        return new FeatureData(Map.copyOf(nodeFeatures));
    }

    public Map<String, NodeFeature> getNodeFeatures() {
        return this.nodeFeatures;
    }

    static {
        if (INCLUDE_TEST_FEATURES) {
            Log.warn("WARNING: Test features are enabled. This should ONLY be used in automated tests.");
        }
    }
}

