/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.get;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.admin.cluster.snapshots.get.SnapshotSortKey;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;

public class GetSnapshotsRequest
extends MasterNodeRequest<GetSnapshotsRequest> {
    public static final String CURRENT_SNAPSHOT = "_current";
    public static final String NO_POLICY_PATTERN = "_none";
    public static final boolean DEFAULT_VERBOSE_MODE = true;
    private static final TransportVersion INDICES_FLAG_VERSION = TransportVersions.V_8_3_0;
    public static final int NO_LIMIT = -1;
    private int size = -1;
    private int offset = 0;
    @Nullable
    private SnapshotSortKey.After after;
    @Nullable
    private String fromSortValue;
    private SnapshotSortKey sort = SnapshotSortKey.START_TIME;
    private SortOrder order = SortOrder.ASC;
    private String[] repositories;
    private String[] snapshots = Strings.EMPTY_ARRAY;
    private String[] policies = Strings.EMPTY_ARRAY;
    private boolean ignoreUnavailable;
    private boolean verbose = true;
    private boolean includeIndexNames = true;

    public GetSnapshotsRequest(TimeValue masterNodeTimeout) {
        super(masterNodeTimeout);
    }

    public GetSnapshotsRequest(TimeValue masterNodeTimeout, String[] repositories, String[] snapshots) {
        this(masterNodeTimeout, repositories);
        this.snapshots = snapshots;
    }

    public GetSnapshotsRequest(TimeValue masterNodeTimeout, String ... repositories) {
        this(masterNodeTimeout);
        this.repositories = repositories;
    }

    public GetSnapshotsRequest(StreamInput in) throws IOException {
        super(in);
        this.repositories = in.readStringArray();
        this.snapshots = in.readStringArray();
        this.ignoreUnavailable = in.readBoolean();
        this.verbose = in.readBoolean();
        this.after = in.readOptionalWriteable(SnapshotSortKey.After::new);
        this.sort = in.readEnum(SnapshotSortKey.class);
        this.size = in.readVInt();
        this.order = SortOrder.readFromStream(in);
        this.offset = in.readVInt();
        this.policies = in.readStringArray();
        this.fromSortValue = in.readOptionalString();
        if (in.getTransportVersion().onOrAfter(INDICES_FLAG_VERSION)) {
            this.includeIndexNames = in.readBoolean();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.repositories);
        out.writeStringArray(this.snapshots);
        out.writeBoolean(this.ignoreUnavailable);
        out.writeBoolean(this.verbose);
        out.writeOptionalWriteable(this.after);
        out.writeEnum(this.sort);
        out.writeVInt(this.size);
        this.order.writeTo(out);
        out.writeVInt(this.offset);
        out.writeStringArray(this.policies);
        out.writeOptionalString(this.fromSortValue);
        if (out.getTransportVersion().onOrAfter(INDICES_FLAG_VERSION)) {
            out.writeBoolean(this.includeIndexNames);
        }
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.repositories == null || this.repositories.length == 0) {
            validationException = ValidateActions.addValidationError("repositories are missing", validationException);
        }
        if (this.size == 0 || this.size < -1) {
            validationException = ValidateActions.addValidationError("size must be -1 or greater than 0", validationException);
        }
        if (!this.verbose) {
            if (this.sort != SnapshotSortKey.START_TIME) {
                validationException = ValidateActions.addValidationError("can't use non-default sort with verbose=false", validationException);
            }
            if (this.size > 0) {
                validationException = ValidateActions.addValidationError("can't use size limit with verbose=false", validationException);
            }
            if (this.offset > 0) {
                validationException = ValidateActions.addValidationError("can't use offset with verbose=false", validationException);
            }
            if (this.after != null) {
                validationException = ValidateActions.addValidationError("can't use after with verbose=false", validationException);
            }
            if (this.order != SortOrder.ASC) {
                validationException = ValidateActions.addValidationError("can't use non-default sort order with verbose=false", validationException);
            }
            if (this.policies.length != 0) {
                validationException = ValidateActions.addValidationError("can't use slm policy filter with verbose=false", validationException);
            }
            if (this.fromSortValue != null) {
                validationException = ValidateActions.addValidationError("can't use from_sort_value with verbose=false", validationException);
            }
        } else if (this.offset > 0) {
            if (this.after != null) {
                validationException = ValidateActions.addValidationError("can't use after and offset simultaneously", validationException);
            }
        } else if (this.after != null && this.fromSortValue != null) {
            validationException = ValidateActions.addValidationError("can't use after and from_sort_value simultaneously", validationException);
        }
        return validationException;
    }

    public GetSnapshotsRequest repositories(String ... repositories) {
        this.repositories = repositories;
        return this;
    }

    public String[] repositories() {
        return this.repositories;
    }

    public GetSnapshotsRequest policies(String ... policies) {
        this.policies = policies;
        return this;
    }

    public String[] policies() {
        return this.policies;
    }

    public String[] snapshots() {
        return this.snapshots;
    }

    public GetSnapshotsRequest snapshots(String[] snapshots) {
        this.snapshots = snapshots;
        return this;
    }

    public GetSnapshotsRequest ignoreUnavailable(boolean ignoreUnavailable) {
        this.ignoreUnavailable = ignoreUnavailable;
        return this;
    }

    public boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    public GetSnapshotsRequest verbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    public GetSnapshotsRequest includeIndexNames(boolean indices) {
        this.includeIndexNames = indices;
        return this;
    }

    public boolean includeIndexNames() {
        return this.includeIndexNames;
    }

    @Nullable
    public SnapshotSortKey.After after() {
        return this.after;
    }

    public SnapshotSortKey sort() {
        return this.sort;
    }

    public GetSnapshotsRequest after(@Nullable SnapshotSortKey.After after) {
        this.after = after;
        return this;
    }

    public GetSnapshotsRequest fromSortValue(@Nullable String fromSortValue) {
        this.fromSortValue = fromSortValue;
        return this;
    }

    @Nullable
    public String fromSortValue() {
        return this.fromSortValue;
    }

    public GetSnapshotsRequest sort(SnapshotSortKey sort) {
        this.sort = sort;
        return this;
    }

    public GetSnapshotsRequest size(int size) {
        this.size = size;
        return this;
    }

    public int size() {
        return this.size;
    }

    public int offset() {
        return this.offset;
    }

    public GetSnapshotsRequest offset(int offset) {
        this.offset = offset;
        return this;
    }

    public SortOrder order() {
        return this.order;
    }

    public GetSnapshotsRequest order(SortOrder order) {
        this.order = order;
        return this;
    }

    public boolean verbose() {
        return this.verbose;
    }

    @Override
    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new CancellableTask(id, type, action, this.getDescription(), parentTaskId, headers);
    }

    @Override
    public String getDescription() {
        StringBuilder stringBuilder = new StringBuilder("repositories[");
        Strings.collectionToDelimitedStringWithLimit(Arrays.asList(this.repositories), ",", 512, stringBuilder);
        stringBuilder.append("], snapshots[");
        Strings.collectionToDelimitedStringWithLimit(Arrays.asList(this.snapshots), ",", 1024, stringBuilder);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

