/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.ibmwatsonx;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.util.LazyInitializable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.ChunkedInference;
import org.elasticsearch.inference.ChunkingSettings;
import org.elasticsearch.inference.InferenceServiceConfiguration;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.SettingsConfiguration;
import org.elasticsearch.inference.SimilarityMeasure;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.inference.configuration.SettingsConfigurationFieldType;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.inference.chunking.ChunkingSettingsBuilder;
import org.elasticsearch.xpack.inference.chunking.EmbeddingRequestChunker;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.ibmwatsonx.IbmWatsonxActionCreator;
import org.elasticsearch.xpack.inference.external.http.sender.DocumentsOnlyInput;
import org.elasticsearch.xpack.inference.external.http.sender.HttpRequestSender;
import org.elasticsearch.xpack.inference.external.http.sender.InferenceInputs;
import org.elasticsearch.xpack.inference.external.http.sender.Sender;
import org.elasticsearch.xpack.inference.external.http.sender.UnifiedChatInput;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.SenderService;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.ibmwatsonx.IbmWatsonxModel;
import org.elasticsearch.xpack.inference.services.ibmwatsonx.embeddings.IbmWatsonxEmbeddingsModel;
import org.elasticsearch.xpack.inference.services.ibmwatsonx.embeddings.IbmWatsonxEmbeddingsServiceSettings;
import org.elasticsearch.xpack.inference.services.ibmwatsonx.rerank.IbmWatsonxRerankModel;
import org.elasticsearch.xpack.inference.services.validation.ModelValidatorBuilder;

public class IbmWatsonxService
extends SenderService {
    public static final String NAME = "watsonxai";
    private static final String SERVICE_NAME = "IBM Watsonx";
    private static final EnumSet<TaskType> supportedTaskTypes = EnumSet.of(TaskType.TEXT_EMBEDDING);

    public IbmWatsonxService(HttpRequestSender.Factory factory, ServiceComponents serviceComponents) {
        super(factory, serviceComponents);
    }

    public String name() {
        return NAME;
    }

    public void parseRequestConfig(String inferenceEntityId, TaskType taskType, Map<String, Object> config, ActionListener<Model> parsedModelListener) {
        try {
            Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings");
            Map<String, Object> taskSettingsMap = ServiceUtils.removeFromMapOrDefaultEmpty(config, "task_settings");
            ChunkingSettings chunkingSettings = null;
            if (TaskType.TEXT_EMBEDDING.equals((Object)taskType)) {
                chunkingSettings = ChunkingSettingsBuilder.fromMap(ServiceUtils.removeFromMapOrDefaultEmpty(config, "chunking_settings"));
            }
            IbmWatsonxModel model = IbmWatsonxService.createModel(inferenceEntityId, taskType, serviceSettingsMap, taskSettingsMap, chunkingSettings, serviceSettingsMap, TaskType.unsupportedTaskTypeErrorMsg((TaskType)taskType, (String)NAME), ConfigurationParseContext.REQUEST);
            ServiceUtils.throwIfNotEmptyMap(config, NAME);
            ServiceUtils.throwIfNotEmptyMap(serviceSettingsMap, NAME);
            ServiceUtils.throwIfNotEmptyMap(taskSettingsMap, NAME);
            parsedModelListener.onResponse((Object)model);
        }
        catch (Exception e) {
            parsedModelListener.onFailure(e);
        }
    }

    private static IbmWatsonxModel createModel(String inferenceEntityId, TaskType taskType, Map<String, Object> serviceSettings, Map<String, Object> taskSettings, ChunkingSettings chunkingSettings, @Nullable Map<String, Object> secretSettings, String failureMessage, ConfigurationParseContext context) {
        return switch (taskType) {
            case TaskType.TEXT_EMBEDDING -> new IbmWatsonxEmbeddingsModel(inferenceEntityId, taskType, NAME, serviceSettings, taskSettings, chunkingSettings, secretSettings, context);
            case TaskType.RERANK -> new IbmWatsonxRerankModel(inferenceEntityId, taskType, NAME, serviceSettings, taskSettings, secretSettings, context);
            default -> throw new ElasticsearchStatusException(failureMessage, RestStatus.BAD_REQUEST, new Object[0]);
        };
    }

    public IbmWatsonxModel parsePersistedConfigWithSecrets(String inferenceEntityId, TaskType taskType, Map<String, Object> config, Map<String, Object> secrets) {
        Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings");
        Map<String, Object> taskSettingsMap = ServiceUtils.removeFromMapOrDefaultEmpty(config, "task_settings");
        Map<String, Object> secretSettingsMap = ServiceUtils.removeFromMapOrDefaultEmpty(secrets, "secret_settings");
        ChunkingSettings chunkingSettings = null;
        if (TaskType.TEXT_EMBEDDING.equals((Object)taskType)) {
            chunkingSettings = ChunkingSettingsBuilder.fromMap(ServiceUtils.removeFromMapOrDefaultEmpty(config, "chunking_settings"));
        }
        return IbmWatsonxService.createModelFromPersistent(inferenceEntityId, taskType, serviceSettingsMap, taskSettingsMap, chunkingSettings, secretSettingsMap, ServiceUtils.parsePersistedConfigErrorMsg(inferenceEntityId, NAME));
    }

    public InferenceServiceConfiguration getConfiguration() {
        return Configuration.get();
    }

    public EnumSet<TaskType> supportedTaskTypes() {
        return supportedTaskTypes;
    }

    private static IbmWatsonxModel createModelFromPersistent(String inferenceEntityId, TaskType taskType, Map<String, Object> serviceSettings, Map<String, Object> taskSettings, ChunkingSettings chunkingSettings, Map<String, Object> secretSettings, String failureMessage) {
        return IbmWatsonxService.createModel(inferenceEntityId, taskType, serviceSettings, taskSettings, chunkingSettings, secretSettings, failureMessage, ConfigurationParseContext.PERSISTENT);
    }

    public Model parsePersistedConfig(String inferenceEntityId, TaskType taskType, Map<String, Object> config) {
        Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings");
        Map<String, Object> taskSettingsMap = ServiceUtils.removeFromMapOrDefaultEmpty(config, "task_settings");
        ChunkingSettings chunkingSettings = null;
        if (TaskType.TEXT_EMBEDDING.equals((Object)taskType)) {
            chunkingSettings = ChunkingSettingsBuilder.fromMap(ServiceUtils.removeFromMapOrDefaultEmpty(config, "chunking_settings"));
        }
        return IbmWatsonxService.createModelFromPersistent(inferenceEntityId, taskType, serviceSettingsMap, taskSettingsMap, chunkingSettings, null, ServiceUtils.parsePersistedConfigErrorMsg(inferenceEntityId, NAME));
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_16_0;
    }

    public void checkModelConfig(Model model, ActionListener<Model> listener) {
        ModelValidatorBuilder.buildModelValidator(model.getTaskType()).validate(this, model, listener);
    }

    public Model updateModelWithEmbeddingDetails(Model model, int embeddingSize) {
        if (model instanceof IbmWatsonxEmbeddingsModel) {
            IbmWatsonxEmbeddingsModel embeddingsModel = (IbmWatsonxEmbeddingsModel)model;
            IbmWatsonxEmbeddingsServiceSettings serviceSettings = embeddingsModel.getServiceSettings();
            SimilarityMeasure similarityFromModel = serviceSettings.similarity();
            SimilarityMeasure similarityToUse = similarityFromModel == null ? SimilarityMeasure.DOT_PRODUCT : similarityFromModel;
            IbmWatsonxEmbeddingsServiceSettings updatedServiceSettings = new IbmWatsonxEmbeddingsServiceSettings(serviceSettings.modelId(), serviceSettings.projectId(), serviceSettings.url(), serviceSettings.apiVersion(), serviceSettings.maxInputTokens(), embeddingSize, similarityToUse, serviceSettings.rateLimitSettings());
            return new IbmWatsonxEmbeddingsModel(embeddingsModel, updatedServiceSettings);
        }
        throw ServiceUtils.invalidModelTypeForUpdateModelWithEmbeddingDetails(model.getClass());
    }

    @Override
    protected void doInfer(Model model, InferenceInputs input, Map<String, Object> taskSettings, InputType inputType, TimeValue timeout, ActionListener<InferenceServiceResults> listener) {
        if (!(model instanceof IbmWatsonxModel)) {
            listener.onFailure((Exception)((Object)ServiceUtils.createInvalidModelException(model)));
            return;
        }
        IbmWatsonxModel ibmWatsonxModel = (IbmWatsonxModel)model;
        ExecutableAction action = ibmWatsonxModel.accept(this.getActionCreator(this.getSender(), this.getServiceComponents()), taskSettings, inputType);
        action.execute(input, timeout, listener);
    }

    @Override
    protected void doUnifiedCompletionInfer(Model model, UnifiedChatInput inputs, TimeValue timeout, ActionListener<InferenceServiceResults> listener) {
        ServiceUtils.throwUnsupportedUnifiedCompletionOperation(NAME);
    }

    @Override
    protected void doChunkedInfer(Model model, DocumentsOnlyInput input, Map<String, Object> taskSettings, InputType inputType, TimeValue timeout, ActionListener<List<ChunkedInference>> listener) {
        IbmWatsonxModel ibmWatsonxModel = (IbmWatsonxModel)model;
        List<EmbeddingRequestChunker.BatchRequestAndListener> batchedRequests = new EmbeddingRequestChunker(input.getInputs(), 1000, EmbeddingRequestChunker.EmbeddingType.FLOAT, model.getConfigurations().getChunkingSettings()).batchRequestsWithListeners(listener);
        for (EmbeddingRequestChunker.BatchRequestAndListener request : batchedRequests) {
            ExecutableAction action = ibmWatsonxModel.accept(this.getActionCreator(this.getSender(), this.getServiceComponents()), taskSettings, inputType);
            action.execute(new DocumentsOnlyInput(request.batch().inputs()), timeout, request.listener());
        }
    }

    protected IbmWatsonxActionCreator getActionCreator(Sender sender, ServiceComponents serviceComponents) {
        return new IbmWatsonxActionCreator(this.getSender(), this.getServiceComponents());
    }

    public static class Configuration {
        private static final LazyInitializable<InferenceServiceConfiguration, RuntimeException> configuration = new LazyInitializable(() -> {
            HashMap<String, SettingsConfiguration> configurationMap = new HashMap<String, SettingsConfiguration>();
            configurationMap.put("api_version", new SettingsConfiguration.Builder(supportedTaskTypes).setDescription("The IBM Watsonx API version ID to use.").setLabel("API Version").setRequired(Boolean.valueOf(true)).setSensitive(Boolean.valueOf(false)).setUpdatable(Boolean.valueOf(false)).setType(SettingsConfigurationFieldType.STRING).build());
            configurationMap.put("project_id", new SettingsConfiguration.Builder(supportedTaskTypes).setDescription("").setLabel("Project ID").setRequired(Boolean.valueOf(true)).setSensitive(Boolean.valueOf(false)).setUpdatable(Boolean.valueOf(false)).setType(SettingsConfigurationFieldType.STRING).build());
            configurationMap.put("model_id", new SettingsConfiguration.Builder(supportedTaskTypes).setDescription("The name of the model to use for the inference task.").setLabel("Model ID").setRequired(Boolean.valueOf(true)).setSensitive(Boolean.valueOf(false)).setUpdatable(Boolean.valueOf(false)).setType(SettingsConfigurationFieldType.STRING).build());
            configurationMap.put("url", new SettingsConfiguration.Builder(supportedTaskTypes).setDescription("").setLabel("URL").setRequired(Boolean.valueOf(true)).setSensitive(Boolean.valueOf(false)).setUpdatable(Boolean.valueOf(false)).setType(SettingsConfigurationFieldType.STRING).build());
            configurationMap.put("max_input_tokens", new SettingsConfiguration.Builder(EnumSet.of(TaskType.TEXT_EMBEDDING)).setDescription("Allows you to specify the maximum number of tokens per input.").setLabel("Maximum Input Tokens").setRequired(Boolean.valueOf(false)).setSensitive(Boolean.valueOf(false)).setUpdatable(Boolean.valueOf(false)).setType(SettingsConfigurationFieldType.INTEGER).build());
            return new InferenceServiceConfiguration.Builder().setService(IbmWatsonxService.NAME).setName(IbmWatsonxService.SERVICE_NAME).setTaskTypes(supportedTaskTypes).setConfigurations(configurationMap).build();
        });

        public static InferenceServiceConfiguration get() {
            return (InferenceServiceConfiguration)configuration.getOrCompute();
        }
    }
}

