/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.amazonbedrock.embeddings;

import java.util.Map;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.inference.ChunkingSettings;
import org.elasticsearch.inference.EmptyTaskSettings;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.amazonbedrock.AmazonBedrockActionVisitor;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.amazonbedrock.AmazonBedrockModel;
import org.elasticsearch.xpack.inference.services.amazonbedrock.AmazonBedrockSecretSettings;
import org.elasticsearch.xpack.inference.services.amazonbedrock.embeddings.AmazonBedrockEmbeddingsServiceSettings;

public class AmazonBedrockEmbeddingsModel
extends AmazonBedrockModel {
    public static AmazonBedrockEmbeddingsModel of(AmazonBedrockEmbeddingsModel embeddingsModel, Map<String, Object> taskSettings) {
        if (taskSettings != null && !taskSettings.isEmpty()) {
            ValidationException validationException = new ValidationException();
            validationException.addValidationError("Amazon Bedrock embeddings model cannot have task settings");
            throw validationException;
        }
        return embeddingsModel;
    }

    public AmazonBedrockEmbeddingsModel(String inferenceEntityId, TaskType taskType, String service, Map<String, Object> serviceSettings, Map<String, Object> taskSettings, ChunkingSettings chunkingSettings, Map<String, Object> secretSettings, ConfigurationParseContext context) {
        this(inferenceEntityId, taskType, service, AmazonBedrockEmbeddingsServiceSettings.fromMap(serviceSettings, context), (TaskSettings)new EmptyTaskSettings(), chunkingSettings, AmazonBedrockSecretSettings.fromMap(secretSettings));
    }

    public AmazonBedrockEmbeddingsModel(String inferenceEntityId, TaskType taskType, String service, AmazonBedrockEmbeddingsServiceSettings serviceSettings, TaskSettings taskSettings, ChunkingSettings chunkingSettings, AmazonBedrockSecretSettings secrets) {
        super(new ModelConfigurations(inferenceEntityId, taskType, service, (ServiceSettings)serviceSettings, (TaskSettings)new EmptyTaskSettings(), chunkingSettings), new ModelSecrets((SecretSettings)secrets));
    }

    public AmazonBedrockEmbeddingsModel(Model model, ServiceSettings serviceSettings) {
        super(model, serviceSettings);
    }

    @Override
    public ExecutableAction accept(AmazonBedrockActionVisitor creator, Map<String, Object> taskSettings) {
        return creator.create(this, taskSettings);
    }

    @Override
    public AmazonBedrockEmbeddingsServiceSettings getServiceSettings() {
        return (AmazonBedrockEmbeddingsServiceSettings)super.getServiceSettings();
    }
}

