/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.alibabacloudsearch;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.alibabacloudsearch.AlibabaCloudSearchRateLimitServiceSettings;
import org.elasticsearch.xpack.inference.services.settings.FilteredXContentObject;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public class AlibabaCloudSearchServiceSettings
extends FilteredXContentObject
implements ServiceSettings,
AlibabaCloudSearchRateLimitServiceSettings {
    public static final String NAME = "alibabacloud_search_service_settings";
    public static final String SERVICE_ID = "service_id";
    public static final String HOST = "host";
    public static final String WORKSPACE_NAME = "workspace";
    public static final String HTTP_SCHEMA_NAME = "http_schema";
    private static final RateLimitSettings DEFAULT_RATE_LIMIT_SETTINGS = new RateLimitSettings(1000L);
    private final String serviceId;
    private final String host;
    private final String workspaceName;
    private final String httpSchema;
    private final RateLimitSettings rateLimitSettings;

    public static AlibabaCloudSearchServiceSettings fromMap(Map<String, Object> map, ConfigurationParseContext context) {
        Set<String> validSchemas;
        ValidationException validationException = new ValidationException();
        String modelId = ServiceUtils.extractRequiredString(map, SERVICE_ID, "service_settings", validationException);
        String host = ServiceUtils.extractRequiredString(map, HOST, "service_settings", validationException);
        String workspaceName = ServiceUtils.extractRequiredString(map, WORKSPACE_NAME, "service_settings", validationException);
        String httpSchema = ServiceUtils.extractOptionalString(map, HTTP_SCHEMA_NAME, "service_settings", validationException);
        if (httpSchema != null && !(validSchemas = Set.of("https", "http")).contains(httpSchema)) {
            validationException.addValidationError("Invalid value for [http_schema]. Must be one of [https, http]");
        }
        RateLimitSettings rateLimitSettings = RateLimitSettings.of(map, DEFAULT_RATE_LIMIT_SETTINGS, validationException, "alibabacloud-ai-search", context);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new AlibabaCloudSearchServiceSettings(modelId, host, workspaceName, httpSchema, rateLimitSettings);
    }

    public AlibabaCloudSearchServiceSettings(String serviceId, String host, String workspaceName, @Nullable String httpSchema, @Nullable RateLimitSettings rateLimitSettings) {
        this.serviceId = serviceId;
        this.host = host;
        this.workspaceName = workspaceName;
        this.httpSchema = httpSchema;
        this.rateLimitSettings = Objects.requireNonNullElse(rateLimitSettings, DEFAULT_RATE_LIMIT_SETTINGS);
    }

    public AlibabaCloudSearchServiceSettings(StreamInput in) throws IOException {
        this.serviceId = in.readString();
        this.host = in.readString();
        this.workspaceName = in.readString();
        this.httpSchema = in.readOptionalString();
        this.rateLimitSettings = new RateLimitSettings(in);
    }

    public String modelId() {
        return this.serviceId;
    }

    public String getHost() {
        return this.host;
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public String getHttpSchema() {
        return this.httpSchema;
    }

    @Override
    public RateLimitSettings rateLimitSettings() {
        return this.rateLimitSettings;
    }

    public String getWriteableName() {
        return NAME;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.toXContentFragment(builder, params);
        builder.endObject();
        return builder;
    }

    public XContentBuilder toXContentFragment(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.toXContentFragmentOfExposedFields(builder, params);
    }

    @Override
    public XContentBuilder toXContentFragmentOfExposedFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.serviceId != null) {
            builder.field(SERVICE_ID, this.serviceId);
        }
        builder.field(HOST, this.host);
        builder.field(WORKSPACE_NAME, this.workspaceName);
        if (this.httpSchema != null) {
            builder.field(HTTP_SCHEMA_NAME, this.httpSchema);
        }
        this.rateLimitSettings.toXContent(builder, params);
        return builder;
    }

    @Override
    public ToXContentObject getFilteredXContentObject() {
        return this;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_16_0;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.serviceId);
        out.writeString(this.host);
        out.writeString(this.workspaceName);
        out.writeOptionalString(this.httpSchema);
        this.rateLimitSettings.writeTo(out);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlibabaCloudSearchServiceSettings that = (AlibabaCloudSearchServiceSettings)o;
        return Objects.equals(this.serviceId, that.serviceId) && Objects.equals(this.host, that.host) && Objects.equals(this.workspaceName, that.workspaceName) && Objects.equals(this.httpSchema, that.httpSchema);
    }

    public int hashCode() {
        return Objects.hash(this.serviceId, this.host, this.workspaceName, this.httpSchema);
    }
}

