/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.response.streaming;

import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Optional;
import java.util.regex.Pattern;
import org.elasticsearch.xpack.inference.external.response.streaming.ServerSentEvent;
import org.elasticsearch.xpack.inference.external.response.streaming.ServerSentEventField;

public class ServerSentEventParser {
    private static final Pattern END_OF_LINE_REGEX = Pattern.compile("\\n|\\r|\\r\\n");
    private static final String BOM = "\ufeff";
    private volatile String previousTokens = "";

    public Deque<ServerSentEvent> parse(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return new ArrayDeque<ServerSentEvent>(0);
        }
        String body = this.previousTokens + new String(bytes, StandardCharsets.UTF_8);
        String[] lines = END_OF_LINE_REGEX.split(body, -1);
        ArrayDeque<ServerSentEvent> collector = new ArrayDeque<ServerSentEvent>(lines.length);
        for (int i = 0; i < lines.length - 1; ++i) {
            String line = lines[i].replace(BOM, "");
            if (line.isBlank() || line.startsWith(":")) continue;
            if (line.contains(":")) {
                this.fieldValueEvent(line).ifPresent(collector::offer);
                continue;
            }
            ServerSentEventField.oneOf(line).map(ServerSentEvent::new).ifPresent(collector::offer);
        }
        this.previousTokens = lines[lines.length - 1];
        return collector;
    }

    private Optional<ServerSentEvent> fieldValueEvent(String lineWithColon) {
        String value;
        int firstColon = lineWithColon.indexOf(":");
        String fieldStr = lineWithColon.substring(0, firstColon);
        Optional<ServerSentEventField> serverSentField = ServerSentEventField.oneOf(fieldStr);
        if (firstColon + 1 != lineWithColon.length() && !(value = lineWithColon.substring(firstColon + 1)).equals(" ")) {
            String trimmedValue = value.charAt(0) == ' ' ? value.substring(1) : value;
            return serverSentField.map(field -> new ServerSentEvent((ServerSentEventField)((Object)field), trimmedValue));
        }
        return serverSentField.map(ServerSentEvent::new);
    }
}

