/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.request.jinaai;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.jinaai.rerank.JinaAIRerankTaskSettings;

public record JinaAIRerankRequestEntity(String model, String query, List<String> documents, JinaAIRerankTaskSettings taskSettings) implements ToXContentObject
{
    private static final String DOCUMENTS_FIELD = "documents";
    private static final String QUERY_FIELD = "query";
    private static final String MODEL_FIELD = "model";

    public JinaAIRerankRequestEntity {
        Objects.requireNonNull(query);
        Objects.requireNonNull(documents);
        Objects.requireNonNull(model);
        Objects.requireNonNull(taskSettings);
    }

    public JinaAIRerankRequestEntity(String query, List<String> input, JinaAIRerankTaskSettings taskSettings, String model) {
        this(model, query, input, taskSettings != null ? taskSettings : JinaAIRerankTaskSettings.EMPTY_SETTINGS);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Boolean return_documents;
        builder.startObject();
        builder.field(MODEL_FIELD, this.model);
        builder.field(QUERY_FIELD, this.query);
        builder.field(DOCUMENTS_FIELD, this.documents);
        if (this.taskSettings.getTopNDocumentsOnly() != null) {
            builder.field("top_n", this.taskSettings.getTopNDocumentsOnly());
        }
        if ((return_documents = this.taskSettings.getDoesReturnDocuments()) != null) {
            builder.field("return_documents", return_documents);
        }
        builder.endObject();
        return builder;
    }
}

