/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.request.alibabacloudsearch;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.inference.external.alibabacloudsearch.AlibabaCloudSearchAccount;
import org.elasticsearch.xpack.inference.external.request.HttpRequest;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.request.RequestUtils;
import org.elasticsearch.xpack.inference.external.request.alibabacloudsearch.AlibabaCloudSearchRerankRequestEntity;
import org.elasticsearch.xpack.inference.services.alibabacloudsearch.rerank.AlibabaCloudSearchRerankModel;
import org.elasticsearch.xpack.inference.services.alibabacloudsearch.rerank.AlibabaCloudSearchRerankTaskSettings;

public class AlibabaCloudSearchRerankRequest
implements Request {
    private final AlibabaCloudSearchAccount account;
    private final String query;
    private final List<String> input;
    private final URI uri;
    private final AlibabaCloudSearchRerankTaskSettings taskSettings;
    private final String model;
    private final String host;
    private final String workspaceName;
    private final String httpSchema;
    private final String inferenceEntityId;

    public AlibabaCloudSearchRerankRequest(AlibabaCloudSearchAccount account, String query, List<String> input, AlibabaCloudSearchRerankModel rerankModel) {
        Objects.requireNonNull(rerankModel);
        this.account = Objects.requireNonNull(account);
        this.query = Objects.requireNonNull(query);
        this.input = Objects.requireNonNull(input);
        this.taskSettings = rerankModel.getTaskSettings();
        this.model = rerankModel.getServiceSettings().getCommonSettings().modelId();
        this.host = rerankModel.getServiceSettings().getCommonSettings().getHost();
        this.workspaceName = rerankModel.getServiceSettings().getCommonSettings().getWorkspaceName();
        this.httpSchema = rerankModel.getServiceSettings().getCommonSettings().getHttpSchema() != null ? rerankModel.getServiceSettings().getCommonSettings().getHttpSchema() : "https";
        this.uri = RequestUtils.buildUri(null, "alibabacloud-ai-search", (CheckedSupplier<URI, URISyntaxException>)((CheckedSupplier)this::buildDefaultUri));
        this.inferenceEntityId = rerankModel.getInferenceEntityId();
    }

    @Override
    public HttpRequest createHttpRequest() {
        HttpPost httpPost = new HttpPost(this.uri);
        ByteArrayEntity byteEntity = new ByteArrayEntity(Strings.toString((ToXContent)new AlibabaCloudSearchRerankRequestEntity(this.query, this.input, this.taskSettings)).getBytes(StandardCharsets.UTF_8));
        httpPost.setEntity((HttpEntity)byteEntity);
        httpPost.setHeader("Content-Type", XContentType.JSON.mediaType());
        httpPost.setHeader(RequestUtils.createAuthBearerHeader(this.account.apiKey()));
        return new HttpRequest((HttpRequestBase)httpPost, this.getInferenceEntityId());
    }

    @Override
    public String getInferenceEntityId() {
        return this.inferenceEntityId;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public Request truncate() {
        return this;
    }

    @Override
    public boolean[] getTruncationInfo() {
        return null;
    }

    URI buildDefaultUri() throws URISyntaxException {
        return new URIBuilder().setScheme(this.httpSchema).setHost(this.host).setPathSegments(new String[]{"v3", "openapi", "workspaces", this.workspaceName, "ranker", this.model}).build();
    }
}

