/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.TimeValue;

public class HttpSettings {
    static final Setting<ByteSizeValue> MAX_HTTP_RESPONSE_SIZE = Setting.byteSizeSetting((String)"xpack.inference.http.max_response_size", (ByteSizeValue)ByteSizeValue.of((long)50L, (ByteSizeUnit)ByteSizeUnit.MB), (ByteSizeValue)ByteSizeValue.ONE, (ByteSizeValue)ByteSizeValue.of((long)100L, (ByteSizeUnit)ByteSizeUnit.MB), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<TimeValue> CONNECTION_TIMEOUT = Setting.timeSetting((String)"xpack.inference.http.connect_timeout", (TimeValue)TimeValue.timeValueSeconds((long)5L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private volatile ByteSizeValue maxResponseSize;
    private final int connectionTimeout;

    public HttpSettings(Settings settings, ClusterService clusterService) {
        Objects.requireNonNull(clusterService);
        Objects.requireNonNull(settings);
        this.maxResponseSize = (ByteSizeValue)MAX_HTTP_RESPONSE_SIZE.get(settings);
        this.connectionTimeout = Math.toIntExact(((TimeValue)CONNECTION_TIMEOUT.get(settings)).getMillis());
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MAX_HTTP_RESPONSE_SIZE, this::setMaxResponseSize);
    }

    public ByteSizeValue getMaxResponseSize() {
        return this.maxResponseSize;
    }

    public int connectionTimeout() {
        return this.connectionTimeout;
    }

    private void setMaxResponseSize(ByteSizeValue maxResponseSize) {
        this.maxResponseSize = maxResponseSize;
    }

    public static List<Setting<?>> getSettingsDefinitions() {
        return List.of(MAX_HTTP_RESPONSE_SIZE, CONNECTION_TIMEOUT);
    }
}

