/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.elastic;

import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.http.retry.BaseResponseHandler;
import org.elasticsearch.xpack.inference.external.http.retry.ContentTooLargeException;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseParser;
import org.elasticsearch.xpack.inference.external.http.retry.RetryException;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.response.elastic.ElasticInferenceServiceErrorResponseEntity;

public class ElasticInferenceServiceResponseHandler
extends BaseResponseHandler {
    public ElasticInferenceServiceResponseHandler(String requestType, ResponseParser parseFunction) {
        super(requestType, parseFunction, ElasticInferenceServiceErrorResponseEntity::fromResponse);
    }

    @Override
    protected void checkForFailureStatusCode(Request request, HttpResult result) throws RetryException {
        if (result.isSuccessfulResponse()) {
            return;
        }
        int statusCode = result.response().getStatusLine().getStatusCode();
        if (statusCode == 500) {
            throw new RetryException(true, this.buildError("Received a server error status code", request, result));
        }
        if (statusCode == 400) {
            throw new RetryException(false, this.buildError("Received a bad request status code", request, result));
        }
        if (statusCode == 405) {
            throw new RetryException(false, this.buildError("Received a method not allowed status code", request, result));
        }
        if (statusCode == 413) {
            throw new ContentTooLargeException(this.buildError("Received a content too large status code", request, result));
        }
        throw new RetryException(false, this.buildError("Received an unsuccessful status code", request, result));
    }
}

