/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.session;

import java.util.List;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.eql.action.EqlSearchResponse;
import org.elasticsearch.xpack.eql.session.Payload;

public class Results {
    private final TotalHits totalHits;
    private final List<?> results;
    private final boolean timedOut;
    private final TimeValue tookTime;
    private final Payload.Type type;
    private ShardSearchFailure[] shardFailures;

    public static Results fromPayload(Payload payload) {
        List<?> values = payload.values();
        payload.shardFailures();
        return new Results(new TotalHits((long)values.size(), TotalHits.Relation.EQUAL_TO), payload.timeTook(), false, values, payload.resultType(), payload.shardFailures());
    }

    Results(TotalHits totalHits, TimeValue tookTime, boolean timedOut, List<?> results, Payload.Type type, ShardSearchFailure[] shardFailures) {
        this.totalHits = totalHits;
        this.tookTime = tookTime;
        this.timedOut = timedOut;
        this.results = results;
        this.type = type;
        this.shardFailures = shardFailures;
    }

    public TotalHits totalHits() {
        return this.totalHits;
    }

    public List<EqlSearchResponse.Event> events() {
        return this.type == Payload.Type.EVENT ? this.results : null;
    }

    public List<EqlSearchResponse.Sequence> sequences() {
        return this.type == Payload.Type.SEQUENCE || this.type == Payload.Type.SAMPLE ? this.results : null;
    }

    public ShardSearchFailure[] shardFailures() {
        return this.shardFailures;
    }

    public TimeValue tookTime() {
        return this.tookTime;
    }

    public boolean timedOut() {
        return this.timedOut;
    }
}

