/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation.intellij;

public class Salsa20 {
    private static final int stateSize = 16;
    private static final byte[] sigma = "expand 32-byte k".getBytes();
    private static final byte[] tau = "expand 16-byte k".getBytes();
    private int index = 0;
    private int[] engineState = new int[16];
    private int[] x = new int[16];
    private byte[] keyStream = new byte[64];
    private byte[] workingKey = null;
    private byte[] workingIV = null;
    private boolean initialised = false;
    private int cW0;
    private int cW1;
    private int cW2;

    public void engineInitEncrypt(byte[] key, byte[] iv) throws Exception {
        this.init(true, key, iv);
    }

    public void engineInitDecrypt(byte[] key, byte[] iv) throws Exception {
        this.init(false, key, iv);
    }

    private void init(boolean forEncryption, byte[] key, byte[] iv) {
        if (iv == null || iv.length != 8) {
            throw new IllegalArgumentException("Salsa20 requires exactly 8 bytes of IV");
        }
        this.workingKey = key;
        this.workingIV = iv;
        this.setKey(this.workingKey, this.workingIV);
    }

    public String getAlgorithmName() {
        return "Salsa20";
    }

    public byte returnByte(byte in) throws Exception {
        if (this.limitExceeded()) {
            throw new IllegalStateException("2^70 byte limit per IV; Change IV");
        }
        if (this.index == 0) {
            this.salsa20WordToByte(this.engineState, this.keyStream);
            this.engineState[8] = this.engineState[8] + 1;
            if (this.engineState[8] == 0) {
                this.engineState[9] = this.engineState[9] + 1;
            }
        }
        byte out = (byte)(this.keyStream[this.index] ^ in);
        this.index = this.index + 1 & 0x3F;
        return out;
    }

    public final byte[] crypt(byte[] data, int position, int length) throws Exception {
        byte[] buffer = new byte[length];
        this.crypt(data, position, length, buffer, 0);
        return buffer;
    }

    public void crypt(byte[] in, int inOff, int len, byte[] out, int outOff) throws Exception {
        if (!this.initialised) {
            throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
        }
        if (inOff + len > in.length) {
            throw new IllegalArgumentException("input buffer too short");
        }
        if (outOff + len > out.length) {
            throw new IllegalArgumentException("output buffer too short");
        }
        if (this.limitExceeded(len)) {
            throw new IllegalArgumentException("2^70 byte limit per IV would be exceeded; Change IV");
        }
        for (int i = 0; i < len; ++i) {
            if (this.index == 0) {
                this.salsa20WordToByte(this.engineState, this.keyStream);
                this.engineState[8] = this.engineState[8] + 1;
                if (this.engineState[8] == 0) {
                    this.engineState[9] = this.engineState[9] + 1;
                }
            }
            out[i + outOff] = (byte)(this.keyStream[this.index] ^ in[i + inOff]);
            this.index = this.index + 1 & 0x3F;
        }
    }

    public void reset() {
        this.setKey(this.workingKey, this.workingIV);
    }

    private void setKey(byte[] keyBytes, byte[] ivBytes) {
        byte[] constants;
        this.workingKey = keyBytes;
        this.workingIV = ivBytes;
        this.index = 0;
        this.resetCounter();
        int offset = 0;
        this.engineState[1] = this.byteToIntLittle(this.workingKey, 0);
        this.engineState[2] = this.byteToIntLittle(this.workingKey, 4);
        this.engineState[3] = this.byteToIntLittle(this.workingKey, 8);
        this.engineState[4] = this.byteToIntLittle(this.workingKey, 12);
        if (this.workingKey.length == 32) {
            constants = sigma;
            offset = 16;
        } else {
            constants = tau;
        }
        this.engineState[11] = this.byteToIntLittle(this.workingKey, offset);
        this.engineState[12] = this.byteToIntLittle(this.workingKey, offset + 4);
        this.engineState[13] = this.byteToIntLittle(this.workingKey, offset + 8);
        this.engineState[14] = this.byteToIntLittle(this.workingKey, offset + 12);
        this.engineState[0] = this.byteToIntLittle(constants, 0);
        this.engineState[5] = this.byteToIntLittle(constants, 4);
        this.engineState[10] = this.byteToIntLittle(constants, 8);
        this.engineState[15] = this.byteToIntLittle(constants, 12);
        this.engineState[6] = this.byteToIntLittle(this.workingIV, 0);
        this.engineState[7] = this.byteToIntLittle(this.workingIV, 4);
        this.engineState[9] = 0;
        this.engineState[8] = 0;
        this.initialised = true;
    }

    private void salsa20WordToByte(int[] input, byte[] output) {
        int i;
        System.arraycopy(input, 0, this.x, 0, input.length);
        for (int i2 = 0; i2 < 10; ++i2) {
            this.x[4] = this.x[4] ^ this.rotl(this.x[0] + this.x[12], 7);
            this.x[8] = this.x[8] ^ this.rotl(this.x[4] + this.x[0], 9);
            this.x[12] = this.x[12] ^ this.rotl(this.x[8] + this.x[4], 13);
            this.x[0] = this.x[0] ^ this.rotl(this.x[12] + this.x[8], 18);
            this.x[9] = this.x[9] ^ this.rotl(this.x[5] + this.x[1], 7);
            this.x[13] = this.x[13] ^ this.rotl(this.x[9] + this.x[5], 9);
            this.x[1] = this.x[1] ^ this.rotl(this.x[13] + this.x[9], 13);
            this.x[5] = this.x[5] ^ this.rotl(this.x[1] + this.x[13], 18);
            this.x[14] = this.x[14] ^ this.rotl(this.x[10] + this.x[6], 7);
            this.x[2] = this.x[2] ^ this.rotl(this.x[14] + this.x[10], 9);
            this.x[6] = this.x[6] ^ this.rotl(this.x[2] + this.x[14], 13);
            this.x[10] = this.x[10] ^ this.rotl(this.x[6] + this.x[2], 18);
            this.x[3] = this.x[3] ^ this.rotl(this.x[15] + this.x[11], 7);
            this.x[7] = this.x[7] ^ this.rotl(this.x[3] + this.x[15], 9);
            this.x[11] = this.x[11] ^ this.rotl(this.x[7] + this.x[3], 13);
            this.x[15] = this.x[15] ^ this.rotl(this.x[11] + this.x[7], 18);
            this.x[1] = this.x[1] ^ this.rotl(this.x[0] + this.x[3], 7);
            this.x[2] = this.x[2] ^ this.rotl(this.x[1] + this.x[0], 9);
            this.x[3] = this.x[3] ^ this.rotl(this.x[2] + this.x[1], 13);
            this.x[0] = this.x[0] ^ this.rotl(this.x[3] + this.x[2], 18);
            this.x[6] = this.x[6] ^ this.rotl(this.x[5] + this.x[4], 7);
            this.x[7] = this.x[7] ^ this.rotl(this.x[6] + this.x[5], 9);
            this.x[4] = this.x[4] ^ this.rotl(this.x[7] + this.x[6], 13);
            this.x[5] = this.x[5] ^ this.rotl(this.x[4] + this.x[7], 18);
            this.x[11] = this.x[11] ^ this.rotl(this.x[10] + this.x[9], 7);
            this.x[8] = this.x[8] ^ this.rotl(this.x[11] + this.x[10], 9);
            this.x[9] = this.x[9] ^ this.rotl(this.x[8] + this.x[11], 13);
            this.x[10] = this.x[10] ^ this.rotl(this.x[9] + this.x[8], 18);
            this.x[12] = this.x[12] ^ this.rotl(this.x[15] + this.x[14], 7);
            this.x[13] = this.x[13] ^ this.rotl(this.x[12] + this.x[15], 9);
            this.x[14] = this.x[14] ^ this.rotl(this.x[13] + this.x[12], 13);
            this.x[15] = this.x[15] ^ this.rotl(this.x[14] + this.x[13], 18);
        }
        int offset = 0;
        for (i = 0; i < 16; ++i) {
            this.intToByteLittle(this.x[i] + input[i], output, offset);
            offset += 4;
        }
        for (i = 16; i < this.x.length; ++i) {
            this.intToByteLittle(this.x[i], output, offset);
            offset += 4;
        }
    }

    private byte[] intToByteLittle(int x, byte[] out, int off) {
        out[off] = (byte)x;
        out[off + 1] = (byte)(x >>> 8);
        out[off + 2] = (byte)(x >>> 16);
        out[off + 3] = (byte)(x >>> 24);
        return out;
    }

    private int rotl(int x, int y) {
        return x << y | x >>> -y;
    }

    private int byteToIntLittle(byte[] x, int offset) {
        return x[offset] & 0xFF | (x[offset + 1] & 0xFF) << 8 | (x[offset + 2] & 0xFF) << 16 | x[offset + 3] << 24;
    }

    private void resetCounter() {
        this.cW0 = 0;
        this.cW1 = 0;
        this.cW2 = 0;
    }

    private boolean limitExceeded() {
        ++this.cW0;
        if (this.cW0 == 0) {
            ++this.cW1;
            if (this.cW1 == 0) {
                ++this.cW2;
                return (this.cW2 & 0x20) != 0;
            }
        }
        return false;
    }

    private boolean limitExceeded(int len) {
        if (this.cW0 >= 0) {
            this.cW0 += len;
        } else {
            this.cW0 += len;
            if (this.cW0 >= 0) {
                ++this.cW1;
                if (this.cW1 == 0) {
                    ++this.cW2;
                    return (this.cW2 & 0x20) != 0;
                }
            }
        }
        return false;
    }
}

