/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.autoscaling;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.ml.autoscaling.NodeAvailabilityZoneMapper;

public abstract class AbstractNodeAvailabilityZoneMapper
implements ClusterStateListener,
NodeAvailabilityZoneMapper {
    private volatile DiscoveryNodes lastDiscoveryNodes;
    private volatile Map<List<String>, Collection<DiscoveryNode>> allNodesByAvailabilityZone;
    private volatile Map<List<String>, Collection<DiscoveryNode>> mlNodesByAvailabilityZone;

    public AbstractNodeAvailabilityZoneMapper(Settings settings, ClusterSettings clusterSettings) {
        this(settings, clusterSettings, null);
    }

    public AbstractNodeAvailabilityZoneMapper(Settings settings, ClusterSettings clusterSettings, DiscoveryNodes discoveryNodes) {
        this.lastDiscoveryNodes = discoveryNodes;
    }

    public Map<List<String>, Collection<DiscoveryNode>> getAllNodesByAvailabilityZone() {
        return this.allNodesByAvailabilityZone;
    }

    public OptionalInt getNumAvailabilityZones() {
        return this.lastDiscoveryNodes == null ? OptionalInt.empty() : OptionalInt.of(this.allNodesByAvailabilityZone.size());
    }

    public Map<List<String>, Collection<DiscoveryNode>> getMlNodesByAvailabilityZone() {
        return this.mlNodesByAvailabilityZone;
    }

    @Override
    public OptionalInt getNumMlAvailabilityZones() {
        return this.lastDiscoveryNodes == null ? OptionalInt.empty() : OptionalInt.of(this.mlNodesByAvailabilityZone.size());
    }

    public synchronized void clusterChanged(ClusterChangedEvent event) {
        if (this.lastDiscoveryNodes == null || event.nodesChanged()) {
            this.lastDiscoveryNodes = event.state().nodes();
            this.updateNodesByAvailabilityZone();
        }
    }

    synchronized void updateNodesByAvailabilityZone() {
        if (this.lastDiscoveryNodes == null) {
            this.allNodesByAvailabilityZone = Map.of();
            this.mlNodesByAvailabilityZone = this.allNodesByAvailabilityZone;
            return;
        }
        NodeAvailabilityZoneMapper.NodesByAvailabilityZone nodesByAvailabilityZone = this.buildNodesByAvailabilityZone(this.lastDiscoveryNodes);
        this.allNodesByAvailabilityZone = nodesByAvailabilityZone.allNodes();
        this.mlNodesByAvailabilityZone = nodesByAvailabilityZone.mlNodes();
    }
}

