/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty4;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.network.NetworkModule;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.http.HttpPreRequest;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.http.HttpTransportSettings;
import org.elasticsearch.http.netty4.Netty4HttpServerTransport;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.plugins.NetworkPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.telemetry.tracing.Tracer;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.netty4.Netty4Transport;
import org.elasticsearch.transport.netty4.SharedGroupFactory;
import org.elasticsearch.transport.netty4.TLSConfig;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public class Netty4Plugin
extends Plugin
implements NetworkPlugin {
    public static final String NETTY_TRANSPORT_NAME = "netty4";
    public static final String NETTY_HTTP_TRANSPORT_NAME = "netty4";
    public static final Setting<Integer> SETTING_HTTP_WORKER_COUNT = Setting.intSetting((String)"http.netty.worker_count", (int)0, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<ByteSizeValue> SETTING_HTTP_NETTY_RECEIVE_PREDICTOR_SIZE = Setting.byteSizeSetting((String)"http.netty.receive_predictor_size", (ByteSizeValue)ByteSizeValue.of((long)64L, (ByteSizeUnit)ByteSizeUnit.KB), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Integer> WORKER_COUNT = new Setting("transport.netty.worker_count", s -> Integer.toString(EsExecutors.allocatedProcessors((Settings)s)), s -> Setting.parseInt((String)s, (int)1, (String)"transport.netty.worker_count"), new Setting.Property[]{Setting.Property.NodeScope});
    private static final Setting<ByteSizeValue> NETTY_RECEIVE_PREDICTOR_SIZE = Setting.byteSizeSetting((String)"transport.netty.receive_predictor_size", (ByteSizeValue)ByteSizeValue.of((long)64L, (ByteSizeUnit)ByteSizeUnit.KB), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<ByteSizeValue> NETTY_RECEIVE_PREDICTOR_MAX = Setting.byteSizeSetting((String)"transport.netty.receive_predictor_max", NETTY_RECEIVE_PREDICTOR_SIZE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<ByteSizeValue> NETTY_RECEIVE_PREDICTOR_MIN = Setting.byteSizeSetting((String)"transport.netty.receive_predictor_min", NETTY_RECEIVE_PREDICTOR_SIZE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Integer> NETTY_BOSS_COUNT = Setting.intSetting((String)"transport.netty.boss_count", (int)1, (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final ByteSizeValue MTU = ByteSizeValue.ofBytes((long)Long.parseLong(System.getProperty("es.net.mtu", "1500")));
    private static final String SETTING_KEY_HTTP_NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS = "http.netty.max_composite_buffer_components";
    public static final Setting<Integer> SETTING_HTTP_NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS = new Setting("http.netty.max_composite_buffer_components", s -> {
        ByteSizeValue maxContentLength = (ByteSizeValue)HttpTransportSettings.SETTING_HTTP_MAX_CONTENT_LENGTH.get(s);
        long maxBufferComponentsEstimate = Math.round((double)(maxContentLength.getBytes() / MTU.getBytes()));
        long maxBufferComponents = Math.max(2L, Math.min(maxBufferComponentsEstimate, Integer.MAX_VALUE));
        return String.valueOf(maxBufferComponents);
    }, s -> Setting.parseInt((String)s, (int)2, (int)Integer.MAX_VALUE, (String)SETTING_KEY_HTTP_NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS), new Setting.Property[]{Setting.Property.NodeScope});
    private final SetOnce<SharedGroupFactory> groupFactory = new SetOnce();

    public List<Setting<?>> getSettings() {
        return Arrays.asList(SETTING_HTTP_NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS, SETTING_HTTP_WORKER_COUNT, SETTING_HTTP_NETTY_RECEIVE_PREDICTOR_SIZE, WORKER_COUNT, NETTY_RECEIVE_PREDICTOR_SIZE, NETTY_RECEIVE_PREDICTOR_MIN, NETTY_RECEIVE_PREDICTOR_MAX, NETTY_BOSS_COUNT);
    }

    public Settings additionalSettings() {
        return Settings.builder().put(NetworkModule.HTTP_DEFAULT_TYPE_SETTING.getKey(), "netty4").put(NetworkModule.TRANSPORT_DEFAULT_TYPE_SETTING.getKey(), "netty4").build();
    }

    public Map<String, Supplier<Transport>> getTransports(Settings settings, ThreadPool threadPool, PageCacheRecycler pageCacheRecycler, CircuitBreakerService circuitBreakerService, NamedWriteableRegistry namedWriteableRegistry, NetworkService networkService) {
        return Collections.singletonMap("netty4", () -> new Netty4Transport(settings, TransportVersion.current(), threadPool, networkService, pageCacheRecycler, namedWriteableRegistry, circuitBreakerService, this.getSharedGroupFactory(settings)));
    }

    public Map<String, Supplier<HttpServerTransport>> getHttpTransports(Settings settings, ThreadPool threadPool, BigArrays bigArrays, PageCacheRecycler pageCacheRecycler, CircuitBreakerService circuitBreakerService, NamedXContentRegistry xContentRegistry, NetworkService networkService, HttpServerTransport.Dispatcher dispatcher, final BiConsumer<HttpPreRequest, ThreadContext> perRequestThreadContext, ClusterSettings clusterSettings, Tracer tracer) {
        return Collections.singletonMap("netty4", () -> new Netty4HttpServerTransport(this, settings, networkService, threadPool, xContentRegistry, dispatcher, clusterSettings, this.getSharedGroupFactory(settings), tracer, TLSConfig.noTLS(), null, null){

            protected void populatePerRequestThreadContext(RestRequest restRequest, ThreadContext threadContext) {
                perRequestThreadContext.accept(restRequest.getHttpRequest(), threadContext);
            }
        });
    }

    private SharedGroupFactory getSharedGroupFactory(Settings settings) {
        SharedGroupFactory factory = (SharedGroupFactory)this.groupFactory.get();
        if (factory != null) {
            assert (factory.getSettings().equals((Object)settings)) : "Different settings than originally provided";
            return factory;
        }
        this.groupFactory.set((Object)new SharedGroupFactory(settings));
        return (SharedGroupFactory)this.groupFactory.get();
    }
}

