/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty4;

import java.io.IOException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.NetworkChannel;
import java.util.Objects;
import jdk.net.ExtendedSocketOptions;
import org.elasticsearch.core.SuppressForbidden;

public class NetUtils {
    private NetUtils() {
    }

    @SuppressForbidden(reason="access to non-portable socket option required")
    public static SocketOption<Integer> getTcpKeepIdleSocketOption() {
        return ExtendedSocketOptions.TCP_KEEPIDLE;
    }

    @SuppressForbidden(reason="access to non-portable socket option required")
    public static SocketOption<Integer> getTcpKeepIntervalSocketOption() {
        return ExtendedSocketOptions.TCP_KEEPINTERVAL;
    }

    @SuppressForbidden(reason="access to non-portable socket option required")
    public static SocketOption<Integer> getTcpKeepCountSocketOption() {
        return ExtendedSocketOptions.TCP_KEEPCOUNT;
    }

    public static void tryEnsureReasonableKeepAliveConfig(NetworkChannel socketChannel) {
        block6: {
            assert (socketChannel != null);
            try {
                if (socketChannel.supportedOptions().contains(StandardSocketOptions.SO_KEEPALIVE)) {
                    Boolean keepalive = socketChannel.getOption(StandardSocketOptions.SO_KEEPALIVE);
                    assert (keepalive != null);
                    if (keepalive.booleanValue()) {
                        NetUtils.setMinValueForSocketOption(socketChannel, NetUtils.getTcpKeepIdleSocketOption(), 300);
                        NetUtils.setMinValueForSocketOption(socketChannel, NetUtils.getTcpKeepIntervalSocketOption(), 300);
                    }
                }
            }
            catch (Exception e) {
                if ($assertionsDisabled || e instanceof IOException) break block6;
                throw new AssertionError((Object)e);
            }
        }
    }

    private static void setMinValueForSocketOption(NetworkChannel socketChannel, SocketOption<Integer> option, int minValue) {
        block5: {
            Objects.requireNonNull(option);
            if (socketChannel.supportedOptions().contains(option)) {
                try {
                    Integer currentIdleVal = socketChannel.getOption(option);
                    assert (currentIdleVal != null);
                    if (currentIdleVal > minValue) {
                        socketChannel.setOption(option, minValue);
                    }
                }
                catch (Exception e) {
                    if ($assertionsDisabled || e instanceof IOException) break block5;
                    throw new AssertionError((Object)e);
                }
            }
        }
    }
}

