/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.common.TriFunction;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.time.LegacyFormatNames;
import org.elasticsearch.core.Strings;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.xpack.core.deprecation.DeprecatedIndexPredicate;
import org.elasticsearch.xpack.core.deprecation.DeprecationIssue;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;
import org.elasticsearch.xpack.deprecation.DeprecationInfoAction;
import org.elasticsearch.xpack.deprecation.LegacyTiersDetection;
import org.elasticsearch.xpack.deprecation.ResourceDeprecationChecker;
import org.elasticsearch.xpack.deprecation.TransportDeprecationInfoAction;

public class IndexDeprecationChecker
implements ResourceDeprecationChecker {
    public static final String NAME = "index_settings";
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final List<TriFunction<IndexMetadata, ClusterState, Map<String, List<String>>, DeprecationIssue>> checks = List.of(this::oldIndicesCheck, this::ignoredOldIndicesCheck, this::translogRetentionSettingCheck, this::checkIndexDataPath, this::storeTypeSettingCheck, this::deprecatedCamelCasePattern, this::legacyRoutingSettingCheck);

    public IndexDeprecationChecker(IndexNameExpressionResolver indexNameExpressionResolver) {
        this.indexNameExpressionResolver = indexNameExpressionResolver;
    }

    @Override
    public Map<String, List<DeprecationIssue>> check(ClusterState clusterState, DeprecationInfoAction.Request request, TransportDeprecationInfoAction.PrecomputedData precomputedData) {
        HashMap<String, List<DeprecationIssue>> indexSettingsIssues = new HashMap<String, List<DeprecationIssue>>();
        String[] concreteIndexNames = this.indexNameExpressionResolver.concreteIndexNames(clusterState, (IndicesRequest)request);
        Map<String, List<String>> indexToTransformIds = this.indexToTransformIds(precomputedData.transformConfigs());
        for (String concreteIndex : concreteIndexNames) {
            IndexMetadata indexMetadata = clusterState.getMetadata().index(concreteIndex);
            List<DeprecationIssue> singleIndexIssues = this.checks.stream().map(c -> (DeprecationIssue)c.apply((Object)indexMetadata, (Object)clusterState, (Object)indexToTransformIds)).filter(Objects::nonNull).toList();
            if (singleIndexIssues.isEmpty()) continue;
            indexSettingsIssues.put(concreteIndex, singleIndexIssues);
        }
        if (indexSettingsIssues.isEmpty()) {
            return Map.of();
        }
        return indexSettingsIssues;
    }

    @Override
    public String getName() {
        return NAME;
    }

    private DeprecationIssue oldIndicesCheck(IndexMetadata indexMetadata, ClusterState clusterState, Map<String, List<String>> indexToTransformIds) {
        IndexVersion currentCompatibilityVersion = indexMetadata.getCompatibilityVersion();
        if (DeprecatedIndexPredicate.reindexRequired((IndexMetadata)indexMetadata, (boolean)false, (boolean)false) && this.isNotDataStreamIndex(indexMetadata, clusterState)) {
            List<String> transforms = this.transformIdsForIndex(indexMetadata, indexToTransformIds);
            if (!transforms.isEmpty()) {
                return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "One or more Transforms write to this index with a compatibility version < " + Version.CURRENT.major + ".0", "https://www.elastic.co/docs/deploy-manage/upgrade/prepare-to-upgrade#transform-migration", Strings.format((String)"This index was created in version [%s] and requires action before upgrading to %d.0. The following transforms are configured to write to this index: [%s]. Refer to the migration guide to learn more about how to prepare transforms destination indices for your upgrade.", (Object[])new Object[]{currentCompatibilityVersion.toReleaseVersion(), Version.CURRENT.major, String.join((CharSequence)", ", transforms)}), false, Map.of("reindex_required", true, "transform_ids", transforms));
            }
            return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "Old index with a compatibility version < " + Version.CURRENT.major + ".0", "https://ela.st/es-deprecation-9-index-version", "This index has version: " + currentCompatibilityVersion.toReleaseVersion(), false, Map.of("reindex_required", true));
        }
        return null;
    }

    private List<String> transformIdsForIndex(IndexMetadata indexMetadata, Map<String, List<String>> indexToTransformIds) {
        return indexToTransformIds.getOrDefault(indexMetadata.getIndex().getName(), List.of());
    }

    private DeprecationIssue ignoredOldIndicesCheck(IndexMetadata indexMetadata, ClusterState clusterState, Map<String, List<String>> indexToTransformIds) {
        IndexVersion currentCompatibilityVersion = indexMetadata.getCompatibilityVersion();
        if (DeprecatedIndexPredicate.reindexRequired((IndexMetadata)indexMetadata, (boolean)true, (boolean)false) && this.isNotDataStreamIndex(indexMetadata, clusterState)) {
            List<String> transforms = this.transformIdsForIndex(indexMetadata, indexToTransformIds);
            if (!transforms.isEmpty()) {
                return new DeprecationIssue(DeprecationIssue.Level.WARNING, "One or more Transforms write to this old index with a compatibility version < " + Version.CURRENT.major + ".0", "https://www.elastic.co/docs/deploy-manage/upgrade/prepare-to-upgrade#transform-migration", Strings.format((String)"This index was created in version [%s] and will be supported as a read-only index in %d.0. The following transforms are no longer able to write to this index: [%s]. Refer to the migration guide to learn more about how to handle your transforms destination indices.", (Object[])new Object[]{currentCompatibilityVersion.toReleaseVersion(), Version.CURRENT.major, String.join((CharSequence)", ", transforms)}), false, Map.of("reindex_required", true, "transform_ids", transforms));
            }
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Old index with a compatibility version < " + Version.CURRENT.major + ".0 has been ignored", "https://ela.st/es-deprecation-9-index-version", "This read-only index has version: " + currentCompatibilityVersion.toReleaseVersion() + " and will be supported as read-only in " + Version.CURRENT.major + ".0", false, Map.of("reindex_required", true));
        }
        return null;
    }

    private boolean isNotDataStreamIndex(IndexMetadata indexMetadata, ClusterState clusterState) {
        return clusterState.metadata().findDataStreams(new String[]{indexMetadata.getIndex().getName()}).isEmpty();
    }

    private DeprecationIssue translogRetentionSettingCheck(IndexMetadata indexMetadata, ClusterState clusterState, Map<String, List<String>> ignored) {
        boolean softDeletesEnabled = (Boolean)IndexSettings.INDEX_SOFT_DELETES_SETTING.get(indexMetadata.getSettings());
        if (softDeletesEnabled && (IndexSettings.INDEX_TRANSLOG_RETENTION_SIZE_SETTING.exists(indexMetadata.getSettings()) || IndexSettings.INDEX_TRANSLOG_RETENTION_AGE_SETTING.exists(indexMetadata.getSettings()))) {
            ArrayList<String> settingKeys = new ArrayList<String>();
            if (IndexSettings.INDEX_TRANSLOG_RETENTION_SIZE_SETTING.exists(indexMetadata.getSettings())) {
                settingKeys.add(IndexSettings.INDEX_TRANSLOG_RETENTION_SIZE_SETTING.getKey());
            }
            if (IndexSettings.INDEX_TRANSLOG_RETENTION_AGE_SETTING.exists(indexMetadata.getSettings())) {
                settingKeys.add(IndexSettings.INDEX_TRANSLOG_RETENTION_AGE_SETTING.getKey());
            }
            Map meta = DeprecationIssue.createMetaMapForRemovableSettings(settingKeys);
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "translog retention settings are ignored", "https://ela.st/es-deprecation-7-translog-retention", "translog retention settings [index.translog.retention.size] and [index.translog.retention.age] are ignored because translog is no longer used in peer recoveries with soft-deletes enabled (default in 7.0 or later)", false, meta);
        }
        return null;
    }

    private DeprecationIssue checkIndexDataPath(IndexMetadata indexMetadata, ClusterState clusterState, Map<String, List<String>> ignored) {
        if (IndexMetadata.INDEX_DATA_PATH_SETTING.exists(indexMetadata.getSettings())) {
            String message = String.format(Locale.ROOT, "setting [%s] is deprecated and will be removed in a future version", IndexMetadata.INDEX_DATA_PATH_SETTING.getKey());
            String url = "https://ela.st/es-deprecation-7-index-data-path";
            String details = "Found index data path configured. Discontinue use of this setting.";
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, message, "https://ela.st/es-deprecation-7-index-data-path", "Found index data path configured. Discontinue use of this setting.", false, null);
        }
        return null;
    }

    private DeprecationIssue storeTypeSettingCheck(IndexMetadata indexMetadata, ClusterState clusterState, Map<String, List<String>> ignored) {
        String storeType = (String)IndexModule.INDEX_STORE_TYPE_SETTING.get(indexMetadata.getSettings());
        if (IndexModule.Type.SIMPLEFS.match(storeType)) {
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "[simplefs] is deprecated and will be removed in future versions", "https://ela.st/es-deprecation-7-simplefs", "[simplefs] is deprecated and will be removed in 8.0. Use [niofs] or other file systems instead. Elasticsearch 7.15 or later uses [niofs] for the [simplefs] store type as it offers superior or equivalent performance to [simplefs].", false, null);
        }
        return null;
    }

    private DeprecationIssue legacyRoutingSettingCheck(IndexMetadata indexMetadata, ClusterState clusterState, Map<String, List<String>> ignored) {
        List<String> deprecatedSettings = LegacyTiersDetection.getDeprecatedFilteredAllocationSettings(indexMetadata.getSettings());
        if (deprecatedSettings.isEmpty()) {
            return null;
        }
        String indexName = indexMetadata.getIndex().getName();
        return new DeprecationIssue(DeprecationIssue.Level.WARNING, "index [" + indexName + "] is configuring tiers via filtered allocation which is not recommended.", "https://ela.st/migrate-to-tiers", "One or more of your indices is configured with 'index.routing.allocation.*.data' settings. This is typically used to create a hot/warm or tiered architecture, based on legacy guidelines. Data tiers are a recommended replacement for tiered architecture clusters.", false, DeprecationIssue.createMetaMapForRemovableSettings(deprecatedSettings));
    }

    private void fieldLevelMappingIssue(IndexMetadata indexMetadata, BiConsumer<MappingMetadata, Map<String, Object>> checker) {
        if (indexMetadata.mapping() != null) {
            Map sourceAsMap = indexMetadata.mapping().sourceAsMap();
            checker.accept(indexMetadata.mapping(), sourceAsMap);
        }
    }

    private List<String> findInPropertiesRecursively(String type, Map<String, Object> parentMap, Function<Map<?, ?>, Boolean> predicate, BiFunction<String, Map.Entry<?, ?>, String> fieldFormatter, String fieldBeginMarker, String fieldEndMarker) {
        ArrayList<String> issues = new ArrayList<String>();
        Map properties = (Map)parentMap.get("properties");
        if (properties == null) {
            return issues;
        }
        for (Map.Entry entry : properties.entrySet()) {
            Map values;
            Map valueMap = (Map)entry.getValue();
            if (predicate.apply(valueMap).booleanValue()) {
                issues.add(fieldBeginMarker + fieldFormatter.apply(type, entry) + fieldEndMarker);
            }
            if ((values = (Map)valueMap.get("fields")) != null) {
                for (Map.Entry multifieldEntry : values.entrySet()) {
                    Map multifieldValueMap = (Map)multifieldEntry.getValue();
                    if (predicate.apply(multifieldValueMap).booleanValue()) {
                        issues.add(fieldBeginMarker + fieldFormatter.apply(type, entry) + ", multifield: " + String.valueOf(multifieldEntry.getKey()) + fieldEndMarker);
                    }
                    if (!multifieldValueMap.containsKey("properties")) continue;
                    issues.addAll(this.findInPropertiesRecursively(type, multifieldValueMap, predicate, fieldFormatter, fieldBeginMarker, fieldEndMarker));
                }
            }
            if (!valueMap.containsKey("properties")) continue;
            issues.addAll(this.findInPropertiesRecursively(type, valueMap, predicate, fieldFormatter, fieldBeginMarker, fieldEndMarker));
        }
        return issues;
    }

    private DeprecationIssue deprecatedCamelCasePattern(IndexMetadata indexMetadata, ClusterState clusterState, Map<String, List<String>> ignored) {
        ArrayList fields = new ArrayList();
        this.fieldLevelMappingIssue(indexMetadata, (mappingMetadata, sourceAsMap) -> fields.addAll(this.findInPropertiesRecursively(mappingMetadata.type(), (Map<String, Object>)sourceAsMap, this::isDateFieldWithCamelCasePattern, this::changeFormatToSnakeCase, "", "")));
        if (fields.size() > 0) {
            String detailsMessageBeginning = String.join((CharSequence)" ", fields);
            return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "Date fields use deprecated camel case formats", "https://ela.st/es-deprecation-7-camel-case-format", detailsMessageBeginning, false, null);
        }
        return null;
    }

    private boolean isDateFieldWithCamelCasePattern(Map<?, ?> property) {
        String[] patterns;
        String[] stringArray;
        int n;
        int n2;
        if ("date".equals(property.get("type")) && property.containsKey("format") && (n2 = 0) < (n = (stringArray = (patterns = DateFormatter.splitCombinedPatterns((String)((String)property.get("format"))))).length)) {
            String pattern = stringArray[n2];
            LegacyFormatNames format = LegacyFormatNames.forName((String)pattern);
            return format != null && format.isCamelCase(pattern);
        }
        return false;
    }

    private String changeFormatToSnakeCase(String type, Map.Entry<?, ?> entry) {
        Map value = (Map)entry.getValue();
        String formatFieldValue = (String)value.get("format");
        String[] patterns = DateFormatter.splitCombinedPatterns((String)formatFieldValue);
        StringBuilder sb = new StringBuilder("Convert [" + String.valueOf(entry.getKey()) + "] format [" + formatFieldValue + "] which contains deprecated camel case to snake case. ");
        for (String pattern : patterns) {
            LegacyFormatNames format = LegacyFormatNames.forName((String)pattern);
            if (format == null || !format.isCamelCase(pattern)) continue;
            sb.append("[" + pattern + "] to [" + format.getSnakeCaseName() + "]. ");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    private Map<String, List<String>> indexToTransformIds(List<TransformConfig> transformConfigs) {
        return transformConfigs.stream().collect(Collectors.groupingBy(config -> config.getDestination().getIndex(), Collectors.mapping(TransformConfig::getId, Collectors.toList())));
    }
}

