/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.store.AlreadyClosedException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.NoShardAvailableActionException;
import org.elasticsearch.action.UnavailableShardsException;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.common.transport.NetworkExceptionHelper;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.seqno.SequenceNumbers;
import org.elasticsearch.index.shard.IllegalIndexShardStateException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardNotFoundException;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.IndexClosedException;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.persistent.AllocatedPersistentTask;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.NoSeedNodeLeftException;
import org.elasticsearch.transport.NoSuchRemoteClusterException;
import org.elasticsearch.xpack.ccr.action.ShardChangesAction;
import org.elasticsearch.xpack.ccr.action.bulk.BulkShardOperationsResponse;
import org.elasticsearch.xpack.core.ccr.ShardFollowNodeTaskStatus;
import org.elasticsearch.xpack.core.ccr.action.ShardFollowTask;

public abstract class ShardFollowNodeTask
extends AllocatedPersistentTask {
    private static final int DELAY_MILLIS = 50;
    private static final Logger LOGGER = LogManager.getLogger(ShardFollowNodeTask.class);
    private final ShardFollowTask params;
    private final BiConsumer<TimeValue, Runnable> scheduler;
    private final LongSupplier relativeTimeProvider;
    private String followerHistoryUUID;
    private long leaderGlobalCheckpoint;
    private long leaderMaxSeqNo;
    private long leaderMaxSeqNoOfUpdatesOrDeletes = -2L;
    private long lastRequestedSeqNo;
    private long followerGlobalCheckpoint = 0L;
    private long followerMaxSeqNo = 0L;
    private int numOutstandingReads = 0;
    private int numOutstandingWrites = 0;
    private long currentMappingVersion = 0L;
    private long currentSettingsVersion = 0L;
    private long currentAliasesVersion = 0L;
    private long totalReadRemoteExecTimeMillis = 0L;
    private long totalReadTimeMillis = 0L;
    private long successfulReadRequests = 0L;
    private long failedReadRequests = 0L;
    private long operationsRead = 0L;
    private long bytesRead = 0L;
    private long totalWriteTimeMillis = 0L;
    private long successfulWriteRequests = 0L;
    private long failedWriteRequests = 0L;
    private long operationWritten = 0L;
    private long lastFetchTime = -1L;
    private final Queue<Tuple<Long, Long>> partialReadRequests = new PriorityQueue<Tuple>(Comparator.comparing(Tuple::v1));
    private final Queue<Translog.Operation> buffer = new PriorityQueue<Translog.Operation>(Comparator.comparing(Translog.Operation::seqNo));
    private long bufferSizeInBytes = 0L;
    private final LinkedHashMap<Long, Tuple<AtomicInteger, ElasticsearchException>> fetchExceptions;
    private volatile ElasticsearchException fatalException;
    private Scheduler.Cancellable renewable;

    synchronized Scheduler.Cancellable getRenewable() {
        return this.renewable;
    }

    ShardFollowNodeTask(long id, String type, String action, String description, TaskId parentTask, Map<String, String> headers, final ShardFollowTask params, BiConsumer<TimeValue, Runnable> scheduler, LongSupplier relativeTimeProvider) {
        super(id, type, action, description, parentTask, headers);
        this.params = params;
        this.scheduler = scheduler;
        this.relativeTimeProvider = relativeTimeProvider;
        this.fetchExceptions = new LinkedHashMap<Long, Tuple<AtomicInteger, ElasticsearchException>>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Long, Tuple<AtomicInteger, ElasticsearchException>> eldest) {
                return this.size() > params.getMaxOutstandingReadRequests();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start(String followerHistoryUUID, long leaderGlobalCheckpoint, long leaderMaxSeqNo, long followerGlobalCheckpoint, long followerMaxSeqNo) {
        ShardFollowNodeTask shardFollowNodeTask = this;
        synchronized (shardFollowNodeTask) {
            this.followerHistoryUUID = followerHistoryUUID;
            this.leaderGlobalCheckpoint = leaderGlobalCheckpoint;
            this.leaderMaxSeqNo = leaderMaxSeqNo;
            this.followerGlobalCheckpoint = followerGlobalCheckpoint;
            this.followerMaxSeqNo = followerMaxSeqNo;
            this.lastRequestedSeqNo = followerGlobalCheckpoint;
            this.renewable = this.scheduleBackgroundRetentionLeaseRenewal(() -> {
                ShardFollowNodeTask shardFollowNodeTask = this;
                synchronized (shardFollowNodeTask) {
                    return this.followerGlobalCheckpoint;
                }
            });
        }
        this.updateMapping(0L, leaderMappingVersion -> {
            ShardFollowNodeTask shardFollowNodeTask = this;
            synchronized (shardFollowNodeTask) {
                this.currentMappingVersion = Math.max(this.currentMappingVersion, leaderMappingVersion);
            }
            this.updateSettings(leaderSettingsVersion -> {
                ShardFollowNodeTask shardFollowNodeTask = this;
                synchronized (shardFollowNodeTask) {
                    this.currentSettingsVersion = Math.max(this.currentSettingsVersion, leaderSettingsVersion);
                }
                this.updateAliases(leaderAliasesVersion -> {
                    ShardFollowNodeTask shardFollowNodeTask = this;
                    synchronized (shardFollowNodeTask) {
                        this.currentAliasesVersion = Math.max(this.currentAliasesVersion, leaderAliasesVersion);
                        LOGGER.info("{} following leader shard {}, follower global checkpoint=[{}], mapping version=[{}], settings version=[{}], aliases version=[{}]", (Object)this.params.getFollowShardId(), (Object)this.params.getLeaderShardId(), (Object)followerGlobalCheckpoint, (Object)this.currentMappingVersion, (Object)this.currentSettingsVersion, (Object)this.currentAliasesVersion);
                    }
                    this.coordinateReads();
                });
            });
        });
    }

    synchronized void coordinateReads() {
        long from;
        int requestOpCount;
        long maxRequiredSeqNo;
        if (this.isStopped()) {
            LOGGER.info("{} shard follow task has been stopped", (Object)this.params.getFollowShardId());
            return;
        }
        LOGGER.trace("{} coordinate reads, lastRequestedSeqNo={}, leaderGlobalCheckpoint={}", (Object)this.params.getFollowShardId(), (Object)this.lastRequestedSeqNo, (Object)this.leaderGlobalCheckpoint);
        assert (this.partialReadRequests.size() <= this.params.getMaxOutstandingReadRequests()) : "too many partial read requests [" + String.valueOf(this.partialReadRequests) + "]";
        while (this.hasReadBudget() && !this.partialReadRequests.isEmpty()) {
            Tuple<Long, Long> range = this.partialReadRequests.remove();
            assert ((Long)range.v1() <= (Long)range.v2() && (Long)range.v2() <= this.lastRequestedSeqNo) : "invalid partial range [" + String.valueOf(range.v1()) + "," + String.valueOf(range.v2()) + "]; last requested seq_no [" + this.lastRequestedSeqNo + "]";
            long fromSeqNo = (Long)range.v1();
            maxRequiredSeqNo = (Long)range.v2();
            requestOpCount = Math.toIntExact(maxRequiredSeqNo - fromSeqNo + 1L);
            LOGGER.trace("{}[{} ongoing reads] continue partial read request from_seqno={} max_required_seqno={} batch_count={}", (Object)this.params.getFollowShardId(), (Object)this.numOutstandingReads, (Object)fromSeqNo, (Object)maxRequiredSeqNo, (Object)requestOpCount);
            ++this.numOutstandingReads;
            this.sendShardChangesRequest(fromSeqNo, requestOpCount, maxRequiredSeqNo);
        }
        int maxReadRequestOperationCount = this.params.getMaxReadRequestOperationCount();
        while (this.hasReadBudget() && this.lastRequestedSeqNo < this.leaderGlobalCheckpoint) {
            from = this.lastRequestedSeqNo + 1L;
            maxRequiredSeqNo = Math.min(this.leaderGlobalCheckpoint, from + (long)maxReadRequestOperationCount - 1L);
            requestOpCount = this.numOutstandingReads == 0 ? maxReadRequestOperationCount : Math.toIntExact(maxRequiredSeqNo - from + 1L);
            assert (0 < requestOpCount && requestOpCount <= maxReadRequestOperationCount) : "read_request_operation_count=" + requestOpCount;
            LOGGER.trace("{}[{} ongoing reads] read from_seqno={} max_required_seqno={} batch_count={}", (Object)this.params.getFollowShardId(), (Object)this.numOutstandingReads, (Object)from, (Object)maxRequiredSeqNo, (Object)requestOpCount);
            ++this.numOutstandingReads;
            this.lastRequestedSeqNo = maxRequiredSeqNo;
            this.sendShardChangesRequest(from, requestOpCount, maxRequiredSeqNo);
        }
        if (this.numOutstandingReads == 0 && this.hasReadBudget()) {
            assert (this.lastRequestedSeqNo == this.leaderGlobalCheckpoint);
            ++this.numOutstandingReads;
            from = this.lastRequestedSeqNo + 1L;
            LOGGER.trace("{}[{}] peek read [{}]", (Object)this.params.getFollowShardId(), (Object)this.numOutstandingReads, (Object)from);
            this.sendShardChangesRequest(from, maxReadRequestOperationCount, this.lastRequestedSeqNo);
        }
    }

    private boolean hasReadBudget() {
        assert (Thread.holdsLock((Object)this));
        if (this.numOutstandingReads >= this.params.getMaxOutstandingReadRequests()) {
            LOGGER.trace("{} no new reads, maximum number of concurrent reads have been reached [{}]", (Object)this.params.getFollowShardId(), (Object)this.numOutstandingReads);
            return false;
        }
        if (this.bufferSizeInBytes >= this.params.getMaxWriteBufferSize().getBytes()) {
            LOGGER.trace("{} no new reads, buffer size limit has been reached [{}]", (Object)this.params.getFollowShardId(), (Object)this.bufferSizeInBytes);
            return false;
        }
        if (this.buffer.size() >= this.params.getMaxWriteBufferCount()) {
            LOGGER.trace("{} no new reads, buffer count limit has been reached [{}]", (Object)this.params.getFollowShardId(), (Object)this.buffer.size());
            return false;
        }
        return true;
    }

    private synchronized void coordinateWrites() {
        if (this.isStopped()) {
            LOGGER.info("{} shard follow task has been stopped", (Object)this.params.getFollowShardId());
            return;
        }
        while (this.hasWriteBudget() && !this.buffer.isEmpty()) {
            long sumEstimatedSize = 0L;
            int length = Math.min(this.params.getMaxWriteRequestOperationCount(), this.buffer.size());
            ArrayList<Translog.Operation> ops = new ArrayList<Translog.Operation>(length);
            for (int i = 0; i < length; ++i) {
                Translog.Operation op = this.buffer.remove();
                ops.add(op);
                if ((sumEstimatedSize += op.estimateSize()) > this.params.getMaxWriteRequestSize().getBytes()) break;
            }
            this.bufferSizeInBytes -= sumEstimatedSize;
            ++this.numOutstandingWrites;
            LOGGER.trace("{}[{}] write [{}/{}] [{}]", (Object)this.params.getFollowShardId(), (Object)this.numOutstandingWrites, (Object)((Translog.Operation)ops.get(0)).seqNo(), (Object)((Translog.Operation)ops.get(ops.size() - 1)).seqNo(), (Object)ops.size());
            this.sendBulkShardOperationsRequest(ops, this.leaderMaxSeqNoOfUpdatesOrDeletes, new AtomicInteger(0));
        }
    }

    private boolean hasWriteBudget() {
        assert (Thread.holdsLock((Object)this));
        if (this.numOutstandingWrites >= this.params.getMaxOutstandingWriteRequests()) {
            LOGGER.trace("{} maximum number of concurrent writes have been reached [{}]", (Object)this.params.getFollowShardId(), (Object)this.numOutstandingWrites);
            return false;
        }
        return true;
    }

    private void sendShardChangesRequest(long from, int maxOperationCount, long maxRequiredSeqNo) {
        this.sendShardChangesRequest(from, maxOperationCount, maxRequiredSeqNo, new AtomicInteger(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendShardChangesRequest(long from, int maxOperationCount, long maxRequiredSeqNo, AtomicInteger retryCounter) {
        long startTime = this.relativeTimeProvider.getAsLong();
        ShardFollowNodeTask shardFollowNodeTask = this;
        synchronized (shardFollowNodeTask) {
            this.lastFetchTime = startTime;
        }
        this.innerSendShardChangesRequest(from, maxOperationCount, response -> {
            ShardFollowNodeTask shardFollowNodeTask = this;
            synchronized (shardFollowNodeTask) {
                this.fetchExceptions.remove(from);
                if (response.getOperations().length > 0) {
                    this.totalReadRemoteExecTimeMillis += response.getTookInMillis();
                    this.totalReadTimeMillis += TimeUnit.NANOSECONDS.toMillis(this.relativeTimeProvider.getAsLong() - startTime);
                    ++this.successfulReadRequests;
                    this.operationsRead += (long)response.getOperations().length;
                    this.bytesRead += Arrays.stream(response.getOperations()).mapToLong(Translog.Operation::estimateSize).sum();
                }
            }
            this.handleReadResponse(from, maxRequiredSeqNo, (ShardChangesAction.Response)((Object)response));
        }, e -> {
            ResourceNotFoundException resourceNotFoundException;
            ShardFollowNodeTask shardFollowNodeTask = this;
            synchronized (shardFollowNodeTask) {
                this.totalReadTimeMillis += TimeUnit.NANOSECONDS.toMillis(this.relativeTimeProvider.getAsLong() - startTime);
                ++this.failedReadRequests;
                this.fetchExceptions.put(from, (Tuple<AtomicInteger, ElasticsearchException>)Tuple.tuple((Object)retryCounter, (Object)ExceptionsHelper.convertToElastic((Exception)e)));
            }
            Throwable cause = ExceptionsHelper.unwrapCause((Throwable)e);
            if (cause instanceof ResourceNotFoundException && (resourceNotFoundException = (ResourceNotFoundException)cause).getMetadataKeys().contains("es.requested_operations_missing")) {
                this.handleFallenBehindLeaderShard((Exception)e, from, maxOperationCount, maxRequiredSeqNo, retryCounter);
                return;
            }
            this.handleFailure((Exception)e, retryCounter, () -> this.sendShardChangesRequest(from, maxOperationCount, maxRequiredSeqNo, retryCounter));
        });
    }

    void handleReadResponse(long from, long maxRequiredSeqNo, ShardChangesAction.Response response) {
        Runnable handleResponseTask = () -> this.innerHandleReadResponse(from, maxRequiredSeqNo, response);
        Runnable updateMappingsTask = () -> this.maybeUpdateMapping(response.getMappingVersion(), handleResponseTask);
        Runnable updateSettingsTask = () -> this.maybeUpdateSettings(response.getSettingsVersion(), updateMappingsTask);
        this.maybeUpdateAliases(response.getAliasesVersion(), updateSettingsTask);
    }

    void handleFallenBehindLeaderShard(Exception e, long from, int maxOperationCount, long maxRequiredSeqNo, AtomicInteger retryCounter) {
        this.handleFailure(e, retryCounter, () -> this.sendShardChangesRequest(from, maxOperationCount, maxRequiredSeqNo, retryCounter));
    }

    protected void onOperationsFetched(Translog.Operation[] operations) {
    }

    synchronized void innerHandleReadResponse(long from, long maxRequiredSeqNo, ShardChangesAction.Response response) {
        long newFromSeqNo;
        this.onOperationsFetched(response.getOperations());
        this.leaderGlobalCheckpoint = Math.max(this.leaderGlobalCheckpoint, response.getGlobalCheckpoint());
        this.leaderMaxSeqNo = Math.max(this.leaderMaxSeqNo, response.getMaxSeqNo());
        this.leaderMaxSeqNoOfUpdatesOrDeletes = SequenceNumbers.max((long)this.leaderMaxSeqNoOfUpdatesOrDeletes, (long)response.getMaxSeqNoOfUpdatesOrDeletes());
        if (response.getOperations().length == 0) {
            newFromSeqNo = from;
        } else {
            assert (response.getOperations()[0].seqNo() == from) : "first operation is not what we asked for. From is [" + from + "], got " + String.valueOf(response.getOperations()[0]);
            List<Translog.Operation> operations = Arrays.asList(response.getOperations());
            long operationsSize = operations.stream().mapToLong(Translog.Operation::estimateSize).sum();
            this.buffer.addAll(operations);
            this.bufferSizeInBytes += operationsSize;
            long maxSeqNo = response.getOperations()[response.getOperations().length - 1].seqNo();
            assert (maxSeqNo == Arrays.stream(response.getOperations()).mapToLong(Translog.Operation::seqNo).max().getAsLong());
            newFromSeqNo = maxSeqNo + 1L;
            this.lastRequestedSeqNo = Math.max(this.lastRequestedSeqNo, maxSeqNo);
            assert (this.lastRequestedSeqNo <= this.leaderGlobalCheckpoint) : "lastRequestedSeqNo [" + this.lastRequestedSeqNo + "] is larger than the global checkpoint [" + this.leaderGlobalCheckpoint + "]";
            this.coordinateWrites();
        }
        if (newFromSeqNo <= maxRequiredSeqNo) {
            LOGGER.trace("{} received [{}] operations, enqueue partial read request [{}/{}]", (Object)this.params.getFollowShardId(), (Object)response.getOperations().length, (Object)newFromSeqNo, (Object)maxRequiredSeqNo);
            this.partialReadRequests.add((Tuple<Long, Long>)Tuple.tuple((Object)newFromSeqNo, (Object)maxRequiredSeqNo));
        }
        --this.numOutstandingReads;
        this.coordinateReads();
    }

    private void sendBulkShardOperationsRequest(List<Translog.Operation> operations, long leaderMaxSequenceNoOfUpdatesOrDeletes, AtomicInteger retryCounter) {
        assert (leaderMaxSequenceNoOfUpdatesOrDeletes != -2L) : "mus is not replicated";
        long startTime = this.relativeTimeProvider.getAsLong();
        this.innerSendBulkShardOperationsRequest(this.followerHistoryUUID, operations, leaderMaxSequenceNoOfUpdatesOrDeletes, response -> {
            ShardFollowNodeTask shardFollowNodeTask = this;
            synchronized (shardFollowNodeTask) {
                this.totalWriteTimeMillis += TimeUnit.NANOSECONDS.toMillis(this.relativeTimeProvider.getAsLong() - startTime);
                ++this.successfulWriteRequests;
                this.operationWritten += (long)operations.size();
            }
            this.handleWriteResponse((BulkShardOperationsResponse)((Object)response));
        }, e -> {
            ShardFollowNodeTask shardFollowNodeTask = this;
            synchronized (shardFollowNodeTask) {
                this.totalWriteTimeMillis += TimeUnit.NANOSECONDS.toMillis(this.relativeTimeProvider.getAsLong() - startTime);
                ++this.failedWriteRequests;
            }
            this.handleFailure((Exception)e, retryCounter, () -> this.sendBulkShardOperationsRequest(operations, leaderMaxSequenceNoOfUpdatesOrDeletes, retryCounter));
        });
    }

    private synchronized void handleWriteResponse(BulkShardOperationsResponse response) {
        this.followerGlobalCheckpoint = Math.max(this.followerGlobalCheckpoint, response.getGlobalCheckpoint());
        this.followerMaxSeqNo = Math.max(this.followerMaxSeqNo, response.getMaxSeqNo());
        --this.numOutstandingWrites;
        assert (this.numOutstandingWrites >= 0);
        this.coordinateWrites();
        this.coordinateReads();
    }

    private synchronized void maybeUpdateMapping(long minimumRequiredMappingVersion, Runnable task) {
        if (this.currentMappingVersion >= minimumRequiredMappingVersion) {
            LOGGER.trace("{} mapping version [{}] is higher or equal than minimum required mapping version [{}]", (Object)this.params.getFollowShardId(), (Object)this.currentMappingVersion, (Object)minimumRequiredMappingVersion);
            task.run();
        } else {
            LOGGER.trace("{} updating mapping, mapping version [{}] is lower than minimum required mapping version [{}]", (Object)this.params.getFollowShardId(), (Object)this.currentMappingVersion, (Object)minimumRequiredMappingVersion);
            this.updateMapping(minimumRequiredMappingVersion, mappingVersion -> {
                ShardFollowNodeTask shardFollowNodeTask = this;
                synchronized (shardFollowNodeTask) {
                    this.currentMappingVersion = Math.max(this.currentMappingVersion, mappingVersion);
                }
                task.run();
            });
        }
    }

    private synchronized void maybeUpdateSettings(Long minimumRequiredSettingsVersion, Runnable task) {
        if (this.currentSettingsVersion >= minimumRequiredSettingsVersion) {
            LOGGER.trace("{} settings version [{}] is higher or equal than minimum required settings version [{}]", (Object)this.params.getFollowShardId(), (Object)this.currentSettingsVersion, (Object)minimumRequiredSettingsVersion);
            task.run();
        } else {
            LOGGER.trace("{} updating settings, settings version [{}] is lower than minimum required settings version [{}]", (Object)this.params.getFollowShardId(), (Object)this.currentSettingsVersion, (Object)minimumRequiredSettingsVersion);
            this.updateSettings(settingsVersion -> {
                ShardFollowNodeTask shardFollowNodeTask = this;
                synchronized (shardFollowNodeTask) {
                    this.currentSettingsVersion = Math.max(this.currentSettingsVersion, settingsVersion);
                }
                task.run();
            });
        }
    }

    private synchronized void maybeUpdateAliases(Long minimumRequiredAliasesVersion, Runnable task) {
        if (this.currentAliasesVersion >= minimumRequiredAliasesVersion) {
            LOGGER.trace("{} aliases version [{}] is higher or equal than minimum required aliases version [{}]", (Object)this.params.getFollowShardId(), (Object)this.currentAliasesVersion, (Object)minimumRequiredAliasesVersion);
            task.run();
        } else {
            LOGGER.trace("{} updating aliases, aliases version [{}] is lower than minimum required aliases version [{}]", (Object)this.params.getFollowShardId(), (Object)this.currentAliasesVersion, (Object)minimumRequiredAliasesVersion);
            this.updateAliases(aliasesVersion -> {
                ShardFollowNodeTask shardFollowNodeTask = this;
                synchronized (shardFollowNodeTask) {
                    this.currentAliasesVersion = Math.max(this.currentAliasesVersion, aliasesVersion);
                }
                task.run();
            });
        }
    }

    private void updateMapping(long minRequiredMappingVersion, LongConsumer handler) {
        this.updateMapping(minRequiredMappingVersion, handler, new AtomicInteger(0));
    }

    private void updateMapping(long minRequiredMappingVersion, LongConsumer handler, AtomicInteger retryCounter) {
        this.innerUpdateMapping(minRequiredMappingVersion, handler, e -> this.handleFailure((Exception)e, retryCounter, () -> this.updateMapping(minRequiredMappingVersion, handler, retryCounter)));
    }

    private void updateSettings(LongConsumer handler) {
        this.updateSettings(handler, new AtomicInteger(0));
    }

    private void updateSettings(LongConsumer handler, AtomicInteger retryCounter) {
        this.innerUpdateSettings(handler, e -> this.handleFailure((Exception)e, retryCounter, () -> this.updateSettings(handler, retryCounter)));
    }

    private void updateAliases(LongConsumer handler) {
        this.updateAliases(handler, new AtomicInteger());
    }

    private void updateAliases(LongConsumer handler, AtomicInteger retryCounter) {
        this.innerUpdateAliases(handler, e -> this.handleFailure((Exception)e, retryCounter, () -> this.updateAliases(handler, retryCounter)));
    }

    private void handleFailure(Exception e, AtomicInteger retryCounter, Runnable task) {
        assert (e != null);
        if (ShardFollowNodeTask.shouldRetry(e)) {
            if (!this.isStopped()) {
                int currentRetry = retryCounter.incrementAndGet();
                LOGGER.debug(() -> Strings.format((String)"%s error during follow shard task, retrying [%s]", (Object[])new Object[]{this.params.getFollowShardId(), currentRetry}), (Throwable)e);
                long delay = ShardFollowNodeTask.computeDelay(currentRetry, this.params.getReadPollTimeout().getMillis());
                this.scheduler.accept(TimeValue.timeValueMillis((long)delay), task);
            }
        } else {
            this.onFatalFailure(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onFatalFailure(Exception e) {
        ShardFollowNodeTask shardFollowNodeTask = this;
        synchronized (shardFollowNodeTask) {
            this.fatalException = ExceptionsHelper.convertToElastic((Exception)e);
            if (this.renewable != null) {
                this.renewable.cancel();
                this.renewable = null;
            }
        }
        LOGGER.warn("shard follow task encounter non-retryable error", (Throwable)e);
    }

    static long computeDelay(int currentRetry, long maxRetryDelayInMillis) {
        int maxCurrentRetry = Math.min(currentRetry, 24);
        long n = Math.round(Math.pow(2.0, maxCurrentRetry - 1));
        int k = Randomness.get().nextInt(Math.toIntExact(n + 1L));
        int backOffDelay = k * 50;
        return Math.min((long)backOffDelay, maxRetryDelayInMillis);
    }

    static boolean shouldRetry(Exception e) {
        if (NetworkExceptionHelper.isConnectException((Throwable)e) || NetworkExceptionHelper.getCloseConnectionExceptionLevel((Throwable)e, (boolean)false) != Level.OFF) {
            return true;
        }
        Throwable actual = ExceptionsHelper.unwrapCause((Throwable)e);
        return actual instanceof ShardNotFoundException || actual instanceof IllegalIndexShardStateException || actual instanceof NoShardAvailableActionException || actual instanceof UnavailableShardsException || actual instanceof AlreadyClosedException || actual instanceof ElasticsearchSecurityException || actual instanceof ClusterBlockException || actual instanceof IndexClosedException || actual instanceof ConnectTransportException || actual instanceof NodeClosedException || actual instanceof NoSuchRemoteClusterException || actual instanceof NoSeedNodeLeftException || actual instanceof EsRejectedExecutionException || actual instanceof CircuitBreakingException;
    }

    protected abstract void innerUpdateMapping(long var1, LongConsumer var3, Consumer<Exception> var4);

    protected abstract void innerUpdateSettings(LongConsumer var1, Consumer<Exception> var2);

    protected abstract void innerUpdateAliases(LongConsumer var1, Consumer<Exception> var2);

    protected abstract void innerSendBulkShardOperationsRequest(String var1, List<Translog.Operation> var2, long var3, Consumer<BulkShardOperationsResponse> var5, Consumer<Exception> var6);

    protected abstract void innerSendShardChangesRequest(long var1, int var3, Consumer<ShardChangesAction.Response> var4, Consumer<Exception> var5);

    protected abstract Scheduler.Cancellable scheduleBackgroundRetentionLeaseRenewal(LongSupplier var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onCancelled() {
        ShardFollowNodeTask shardFollowNodeTask = this;
        synchronized (shardFollowNodeTask) {
            if (this.renewable != null) {
                this.renewable.cancel();
                this.renewable = null;
            }
        }
        this.markAsCompleted();
    }

    protected boolean isStopped() {
        return this.fatalException != null || this.isCancelled() || this.isCompleted();
    }

    public ShardId getFollowShardId() {
        return this.params.getFollowShardId();
    }

    public synchronized ShardFollowNodeTaskStatus getStatus() {
        long timeSinceLastFetchMillis = this.lastFetchTime != -1L ? TimeUnit.NANOSECONDS.toMillis(this.relativeTimeProvider.getAsLong() - this.lastFetchTime) : -1L;
        return new ShardFollowNodeTaskStatus(this.params.getRemoteCluster(), this.params.getLeaderShardId().getIndexName(), this.params.getFollowShardId().getIndexName(), this.getFollowShardId().getId(), this.leaderGlobalCheckpoint, this.leaderMaxSeqNo, this.followerGlobalCheckpoint, this.followerMaxSeqNo, this.lastRequestedSeqNo, this.numOutstandingReads, this.numOutstandingWrites, this.buffer.size(), this.bufferSizeInBytes, this.currentMappingVersion, this.currentSettingsVersion, this.currentAliasesVersion, this.totalReadTimeMillis, this.totalReadRemoteExecTimeMillis, this.successfulReadRequests, this.failedReadRequests, this.operationsRead, this.bytesRead, this.totalWriteTimeMillis, this.successfulWriteRequests, this.failedWriteRequests, this.operationWritten, new TreeMap<Long, Tuple>(this.fetchExceptions.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Tuple.tuple((Object)((AtomicInteger)((Tuple)e.getValue()).v1()).get(), (Object)((ElasticsearchException)((Tuple)e.getValue()).v2()))))), timeSinceLastFetchMillis, this.fatalException);
    }
}

