/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.Arrays;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.compute.aggregation.GroupingAggregatorState;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public class RateIntAggregator {
    public static IntRateGroupingState initGrouping(DriverContext driverContext, long unitInMillis) {
        return new IntRateGroupingState(driverContext.bigArrays(), driverContext.breaker(), unitInMillis);
    }

    public static void combine(IntRateGroupingState current, int groupId, long timestamp, int value) {
        current.append(groupId, timestamp, value);
    }

    public static void combineIntermediate(IntRateGroupingState current, int groupId, LongBlock timestamps, IntBlock values, double reset, int otherPosition) {
        current.combine(groupId, timestamps, values, reset, otherPosition);
    }

    public static void combineStates(IntRateGroupingState current, int currentGroupId, IntRateGroupingState otherState, int otherGroupId) {
        current.combineState(currentGroupId, otherState, otherGroupId);
    }

    public static Block evaluateFinal(IntRateGroupingState state, IntVector selected, DriverContext driverContext) {
        return state.evaluateFinal(selected, driverContext.blockFactory());
    }

    public static final class IntRateGroupingState
    implements Releasable,
    Accountable,
    GroupingAggregatorState {
        private ObjectArray<IntRateState> states;
        private final long unitInMillis;
        private final BigArrays bigArrays;
        private final CircuitBreaker breaker;
        private long stateBytes;

        IntRateGroupingState(BigArrays bigArrays, CircuitBreaker breaker, long unitInMillis) {
            this.bigArrays = bigArrays;
            this.breaker = breaker;
            this.states = bigArrays.newObjectArray(1L);
            this.unitInMillis = unitInMillis;
        }

        void ensureCapacity(int groupId) {
            this.states = this.bigArrays.grow(this.states, (long)(groupId + 1));
        }

        void adjustBreaker(long bytes) {
            this.breaker.addEstimateBytesAndMaybeBreak(bytes, "<<rate aggregation>>");
            this.stateBytes += bytes;
            assert (this.stateBytes >= 0L) : this.stateBytes;
        }

        void append(int groupId, long timestamp, int value) {
            this.ensureCapacity(groupId);
            IntRateState state = (IntRateState)this.states.get((long)groupId);
            if (state == null) {
                this.adjustBreaker(IntRateState.bytesUsed(1));
                state = new IntRateState(new long[]{timestamp}, new int[]{value});
                this.states.set((long)groupId, (Object)state);
            } else if (state.entries() == 1) {
                this.adjustBreaker(IntRateState.bytesUsed(2));
                state = new IntRateState(new long[]{state.timestamps[0], timestamp}, new int[]{state.values[0], value});
                this.states.set((long)groupId, (Object)state);
                this.adjustBreaker(-IntRateState.bytesUsed(1));
            } else {
                state.append(timestamp, value);
            }
        }

        void combine(int groupId, LongBlock timestamps, IntBlock values, double reset, int otherPosition) {
            int valueCount = timestamps.getValueCount(otherPosition);
            if (valueCount == 0) {
                return;
            }
            int firstIndex = timestamps.getFirstValueIndex(otherPosition);
            this.ensureCapacity(groupId);
            IntRateState state = (IntRateState)this.states.get((long)groupId);
            if (state == null) {
                this.adjustBreaker(IntRateState.bytesUsed(valueCount));
                state = new IntRateState(valueCount);
                state.reset = reset;
                this.states.set((long)groupId, (Object)state);
                for (int i = 0; i < valueCount; ++i) {
                    state.timestamps[i] = timestamps.getLong(firstIndex + i);
                    state.values[i] = values.getInt(firstIndex + i);
                }
            } else {
                this.adjustBreaker(IntRateState.bytesUsed(state.entries() + valueCount));
                IntRateState newState = new IntRateState(state.entries() + valueCount);
                newState.reset = state.reset + reset;
                this.states.set((long)groupId, (Object)newState);
                this.merge(state, newState, firstIndex, valueCount, timestamps, values);
                this.adjustBreaker(-IntRateState.bytesUsed(state.entries()));
            }
        }

        void merge(IntRateState curr, IntRateState dst, int firstIndex, int rightCount, LongBlock timestamps, IntBlock values) {
            int i = 0;
            int j = 0;
            int k = 0;
            int leftCount = curr.entries();
            while (i < leftCount && j < rightCount) {
                long t1 = curr.timestamps[i];
                long t2 = timestamps.getLong(firstIndex + j);
                if (t1 > t2) {
                    dst.timestamps[k] = t1;
                    dst.values[k] = curr.values[i];
                    ++i;
                } else {
                    dst.timestamps[k] = t2;
                    dst.values[k] = values.getInt(firstIndex + j);
                    ++j;
                }
                ++k;
            }
            if (i < leftCount) {
                System.arraycopy(curr.timestamps, i, dst.timestamps, k, leftCount - i);
                System.arraycopy(curr.values, i, dst.values, k, leftCount - i);
            }
            while (j < rightCount) {
                dst.timestamps[k] = timestamps.getLong(firstIndex + j);
                dst.values[k] = values.getInt(firstIndex + j);
                ++k;
                ++j;
            }
        }

        void combineState(int groupId, IntRateGroupingState otherState, int otherGroupId) {
            IntRateState other;
            IntRateState intRateState = other = (long)otherGroupId < otherState.states.size() ? (IntRateState)otherState.states.get((long)otherGroupId) : null;
            if (other == null) {
                return;
            }
            this.ensureCapacity(groupId);
            IntRateState curr = (IntRateState)this.states.get((long)groupId);
            if (curr == null) {
                int len = other.entries();
                this.adjustBreaker(IntRateState.bytesUsed(len));
                curr = new IntRateState(Arrays.copyOf(other.timestamps, len), Arrays.copyOf(other.values, len));
                curr.reset = other.reset;
                this.states.set((long)groupId, (Object)curr);
            } else {
                this.states.set((long)groupId, (Object)this.mergeState(curr, other));
            }
        }

        IntRateState mergeState(IntRateState s1, IntRateState s2) {
            int newLen = s1.entries() + s2.entries();
            this.adjustBreaker(IntRateState.bytesUsed(newLen));
            IntRateState dst = new IntRateState(newLen);
            dst.reset = s1.reset + s2.reset;
            int i = 0;
            int j = 0;
            int k = 0;
            while (i < s1.entries() && j < s2.entries()) {
                if (s1.timestamps[i] > s2.timestamps[j]) {
                    dst.timestamps[k] = s1.timestamps[i];
                    dst.values[k] = s1.values[i];
                    ++i;
                } else {
                    dst.timestamps[k] = s2.timestamps[j];
                    dst.values[k] = s2.values[j];
                    ++j;
                }
                ++k;
            }
            System.arraycopy(s1.timestamps, i, dst.timestamps, k, s1.entries() - i);
            System.arraycopy(s1.values, i, dst.values, k, s1.entries() - i);
            System.arraycopy(s2.timestamps, j, dst.timestamps, k, s2.entries() - j);
            System.arraycopy(s2.values, j, dst.values, k, s2.entries() - j);
            return dst;
        }

        public long ramBytesUsed() {
            return this.states.ramBytesUsed() + this.stateBytes;
        }

        public void close() {
            Releasables.close((Releasable[])new Releasable[]{this.states, () -> this.adjustBreaker(-this.stateBytes)});
        }

        @Override
        public void toIntermediate(Block[] blocks, int offset, IntVector selected, DriverContext driverContext) {
            assert (blocks.length >= offset + 3) : "blocks=" + blocks.length + ",offset=" + offset;
            BlockFactory blockFactory = driverContext.blockFactory();
            int positionCount = selected.getPositionCount();
            try (LongBlock.Builder timestamps = blockFactory.newLongBlockBuilder(positionCount * 2);
                 IntBlock.Builder values = blockFactory.newIntBlockBuilder(positionCount * 2);
                 DoubleVector.FixedBuilder resets = blockFactory.newDoubleVectorFixedBuilder(positionCount);){
                for (int i = 0; i < positionCount; ++i) {
                    IntRateState state;
                    int groupId = selected.getInt(i);
                    IntRateState intRateState = state = (long)groupId < this.states.size() ? (IntRateState)this.states.get((long)groupId) : null;
                    if (state != null) {
                        timestamps.beginPositionEntry();
                        for (long t : state.timestamps) {
                            timestamps.appendLong(t);
                        }
                        timestamps.endPositionEntry();
                        values.beginPositionEntry();
                        for (int v : state.values) {
                            values.appendInt(v);
                        }
                        values.endPositionEntry();
                        resets.appendDouble(i, state.reset);
                        continue;
                    }
                    timestamps.appendNull();
                    values.appendNull();
                    resets.appendDouble(i, 0.0);
                }
                blocks[offset] = timestamps.build();
                blocks[offset + 1] = values.build();
                blocks[offset + 2] = resets.build().asBlock();
            }
        }

        Block evaluateFinal(IntVector selected, BlockFactory blockFactory) {
            int positionCount = selected.getPositionCount();
            try (DoubleBlock.Builder rates = blockFactory.newDoubleBlockBuilder(positionCount);){
                for (int p = 0; p < positionCount; ++p) {
                    IntRateState state;
                    int groupId = selected.getInt(p);
                    IntRateState intRateState = state = (long)groupId < this.states.size() ? (IntRateState)this.states.get((long)groupId) : null;
                    if (state == null) {
                        rates.appendNull();
                        continue;
                    }
                    int len = state.entries();
                    long dt = state.timestamps[0] - state.timestamps[len - 1];
                    if (dt == 0L) {
                        rates.appendNull();
                        continue;
                    }
                    double reset = state.reset;
                    for (int i = 1; i < len; ++i) {
                        if (state.values[i - 1] >= state.values[i]) continue;
                        reset += (double)state.values[i];
                    }
                    double dv = (double)(state.values[0] - state.values[len - 1]) + reset;
                    rates.appendDouble(dv * (double)this.unitInMillis / (double)dt);
                }
                DoubleBlock doubleBlock = rates.build();
                return doubleBlock;
            }
        }

        @Override
        public void enableGroupIdTracking(SeenGroupIds seenGroupIds) {
        }
    }

    private static class IntRateState {
        static final long BASE_RAM_USAGE = RamUsageEstimator.sizeOfObject(IntRateState.class);
        final long[] timestamps;
        final int[] values;
        double reset = 0.0;

        IntRateState(int initialSize) {
            this.timestamps = new long[initialSize];
            this.values = new int[initialSize];
        }

        IntRateState(long[] ts, int[] vs) {
            this.timestamps = ts;
            this.values = vs;
        }

        private int dv(int v0, int v1) {
            return v0 > v1 ? v1 : v1 - v0;
        }

        void append(long t, int v) {
            assert (this.timestamps.length == 2) : "expected two timestamps; got " + this.timestamps.length;
            assert (t < this.timestamps[1]) : "@timestamp goes backward: " + t + " >= " + this.timestamps[1];
            this.reset += (double)(this.dv(v, this.values[1]) + this.dv(this.values[1], this.values[0]) - this.dv(v, this.values[0]));
            this.timestamps[1] = t;
            this.values[1] = v;
        }

        int entries() {
            return this.timestamps.length;
        }

        static long bytesUsed(int entries) {
            long ts = RamUsageEstimator.alignObjectSize((long)((long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + 8L * (long)entries));
            long vs = RamUsageEstimator.alignObjectSize((long)((long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + 4L * (long)entries));
            return BASE_RAM_USAGE + ts + vs;
        }
    }
}

