/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.saml;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.security.action.saml.SamlInvalidateSessionAction;
import org.elasticsearch.xpack.core.security.action.saml.SamlInvalidateSessionRequest;
import org.elasticsearch.xpack.core.security.action.saml.SamlInvalidateSessionResponse;
import org.elasticsearch.xpack.security.rest.action.saml.SamlBaseRestHandler;

@ServerlessScope(value=Scope.INTERNAL)
public class RestSamlInvalidateSessionAction
extends SamlBaseRestHandler {
    static final ObjectParser<SamlInvalidateSessionRequest, RestSamlInvalidateSessionAction> PARSER = new ObjectParser("saml_invalidate_session", SamlInvalidateSessionRequest::new);

    public RestSamlInvalidateSessionAction(Settings settings, XPackLicenseState licenseState) {
        super(settings, licenseState);
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_security/saml/invalidate"));
    }

    public String getName() {
        return "security_saml_invalidate_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        try (XContentParser parser = request.contentParser();){
            SamlInvalidateSessionRequest invalidateRequest = (SamlInvalidateSessionRequest)PARSER.parse(parser, (Object)this);
            BaseRestHandler.RestChannelConsumer restChannelConsumer = channel -> client.execute((ActionType)SamlInvalidateSessionAction.INSTANCE, (ActionRequest)invalidateRequest, (ActionListener)new RestBuilderListener<SamlInvalidateSessionResponse>(this, channel){

                public RestResponse buildResponse(SamlInvalidateSessionResponse resp, XContentBuilder builder) throws Exception {
                    builder.startObject();
                    builder.field("realm", resp.getRealmName());
                    builder.field("invalidated", resp.getCount());
                    builder.field("redirect", resp.getRedirectUrl());
                    builder.endObject();
                    return new RestResponse(RestStatus.OK, builder);
                }
            });
            return restChannelConsumer;
        }
    }

    static {
        PARSER.declareString(SamlInvalidateSessionRequest::setQueryString, new ParseField("query_string", new String[]{"queryString"}));
        PARSER.declareString(SamlInvalidateSessionRequest::setAssertionConsumerServiceURL, new ParseField("acs", new String[0]));
        PARSER.declareString(SamlInvalidateSessionRequest::setRealmName, new ParseField("realm", new String[0]));
    }
}

