/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.series.primitive;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.series.BasicSeries;
import org.ojalgo.series.primitive.DataSeries;
import org.ojalgo.series.primitive.PrimitiveSeries;

public class CoordinatedSet<K extends Comparable<? super K>> {
    private final PrimitiveSeries[] myCoordinated;
    private final K myFirstKey;
    private final K myLastKey;

    public static <K extends Comparable<? super K>> Builder<K> builder() {
        return new Builder();
    }

    public static <K extends Comparable<? super K>> CoordinatedSet<K> from(BasicSeries<K, ?> ... uncoordinated) {
        return CoordinatedSet.from(Arrays.asList(uncoordinated));
    }

    public static <K extends Comparable<? super K>> CoordinatedSet<K> from(List<? extends BasicSeries<K, ?>> uncoordinated) {
        Object first = BasicSeries.findLatestFirstKey(uncoordinated);
        Object last = BasicSeries.findEarliestLastKey(uncoordinated);
        TreeSet relevantKeys = new TreeSet();
        for (BasicSeries individual : uncoordinated) {
            relevantKeys.addAll(individual.subMap(first, last).keySet());
        }
        relevantKeys.add(last);
        int numberOfSeries = uncoordinated.size();
        int numberOfKeys = relevantKeys.size();
        PrimitiveSeries[] coordinated = new PrimitiveSeries[numberOfSeries];
        for (int s = 0; s < numberOfSeries; ++s) {
            BasicSeries<Comparable, ?> inputSeries = uncoordinated.get(s);
            double[] outputSeries = new double[numberOfKeys];
            double tmpVal = Double.NaN;
            double curVal = Double.NaN;
            int k = 0;
            for (Comparable key : relevantKeys) {
                tmpVal = inputSeries.doubleValue(key);
                if (Double.isNaN(tmpVal)) {
                    tmpVal = curVal;
                }
                outputSeries[k] = tmpVal;
                curVal = tmpVal;
                ++k;
            }
            coordinated[s] = DataSeries.wrap(outputSeries);
        }
        return new CoordinatedSet(coordinated, first, last);
    }

    private CoordinatedSet(PrimitiveSeries[] coordinated, K first, K last) {
        this.myCoordinated = coordinated;
        this.myFirstKey = first;
        this.myLastKey = last;
    }

    public K getFirstKey() {
        return this.myFirstKey;
    }

    public K getLastKey() {
        return this.myLastKey;
    }

    public MatrixStore<Double> getSamples() {
        return (MatrixStore)Primitive64Store.FACTORY.columns(this.myCoordinated);
    }

    public MatrixStore<Double> getSamples(UnaryOperator<PrimitiveSeries> operator) {
        PrimitiveSeries[] operated = new PrimitiveSeries[this.myCoordinated.length];
        for (int i = 0; i < operated.length; ++i) {
            operated[i] = (PrimitiveSeries)operator.apply(this.myCoordinated[i]);
        }
        return (MatrixStore)Primitive64Store.FACTORY.columns(operated);
    }

    public PrimitiveSeries getSeries(int index) {
        return this.myCoordinated[index];
    }

    public int size() {
        return this.myCoordinated.length;
    }

    public static final class Builder<K extends Comparable<? super K>> {
        private final List<Supplier<BasicSeries<K, ?>>> mySuppliers = new ArrayList();

        public Builder<K> add(Supplier<BasicSeries<K, ?>> supplier) {
            this.mySuppliers.add(supplier);
            return this;
        }

        public CoordinatedSet<K> build() {
            ArrayList uncoordinated = new ArrayList();
            for (Supplier<BasicSeries<K, ?>> supplier : this.mySuppliers) {
                uncoordinated.add(supplier.get());
            }
            return CoordinatedSet.from(uncoordinated);
        }
    }
}

