/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.scalar;

import org.ojalgo.scalar.ExactDecimal;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.type.NumberDefinition;

public final class Money
extends ExactDecimal<Money> {
    public static final ExactDecimal.Descriptor DESCRIPTOR = new ExactDecimal.Descriptor(4);
    public static final Scalar.Factory<Money> FACTORY = new ExactDecimal.Factory<Money>(){

        @Override
        public Money cast(Comparable<?> number) {
            return Money.valueOf(number);
        }

        @Override
        public Money cast(double value) {
            return Money.valueOf(value);
        }

        public Money convert(Comparable<?> number) {
            return Money.valueOf(number);
        }

        public Money convert(double value) {
            return Money.valueOf(value);
        }

        @Override
        public ExactDecimal.Descriptor descriptor() {
            return DESCRIPTOR;
        }

        public Money one() {
            return ONE;
        }

        public Money zero() {
            return ZERO;
        }
    };
    private static final double DOUBLE_DENOMINATOR = 10000.0;
    private static final long LONG_DENOMINATOR = 10000L;
    public static final Money NEG = new Money(-10000L);
    public static final Money ONE = new Money(10000L);
    public static final Money TWO = new Money(20000L);
    public static final Money ZERO = new Money();

    public static boolean isAbsolute(Money value) {
        return value.isAbsolute();
    }

    public static boolean isInfinite(Money value) {
        return false;
    }

    public static boolean isNaN(Money value) {
        return false;
    }

    public static boolean isSmall(double comparedTo, Money value) {
        return value.isSmall(comparedTo);
    }

    public static Money valueOf(Comparable<?> number) {
        if (number != null) {
            if (number instanceof Money) {
                return (Money)number;
            }
            return Money.valueOf(NumberDefinition.doubleValue(number));
        }
        return ZERO;
    }

    public static Money valueOf(double value) {
        return new Money(Math.round(value * 10000.0));
    }

    public Money() {
        super(0L);
    }

    Money(long numerator) {
        super(numerator);
    }

    @Override
    protected ExactDecimal.Descriptor descriptor() {
        return DESCRIPTOR;
    }

    @Override
    protected Money wrap(long numerator) {
        return new Money(numerator);
    }
}

