/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.netio;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.ojalgo.netio.ASCII;
import org.ojalgo.netio.BasicLogger;
import org.ojalgo.random.Uniform;

public class Password {
    private static MessageDigest INSTANCE;

    public static String encrypt(String plainTextPassword) {
        String retVal = null;
        MessageDigest digest = Password.getInstance();
        if (plainTextPassword != null) {
            byte[] tmpBytes = digest.digest(plainTextPassword.getBytes());
            for (int i = 0; i < tmpBytes.length; ++i) {
                if (tmpBytes[i] < 0) {
                    tmpBytes[i] = (byte)(tmpBytes[i] + 128);
                }
                if (tmpBytes[i] < 32) {
                    tmpBytes[i] = (byte)(tmpBytes[i] + 32);
                }
                if (tmpBytes[i] != 34 && tmpBytes[i] != 38 && tmpBytes[i] != 39 && tmpBytes[i] != 47 && tmpBytes[i] != 60 && tmpBytes[i] != 62 && tmpBytes[i] != 92) continue;
                tmpBytes[i] = 32;
            }
            retVal = new String(tmpBytes).trim();
        }
        return retVal;
    }

    public static String encrypt(String plainTextPassword, String toBytesEncoding, String fromBytesEncoding) {
        String retVal = null;
        MessageDigest digest = Password.getInstance();
        if (plainTextPassword != null) {
            try {
                byte[] tmpBytes = digest.digest(plainTextPassword.getBytes(toBytesEncoding));
                retVal = new String(tmpBytes, fromBytesEncoding).trim();
            }
            catch (UnsupportedEncodingException cause) {
                BasicLogger.error(cause.toString());
            }
        }
        return retVal;
    }

    public static String makePlainText(int length) {
        char[] retVal = new char[length];
        Uniform random = new Uniform(0.0, 128.0);
        for (int c = 0; c < length; ++c) {
            int tmpChar = 160;
            while (!ASCII.isAlphanumeric(tmpChar = random.intValue())) {
            }
            retVal[c] = (char)tmpChar;
        }
        return String.valueOf(retVal);
    }

    private static MessageDigest getInstance() {
        if (INSTANCE == null) {
            try {
                INSTANCE = MessageDigest.getInstance("SHA-512");
            }
            catch (NoSuchAlgorithmException cause) {
                BasicLogger.error(cause.toString());
            }
        }
        return INSTANCE;
    }

    protected Password() {
    }
}

