/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.misc.store;

import java.io.EOFException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.OptionalLong;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.BufferedChecksum;
import org.apache.lucene.store.BufferedIndexInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;

public class DirectIODirectory
extends FilterDirectory {
    public static final int DEFAULT_MERGE_BUFFER_SIZE = 262144;
    public static final long DEFAULT_MIN_BYTES_DIRECT = 0xA00000L;
    private final int blockSize;
    private final int mergeBufferSize;
    private final long minBytesDirect;
    volatile boolean isOpen = true;
    static final OpenOption ExtendedOpenOption_DIRECT;

    public DirectIODirectory(FSDirectory delegate, int mergeBufferSize, long minBytesDirect) throws IOException {
        super((Directory)delegate);
        this.blockSize = Math.toIntExact(Files.getFileStore(delegate.getDirectory()).getBlockSize());
        this.mergeBufferSize = mergeBufferSize;
        this.minBytesDirect = minBytesDirect;
    }

    public DirectIODirectory(FSDirectory delegate) throws IOException {
        this(delegate, 262144, 0xA00000L);
    }

    public Path getDirectory() {
        return ((FSDirectory)this.in).getDirectory();
    }

    protected void ensureOpen() throws AlreadyClosedException {
        if (!this.isOpen) {
            throw new AlreadyClosedException("this Directory is closed");
        }
    }

    protected boolean useDirectIO(String name, IOContext context, OptionalLong fileLength) {
        return context.context() == IOContext.Context.MERGE && context.mergeInfo().estimatedMergeBytes() >= this.minBytesDirect && fileLength.orElse(this.minBytesDirect) >= this.minBytesDirect;
    }

    public IndexInput openInput(String name, IOContext context) throws IOException {
        this.ensureOpen();
        if (this.useDirectIO(name, context, OptionalLong.of(this.fileLength(name)))) {
            return new DirectIOIndexInput(this.getDirectory().resolve(name), this.blockSize, this.mergeBufferSize);
        }
        return this.in.openInput(name, context);
    }

    public IndexOutput createOutput(String name, IOContext context) throws IOException {
        this.ensureOpen();
        if (this.useDirectIO(name, context, OptionalLong.empty())) {
            return new DirectIOIndexOutput(this.getDirectory().resolve(name), name, this.blockSize, this.mergeBufferSize);
        }
        return this.in.createOutput(name, context);
    }

    public void close() throws IOException {
        this.isOpen = false;
        super.close();
    }

    private static OpenOption getDirectOpenOption() {
        if (ExtendedOpenOption_DIRECT == null) {
            throw new UnsupportedOperationException("com.sun.nio.file.ExtendedOpenOption.DIRECT is not available in the current JDK version.");
        }
        return ExtendedOpenOption_DIRECT;
    }

    static {
        OpenOption option;
        try {
            Class<OpenOption> clazz = Class.forName("com.sun.nio.file.ExtendedOpenOption").asSubclass(OpenOption.class);
            option = Arrays.stream(clazz.getEnumConstants()).filter(e -> e.toString().equalsIgnoreCase("DIRECT")).findFirst().orElse(null);
        }
        catch (Exception e2) {
            option = null;
        }
        ExtendedOpenOption_DIRECT = option;
    }

    private static final class DirectIOIndexInput
    extends IndexInput {
        private final ByteBuffer buffer;
        private final FileChannel channel;
        private final int blockSize;
        private boolean isOpen;
        private boolean isClone;
        private long filePos;

        public DirectIOIndexInput(Path path, int blockSize, int bufferSize) throws IOException {
            super("DirectIOIndexInput(path=\"" + String.valueOf(path) + "\")");
            this.blockSize = blockSize;
            this.channel = FileChannel.open(path, StandardOpenOption.READ, DirectIODirectory.getDirectOpenOption());
            this.buffer = ByteBuffer.allocateDirect(bufferSize + blockSize - 1).alignedSlice(blockSize);
            this.isOpen = true;
            this.isClone = false;
            this.filePos = -bufferSize;
            this.buffer.limit(0);
        }

        private DirectIOIndexInput(DirectIOIndexInput other) throws IOException {
            super(other.toString());
            this.channel = other.channel;
            this.blockSize = other.blockSize;
            int bufferSize = other.buffer.capacity();
            this.buffer = ByteBuffer.allocateDirect(bufferSize + this.blockSize - 1).alignedSlice(this.blockSize);
            this.isOpen = true;
            this.isClone = true;
            this.filePos = -bufferSize;
            this.buffer.limit(0);
            this.seek(other.getFilePointer());
        }

        public void close() throws IOException {
            if (this.isOpen && !this.isClone) {
                this.channel.close();
            }
        }

        public long getFilePointer() {
            long filePointer = this.filePos + (long)this.buffer.position();
            assert (filePointer == (long)(-this.buffer.capacity()) || filePointer >= 0L) : "filePointer should either be initial value equal to negative buffer capacity, or larger than or equal to 0";
            return Math.max(filePointer, 0L);
        }

        public void seek(long pos) throws IOException {
            if (pos != this.getFilePointer()) {
                long alignedPos = pos - pos % (long)this.blockSize;
                this.filePos = alignedPos - (long)this.buffer.capacity();
                int delta = (int)(pos - alignedPos);
                this.refill(delta);
                this.buffer.position(delta);
            }
            assert (pos == this.getFilePointer());
        }

        public long length() {
            try {
                return this.channel.size();
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe);
            }
        }

        public byte readByte() throws IOException {
            if (!this.buffer.hasRemaining()) {
                this.refill(1);
            }
            return this.buffer.get();
        }

        private void refill(int bytesToRead) throws IOException {
            this.filePos += (long)this.buffer.capacity();
            if (this.filePos > this.channel.size() || this.channel.size() - this.filePos < (long)bytesToRead) {
                throw new EOFException("read past EOF: " + String.valueOf((Object)this));
            }
            this.buffer.clear();
            try {
                this.channel.read(this.buffer, this.filePos);
            }
            catch (IOException ioe) {
                throw new IOException(ioe.getMessage() + ": " + String.valueOf((Object)this), ioe);
            }
            this.buffer.flip();
        }

        public void readBytes(byte[] dst, int offset, int len) throws IOException {
            int left;
            int toRead = len;
            while ((left = this.buffer.remaining()) < toRead) {
                this.buffer.get(dst, offset, left);
                offset += left;
                this.refill(toRead -= left);
            }
            this.buffer.get(dst, offset, toRead);
        }

        public DirectIOIndexInput clone() {
            try {
                return new DirectIOIndexInput(this);
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe);
            }
        }

        public IndexInput slice(String sliceDescription, long offset, long length) {
            return BufferedIndexInput.wrap((String)sliceDescription, (IndexInput)this, (long)offset, (long)length);
        }
    }

    private static final class DirectIOIndexOutput
    extends IndexOutput {
        private final ByteBuffer buffer;
        private final FileChannel channel;
        private final Checksum digest;
        private long filePos;
        private boolean isOpen;

        public DirectIOIndexOutput(Path path, String name, int blockSize, int bufferSize) throws IOException {
            super("DirectIOIndexOutput(path=\"" + path.toString() + "\")", name);
            this.channel = FileChannel.open(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW, DirectIODirectory.getDirectOpenOption());
            this.buffer = ByteBuffer.allocateDirect(bufferSize + blockSize - 1).alignedSlice(blockSize);
            this.digest = new BufferedChecksum((Checksum)new CRC32());
            this.isOpen = true;
        }

        public void writeByte(byte b) throws IOException {
            this.buffer.put(b);
            this.digest.update(b);
            if (!this.buffer.hasRemaining()) {
                this.dump();
            }
        }

        public void writeBytes(byte[] src, int offset, int len) throws IOException {
            int left;
            int toWrite = len;
            while ((left = this.buffer.remaining()) <= toWrite) {
                this.buffer.put(src, offset, left);
                this.digest.update(src, offset, left);
                toWrite -= left;
                offset += left;
                this.dump();
            }
            this.buffer.put(src, offset, toWrite);
            this.digest.update(src, offset, toWrite);
        }

        private void dump() throws IOException {
            int size = this.buffer.position();
            this.buffer.rewind();
            this.channel.write(this.buffer, this.filePos);
            this.filePos += (long)size;
            this.buffer.clear();
        }

        public long getFilePointer() {
            return this.filePos + (long)this.buffer.position();
        }

        public long getChecksum() {
            return this.digest.getValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            if (this.isOpen) {
                this.isOpen = false;
                try {
                    this.dump();
                }
                finally {
                    try (FileChannel ch = this.channel;){
                        ch.truncate(this.getFilePointer());
                    }
                }
            }
        }
    }
}

