/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.role;

import java.util.Arrays;
import java.util.Set;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.privilege.ApplicationPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.ClusterPrivilegeResolver;
import org.elasticsearch.xpack.core.security.authz.privilege.IndexPrivilege;
import org.elasticsearch.xpack.core.security.authz.restriction.WorkflowResolver;
import org.elasticsearch.xpack.core.security.support.MetadataUtils;
import org.elasticsearch.xpack.core.security.support.Validation;

public class RoleDescriptorRequestValidator {
    private RoleDescriptorRequestValidator() {
    }

    public static ActionRequestValidationException validate(RoleDescriptor roleDescriptor) {
        return RoleDescriptorRequestValidator.validate(roleDescriptor, null);
    }

    public static ActionRequestValidationException validate(RoleDescriptor roleDescriptor, ActionRequestValidationException validationException) {
        Validation.Error error;
        RoleDescriptor.RemoteIndicesPrivileges[] remoteIndicesPrivileges;
        if (roleDescriptor.getName() == null) {
            validationException = ValidateActions.addValidationError((String)"role name is missing", (ActionRequestValidationException)validationException);
        }
        if (roleDescriptor.getClusterPrivileges() != null) {
            for (String cp : roleDescriptor.getClusterPrivileges()) {
                try {
                    ClusterPrivilegeResolver.resolve(cp);
                }
                catch (IllegalArgumentException ile) {
                    validationException = ValidateActions.addValidationError((String)ile.getMessage(), (ActionRequestValidationException)validationException);
                }
            }
        }
        if (roleDescriptor.getIndicesPrivileges() != null) {
            for (RoleDescriptor.IndicesPrivileges idp : roleDescriptor.getIndicesPrivileges()) {
                try {
                    IndexPrivilege.get(Set.of(idp.getPrivileges()));
                }
                catch (IllegalArgumentException ile) {
                    validationException = ValidateActions.addValidationError((String)ile.getMessage(), (ActionRequestValidationException)validationException);
                }
            }
        }
        for (RoleDescriptor.RemoteIndicesPrivileges ridp : remoteIndicesPrivileges = roleDescriptor.getRemoteIndicesPrivileges()) {
            if (Arrays.asList(ridp.remoteClusters()).contains("")) {
                validationException = ValidateActions.addValidationError((String)"remote index cluster alias cannot be an empty string", (ActionRequestValidationException)validationException);
            }
            try {
                IndexPrivilege.get(Set.of(ridp.indicesPrivileges().getPrivileges()));
            }
            catch (IllegalArgumentException ile) {
                validationException = ValidateActions.addValidationError((String)ile.getMessage(), (ActionRequestValidationException)validationException);
            }
        }
        if (roleDescriptor.hasRemoteClusterPermissions()) {
            try {
                roleDescriptor.getRemoteClusterPermissions().validate();
            }
            catch (IllegalArgumentException e) {
                validationException = ValidateActions.addValidationError((String)e.getMessage(), (ActionRequestValidationException)validationException);
            }
        }
        if (roleDescriptor.getApplicationPrivileges() != null) {
            for (RoleDescriptor.ApplicationResourcePrivileges privilege : roleDescriptor.getApplicationPrivileges()) {
                try {
                    ApplicationPrivilege.validateApplicationNameOrWildcard(privilege.getApplication());
                }
                catch (IllegalArgumentException e) {
                    validationException = ValidateActions.addValidationError((String)e.getMessage(), (ActionRequestValidationException)validationException);
                }
                for (String privilegeName : privilege.getPrivileges()) {
                    try {
                        ApplicationPrivilege.validatePrivilegeOrActionName(privilegeName);
                    }
                    catch (IllegalArgumentException e) {
                        validationException = ValidateActions.addValidationError((String)e.getMessage(), (ActionRequestValidationException)validationException);
                    }
                }
            }
        }
        if (roleDescriptor.getMetadata() != null && MetadataUtils.containsReservedMetadata(roleDescriptor.getMetadata())) {
            validationException = ValidateActions.addValidationError((String)"role descriptor metadata keys may not start with [_]", (ActionRequestValidationException)validationException);
        }
        if (roleDescriptor.hasWorkflowsRestriction()) {
            for (String workflowName : roleDescriptor.getRestriction().getWorkflows()) {
                try {
                    WorkflowResolver.resolveWorkflowByName(workflowName);
                }
                catch (IllegalArgumentException e) {
                    validationException = ValidateActions.addValidationError((String)e.getMessage(), (ActionRequestValidationException)validationException);
                }
            }
        }
        if (roleDescriptor.hasDescription() && (error = Validation.Roles.validateRoleDescription(roleDescriptor.getDescription())) != null) {
            validationException = ValidateActions.addValidationError((String)error.toString(), (ActionRequestValidationException)validationException);
        }
        return validationException;
    }
}

