/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.action.AbstractGetResourcesResponse;
import org.elasticsearch.xpack.core.action.util.PageParams;
import org.elasticsearch.xpack.core.action.util.QueryPage;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.results.Bucket;
import org.elasticsearch.xpack.core.ml.job.results.Result;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class GetBucketsAction
extends ActionType<Response> {
    public static final GetBucketsAction INSTANCE = new GetBucketsAction();
    public static final String NAME = "cluster:monitor/xpack/ml/job/results/buckets/get";

    private GetBucketsAction() {
        super(NAME);
    }

    public static class Response
    extends AbstractGetResourcesResponse<Bucket>
    implements ToXContentObject {
        public Response(StreamInput in) throws IOException {
            super(in);
        }

        public Response(QueryPage<Bucket> buckets) {
            super(buckets);
        }

        public QueryPage<Bucket> getBuckets() {
            return this.getResources();
        }

        @Override
        protected Writeable.Reader<Bucket> getReader() {
            return Bucket::new;
        }
    }

    public static class Request
    extends ActionRequest
    implements ToXContentObject {
        public static final ParseField EXPAND = new ParseField("expand", new String[0]);
        public static final ParseField EXCLUDE_INTERIM = new ParseField("exclude_interim", new String[0]);
        public static final ParseField START = new ParseField("start", new String[0]);
        public static final ParseField END = new ParseField("end", new String[0]);
        public static final ParseField ANOMALY_SCORE = new ParseField("anomaly_score", new String[0]);
        public static final ParseField TIMESTAMP = new ParseField("timestamp", new String[0]);
        public static final ParseField SORT = new ParseField("sort", new String[0]);
        public static final ParseField DESCENDING = new ParseField("desc", new String[0]);
        private static final ObjectParser<Request, Void> PARSER = new ObjectParser("cluster:monitor/xpack/ml/job/results/buckets/get", Request::new);
        private String jobId;
        private String timestamp;
        private boolean expand = false;
        private boolean excludeInterim = false;
        private String start;
        private String end;
        private PageParams pageParams;
        private Double anomalyScore;
        private String sort = Result.TIMESTAMP.getPreferredName();
        private boolean descending = false;

        public static Request parseRequest(String jobId, XContentParser parser) {
            Request request = (Request)((Object)PARSER.apply(parser, null));
            if (jobId != null) {
                request.jobId = jobId;
            }
            return request;
        }

        public Request() {
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.jobId = in.readString();
            this.timestamp = in.readOptionalString();
            this.expand = in.readBoolean();
            this.excludeInterim = in.readBoolean();
            this.start = in.readOptionalString();
            this.end = in.readOptionalString();
            this.anomalyScore = in.readOptionalDouble();
            this.pageParams = (PageParams)in.readOptionalWriteable(PageParams::new);
            this.sort = in.readString();
            this.descending = in.readBoolean();
        }

        public Request(String jobId) {
            this.jobId = ExceptionsHelper.requireNonNull(jobId, Job.ID.getPreferredName());
        }

        public String getJobId() {
            return this.jobId;
        }

        public void setTimestamp(String timestamp) {
            if (this.pageParams != null || this.start != null || this.end != null || this.anomalyScore != null) {
                throw new IllegalArgumentException("Param [" + TIMESTAMP.getPreferredName() + "] is incompatible with [" + PageParams.FROM.getPreferredName() + "," + PageParams.SIZE.getPreferredName() + "," + START.getPreferredName() + "," + END.getPreferredName() + "," + ANOMALY_SCORE.getPreferredName() + "]");
            }
            this.timestamp = ExceptionsHelper.requireNonNull(timestamp, Result.TIMESTAMP.getPreferredName());
        }

        public String getTimestamp() {
            return this.timestamp;
        }

        public boolean isExpand() {
            return this.expand;
        }

        public void setExpand(boolean expand) {
            this.expand = expand;
        }

        public boolean isExcludeInterim() {
            return this.excludeInterim;
        }

        public void setExcludeInterim(boolean excludeInterim) {
            this.excludeInterim = excludeInterim;
        }

        public String getStart() {
            return this.start;
        }

        public void setStart(String start) {
            if (this.timestamp != null) {
                throw new IllegalArgumentException("Param [" + START.getPreferredName() + "] is incompatible with [" + TIMESTAMP.getPreferredName() + "].");
            }
            this.start = start;
        }

        public String getEnd() {
            return this.end;
        }

        public void setEnd(String end) {
            if (this.timestamp != null) {
                throw new IllegalArgumentException("Param [" + END.getPreferredName() + "] is incompatible with [" + TIMESTAMP.getPreferredName() + "].");
            }
            this.end = end;
        }

        public PageParams getPageParams() {
            return this.pageParams;
        }

        public void setPageParams(PageParams pageParams) {
            if (this.timestamp != null) {
                throw new IllegalArgumentException("Param [" + PageParams.FROM.getPreferredName() + ", " + PageParams.SIZE.getPreferredName() + "] is incompatible with [" + TIMESTAMP.getPreferredName() + "].");
            }
            this.pageParams = ExceptionsHelper.requireNonNull(pageParams, PageParams.PAGE.getPreferredName());
        }

        public Double getAnomalyScore() {
            return this.anomalyScore;
        }

        public void setAnomalyScore(double anomalyScore) {
            if (this.timestamp != null) {
                throw new IllegalArgumentException("Param [" + ANOMALY_SCORE.getPreferredName() + "] is incompatible with [" + TIMESTAMP.getPreferredName() + "].");
            }
            this.anomalyScore = anomalyScore;
        }

        public String getSort() {
            return this.sort;
        }

        public void setSort(String sort) {
            this.sort = sort;
        }

        public boolean isDescending() {
            return this.descending;
        }

        public void setDescending(boolean descending) {
            this.descending = descending;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.jobId);
            out.writeOptionalString(this.timestamp);
            out.writeBoolean(this.expand);
            out.writeBoolean(this.excludeInterim);
            out.writeOptionalString(this.start);
            out.writeOptionalString(this.end);
            out.writeOptionalDouble(this.anomalyScore);
            out.writeOptionalWriteable((Writeable)this.pageParams);
            out.writeString(this.sort);
            out.writeBoolean(this.descending);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Job.ID.getPreferredName(), this.jobId);
            if (this.timestamp != null) {
                builder.field(Result.TIMESTAMP.getPreferredName(), this.timestamp);
            }
            builder.field(EXPAND.getPreferredName(), this.expand);
            builder.field(EXCLUDE_INTERIM.getPreferredName(), this.excludeInterim);
            if (this.start != null) {
                builder.field(START.getPreferredName(), this.start);
            }
            if (this.end != null) {
                builder.field(END.getPreferredName(), this.end);
            }
            if (this.pageParams != null) {
                builder.field(PageParams.PAGE.getPreferredName(), (ToXContent)this.pageParams);
            }
            if (this.anomalyScore != null) {
                builder.field(ANOMALY_SCORE.getPreferredName(), this.anomalyScore);
            }
            builder.field(SORT.getPreferredName(), this.sort);
            builder.field(DESCENDING.getPreferredName(), this.descending);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.jobId, this.timestamp, this.expand, this.excludeInterim, this.anomalyScore, this.pageParams, this.start, this.end, this.sort, this.descending);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.jobId, other.jobId) && Objects.equals(this.timestamp, other.timestamp) && Objects.equals(this.expand, other.expand) && Objects.equals(this.excludeInterim, other.excludeInterim) && Objects.equals(this.anomalyScore, other.anomalyScore) && Objects.equals(this.pageParams, other.pageParams) && Objects.equals(this.start, other.start) && Objects.equals(this.end, other.end) && Objects.equals(this.sort, other.sort) && Objects.equals(this.descending, other.descending);
        }

        static {
            PARSER.declareString((request, jobId) -> {
                request.jobId = jobId;
            }, Job.ID);
            PARSER.declareString(Request::setTimestamp, Result.TIMESTAMP);
            PARSER.declareBoolean(Request::setExpand, EXPAND);
            PARSER.declareBoolean(Request::setExcludeInterim, EXCLUDE_INTERIM);
            PARSER.declareStringOrNull(Request::setStart, START);
            PARSER.declareStringOrNull(Request::setEnd, END);
            PARSER.declareObject(Request::setPageParams, PageParams.PARSER, PageParams.PAGE);
            PARSER.declareDouble(Request::setAnomalyScore, ANOMALY_SCORE);
            PARSER.declareString(Request::setSort, SORT);
            PARSER.declareBoolean(Request::setDescending, DESCENDING);
        }
    }
}

