/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.DiffableUtils;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicy;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicyMetadata;
import org.elasticsearch.xpack.core.ilm.OperationMode;

public class IndexLifecycleMetadata
implements Metadata.Custom {
    public static final String TYPE = "index_lifecycle";
    public static final ParseField OPERATION_MODE_FIELD = new ParseField("operation_mode", new String[0]);
    public static final ParseField POLICIES_FIELD = new ParseField("policies", new String[0]);
    public static final IndexLifecycleMetadata EMPTY = new IndexLifecycleMetadata(Collections.emptySortedMap(), OperationMode.RUNNING);
    public static final ConstructingObjectParser<IndexLifecycleMetadata, Void> PARSER = new ConstructingObjectParser("index_lifecycle", a -> new IndexLifecycleMetadata(((List)a[0]).stream().collect(Collectors.toMap(LifecyclePolicyMetadata::getName, Function.identity())), OperationMode.valueOf((String)a[1])));
    private final Map<String, LifecyclePolicyMetadata> policyMetadatas;
    private final OperationMode operationMode;
    private final Map<String, LifecyclePolicy> policies;

    private static Map<String, LifecyclePolicy> policiesMap(Map<String, LifecyclePolicyMetadata> policyMetadatas) {
        HashMap<String, LifecyclePolicy> policies = new HashMap<String, LifecyclePolicy>(policyMetadatas.size());
        for (LifecyclePolicyMetadata policyMetadata : policyMetadatas.values()) {
            LifecyclePolicy policy = policyMetadata.getPolicy();
            policies.put(policy.getName(), policy);
        }
        return Collections.unmodifiableMap(policies);
    }

    public IndexLifecycleMetadata(Map<String, LifecyclePolicyMetadata> policies, OperationMode operationMode) {
        this.policyMetadatas = Collections.unmodifiableMap(policies);
        this.operationMode = operationMode;
        this.policies = IndexLifecycleMetadata.policiesMap(this.policyMetadatas);
    }

    public IndexLifecycleMetadata(StreamInput in) throws IOException {
        int size = in.readVInt();
        TreeMap<String, LifecyclePolicyMetadata> policies = new TreeMap<String, LifecyclePolicyMetadata>();
        for (int i = 0; i < size; ++i) {
            policies.put(in.readString(), new LifecyclePolicyMetadata(in));
        }
        this.policyMetadatas = policies;
        this.operationMode = (OperationMode)in.readEnum(OperationMode.class);
        this.policies = IndexLifecycleMetadata.policiesMap(this.policyMetadatas);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.policyMetadatas, StreamOutput::writeWriteable);
        out.writeEnum((Enum)this.operationMode);
    }

    public Map<String, LifecyclePolicyMetadata> getPolicyMetadatas() {
        return this.policyMetadatas;
    }

    @Deprecated(since="8.7.0")
    public OperationMode getOperationMode() {
        return this.operationMode;
    }

    public Map<String, LifecyclePolicy> getPolicies() {
        return this.policies;
    }

    public Diff<Metadata.Custom> diff(Metadata.Custom previousState) {
        return new IndexLifecycleMetadataDiff((IndexLifecycleMetadata)previousState, this);
    }

    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params ignored) {
        return Iterators.concat((Iterator[])new Iterator[]{ChunkedToXContentHelper.xContentObjectFields((String)POLICIES_FIELD.getPreferredName(), this.policyMetadatas), Iterators.single((builder, params) -> builder.field(OPERATION_MODE_FIELD.getPreferredName(), (Enum)this.operationMode))});
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.minimumCompatible();
    }

    public String getWriteableName() {
        return TYPE;
    }

    public EnumSet<Metadata.XContentContext> context() {
        return Metadata.ALL_CONTEXTS;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.policyMetadatas, this.operationMode});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        IndexLifecycleMetadata other = (IndexLifecycleMetadata)obj;
        return Objects.equals(this.policyMetadatas, other.policyMetadatas) && Objects.equals((Object)this.operationMode, (Object)other.operationMode);
    }

    public String toString() {
        return Strings.toString((ChunkedToXContent)this, (boolean)false, (boolean)true);
    }

    static {
        PARSER.declareNamedObjects(ConstructingObjectParser.constructorArg(), (p, c, n) -> LifecyclePolicyMetadata.parse(p, n), v -> {
            throw new IllegalArgumentException("ordered " + POLICIES_FIELD.getPreferredName() + " are not supported");
        }, POLICIES_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), OPERATION_MODE_FIELD);
    }

    public static class IndexLifecycleMetadataDiff
    implements NamedDiff<Metadata.Custom> {
        final Diff<Map<String, LifecyclePolicyMetadata>> policies;
        final OperationMode operationMode;

        IndexLifecycleMetadataDiff(IndexLifecycleMetadata before, IndexLifecycleMetadata after) {
            this.policies = DiffableUtils.diff(before.policyMetadatas, after.policyMetadatas, (DiffableUtils.KeySerializer)DiffableUtils.getStringKeySerializer());
            this.operationMode = after.operationMode;
        }

        public IndexLifecycleMetadataDiff(StreamInput in) throws IOException {
            this.policies = DiffableUtils.readJdkMapDiff((StreamInput)in, (DiffableUtils.KeySerializer)DiffableUtils.getStringKeySerializer(), LifecyclePolicyMetadata::new, IndexLifecycleMetadataDiff::readLifecyclePolicyDiffFrom);
            this.operationMode = (OperationMode)in.readEnum(OperationMode.class);
        }

        public Metadata.Custom apply(Metadata.Custom part) {
            TreeMap<String, LifecyclePolicyMetadata> newPolicies = new TreeMap<String, LifecyclePolicyMetadata>((Map)this.policies.apply(((IndexLifecycleMetadata)part).policyMetadatas));
            return new IndexLifecycleMetadata(newPolicies, this.operationMode);
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.policies.writeTo(out);
            out.writeEnum((Enum)this.operationMode);
        }

        public String getWriteableName() {
            return IndexLifecycleMetadata.TYPE;
        }

        public TransportVersion getMinimalSupportedVersion() {
            return TransportVersion.minimumCompatible();
        }

        static Diff<LifecyclePolicyMetadata> readLifecyclePolicyDiffFrom(StreamInput in) throws IOException {
            return SimpleDiffable.readDiffFrom(LifecyclePolicyMetadata::new, (StreamInput)in);
        }
    }
}

