/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.nativeaccess;

import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.nativeaccess.CloseableByteBuffer;
import org.elasticsearch.nativeaccess.NativeAccess;
import org.elasticsearch.nativeaccess.Systemd;
import org.elasticsearch.nativeaccess.Zstd;
import org.elasticsearch.nativeaccess.lib.JavaLibrary;
import org.elasticsearch.nativeaccess.lib.NativeLibraryProvider;
import org.elasticsearch.nativeaccess.lib.ZstdLibrary;

abstract class AbstractNativeAccess
implements NativeAccess {
    protected static final Logger logger = LogManager.getLogger(NativeAccess.class);
    private final String name;
    private final JavaLibrary javaLib;
    private final Zstd zstd;
    protected boolean isMemoryLocked = false;
    protected NativeAccess.ExecSandboxState execSandboxState = NativeAccess.ExecSandboxState.NONE;

    protected AbstractNativeAccess(String name, NativeLibraryProvider libraryProvider) {
        this.name = name;
        this.javaLib = libraryProvider.getLibrary(JavaLibrary.class);
        this.zstd = new Zstd(libraryProvider.getLibrary(ZstdLibrary.class));
    }

    String getName() {
        return this.name;
    }

    @Override
    public Systemd systemd() {
        return null;
    }

    @Override
    public Zstd getZstd() {
        return this.zstd;
    }

    @Override
    public CloseableByteBuffer newSharedBuffer(int len) {
        assert (len > 0);
        return this.javaLib.newSharedBuffer(len);
    }

    @Override
    public CloseableByteBuffer newConfinedBuffer(int len) {
        assert (len > 0);
        return this.javaLib.newConfinedBuffer(len);
    }

    @Override
    public boolean isMemoryLocked() {
        return this.isMemoryLocked;
    }

    @Override
    public NativeAccess.ExecSandboxState getExecSandboxState() {
        return this.execSandboxState;
    }
}

