/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.slm.action;

import java.util.Optional;
import java.util.concurrent.Executor;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.slm.SnapshotLifecycleMetadata;
import org.elasticsearch.xpack.core.slm.SnapshotLifecyclePolicyMetadata;
import org.elasticsearch.xpack.core.slm.action.ExecuteSnapshotLifecycleAction;
import org.elasticsearch.xpack.slm.SnapshotLifecycleService;
import org.elasticsearch.xpack.slm.SnapshotLifecycleTask;
import org.elasticsearch.xpack.slm.history.SnapshotHistoryStore;

public class TransportExecuteSnapshotLifecycleAction
extends TransportMasterNodeAction<ExecuteSnapshotLifecycleAction.Request, ExecuteSnapshotLifecycleAction.Response> {
    private final Client client;
    private final SnapshotHistoryStore historyStore;

    @Inject
    public TransportExecuteSnapshotLifecycleAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, Client client, SnapshotHistoryStore historyStore) {
        super("cluster:admin/slm/execute", transportService, clusterService, threadPool, actionFilters, ExecuteSnapshotLifecycleAction.Request::new, ExecuteSnapshotLifecycleAction.Response::new, (Executor)threadPool.executor("generic"));
        this.client = client;
        this.historyStore = historyStore;
    }

    protected void masterOperation(Task task, ExecuteSnapshotLifecycleAction.Request request, ClusterState state, ActionListener<ExecuteSnapshotLifecycleAction.Response> listener) {
        try {
            String policyId = request.getLifecycleId();
            SnapshotLifecycleMetadata snapMeta = (SnapshotLifecycleMetadata)state.metadata().custom("snapshot_lifecycle", (Metadata.Custom)SnapshotLifecycleMetadata.EMPTY);
            SnapshotLifecyclePolicyMetadata policyMetadata = (SnapshotLifecyclePolicyMetadata)snapMeta.getSnapshotConfigurations().get(policyId);
            if (policyMetadata == null) {
                listener.onFailure((Exception)new IllegalArgumentException("no such snapshot lifecycle policy [" + policyId + "]"));
                return;
            }
            Optional<String> snapshotName = SnapshotLifecycleTask.maybeTakeSnapshot(SnapshotLifecycleService.getJobId(policyMetadata), this.client, this.clusterService, this.historyStore);
            if (snapshotName.isPresent()) {
                listener.onResponse((Object)new ExecuteSnapshotLifecycleAction.Response(snapshotName.get()));
            } else {
                listener.onFailure((Exception)new ElasticsearchException("failed to execute snapshot lifecycle policy [" + policyId + "]", new Object[0]));
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    protected ClusterBlockException checkBlock(ExecuteSnapshotLifecycleAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

