/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules;

import java.util.HashSet;
import org.elasticsearch.xpack.esql.common.Failure;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.NameId;
import org.elasticsearch.xpack.esql.plan.QueryPlan;
import org.elasticsearch.xpack.esql.plan.logical.BinaryPlan;
import org.elasticsearch.xpack.esql.plan.physical.BinaryExec;

public class PlanConsistencyChecker {
    public static void checkPlan(QueryPlan<?> p, Failures failures) {
        if (p instanceof BinaryPlan) {
            BinaryPlan binaryPlan = (BinaryPlan)p;
            PlanConsistencyChecker.checkMissingBinary(p, binaryPlan.leftReferences(), binaryPlan.left().outputSet(), binaryPlan.rightReferences(), binaryPlan.right().outputSet(), failures);
        } else if (p instanceof BinaryExec) {
            BinaryExec binaryExec = (BinaryExec)p;
            PlanConsistencyChecker.checkMissingBinary(p, binaryExec.leftReferences(), binaryExec.left().outputSet(), binaryExec.rightReferences(), binaryExec.right().outputSet(), failures);
        } else {
            PlanConsistencyChecker.checkMissing(p, p.references(), p.inputSet(), "missing references", failures);
        }
        HashSet<String> outputAttributeNames = new HashSet<String>();
        HashSet<NameId> outputAttributeIds = new HashSet<NameId>();
        for (Attribute outputAttr : p.output()) {
            if (outputAttributeNames.add(outputAttr.name()) && outputAttributeIds.add(outputAttr.id())) continue;
            failures.add(Failure.fail(p, "Plan [{}] optimized incorrectly due to duplicate output attribute {}", p.nodeString(), outputAttr.toString()));
        }
    }

    private static void checkMissingBinary(QueryPlan<?> plan, AttributeSet leftReferences, AttributeSet leftInput, AttributeSet rightReferences, AttributeSet rightInput, Failures failures) {
        PlanConsistencyChecker.checkMissing(plan, leftReferences, leftInput, "missing references from left hand side", failures);
        PlanConsistencyChecker.checkMissing(plan, rightReferences, rightInput, "missing references from right hand side", failures);
    }

    private static void checkMissing(QueryPlan<?> plan, AttributeSet references, AttributeSet input, String detailErrorMessage, Failures failures) {
        AttributeSet missing = references.subtract(input);
        if (!missing.isEmpty()) {
            failures.add(Failure.fail(plan, "Plan [{}] optimized incorrectly due to {} {}", plan.nodeString(), detailErrorMessage, missing));
        }
    }
}

