/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.action;

import java.io.IOException;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.esql.action.ColumnInfoImpl;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.NumericUtils;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;

abstract class PositionToXContent {
    protected final Block block;

    PositionToXContent(Block block) {
        this.block = block;
    }

    public XContentBuilder positionToXContent(XContentBuilder builder, ToXContent.Params params, int position) throws IOException {
        if (this.block.isNull(position)) {
            return builder.nullValue();
        }
        int count = this.block.getValueCount(position);
        int start = this.block.getFirstValueIndex(position);
        if (count == 1) {
            return this.valueToXContent(builder, params, start);
        }
        builder.startArray();
        int end = start + count;
        for (int i = start; i < end; ++i) {
            this.valueToXContent(builder, params, i);
        }
        return builder.endArray();
    }

    protected abstract XContentBuilder valueToXContent(XContentBuilder var1, ToXContent.Params var2, int var3) throws IOException;

    public static PositionToXContent positionToXContent(ColumnInfoImpl columnInfo, Block block, final BytesRef scratch) {
        return switch (columnInfo.type()) {
            default -> throw new MatchException(null, null);
            case DataType.LONG, DataType.COUNTER_LONG -> new PositionToXContent(block){

                @Override
                protected XContentBuilder valueToXContent(XContentBuilder builder, ToXContent.Params params, int valueIndex) throws IOException {
                    return builder.value(((LongBlock)this.block).getLong(valueIndex));
                }
            };
            case DataType.INTEGER, DataType.COUNTER_INTEGER -> new PositionToXContent(block){

                @Override
                protected XContentBuilder valueToXContent(XContentBuilder builder, ToXContent.Params params, int valueIndex) throws IOException {
                    return builder.value(((IntBlock)this.block).getInt(valueIndex));
                }
            };
            case DataType.DOUBLE, DataType.COUNTER_DOUBLE -> new PositionToXContent(block){

                @Override
                protected XContentBuilder valueToXContent(XContentBuilder builder, ToXContent.Params params, int valueIndex) throws IOException {
                    return builder.value(((DoubleBlock)this.block).getDouble(valueIndex));
                }
            };
            case DataType.UNSIGNED_LONG -> new PositionToXContent(block){

                @Override
                protected XContentBuilder valueToXContent(XContentBuilder builder, ToXContent.Params params, int valueIndex) throws IOException {
                    long l = ((LongBlock)this.block).getLong(valueIndex);
                    return builder.value((Object)NumericUtils.unsignedLongAsNumber((long)l));
                }
            };
            case DataType.KEYWORD, DataType.SEMANTIC_TEXT, DataType.TEXT -> new PositionToXContent(block){

                @Override
                protected XContentBuilder valueToXContent(XContentBuilder builder, ToXContent.Params params, int valueIndex) throws IOException {
                    BytesRef val = ((BytesRefBlock)this.block).getBytesRef(valueIndex, scratch);
                    if (builder.contentType() == XContentType.CBOR && val.offset != 0) {
                        val = BytesRef.deepCopyOf((BytesRef)scratch);
                    }
                    return builder.utf8Value(val.bytes, val.offset, val.length);
                }
            };
            case DataType.IP -> new PositionToXContent(block){

                @Override
                protected XContentBuilder valueToXContent(XContentBuilder builder, ToXContent.Params params, int valueIndex) throws IOException {
                    BytesRef val = ((BytesRefBlock)this.block).getBytesRef(valueIndex, scratch);
                    return builder.value(EsqlDataTypeConverter.ipToString(val));
                }
            };
            case DataType.DATETIME -> new PositionToXContent(block){

                @Override
                protected XContentBuilder valueToXContent(XContentBuilder builder, ToXContent.Params params, int valueIndex) throws IOException {
                    long longVal = ((LongBlock)this.block).getLong(valueIndex);
                    return builder.value(EsqlDataTypeConverter.dateTimeToString(longVal));
                }
            };
            case DataType.DATE_NANOS -> new PositionToXContent(block){

                @Override
                protected XContentBuilder valueToXContent(XContentBuilder builder, ToXContent.Params params, int valueIndex) throws IOException {
                    long longVal = ((LongBlock)this.block).getLong(valueIndex);
                    return builder.value(EsqlDataTypeConverter.nanoTimeToString(longVal));
                }
            };
            case DataType.GEO_POINT, DataType.GEO_SHAPE, DataType.CARTESIAN_POINT, DataType.CARTESIAN_SHAPE -> new PositionToXContent(block){

                @Override
                protected XContentBuilder valueToXContent(XContentBuilder builder, ToXContent.Params params, int valueIndex) throws IOException {
                    return builder.value(EsqlDataTypeConverter.spatialToString(((BytesRefBlock)this.block).getBytesRef(valueIndex, scratch)));
                }
            };
            case DataType.BOOLEAN -> new PositionToXContent(block){

                @Override
                protected XContentBuilder valueToXContent(XContentBuilder builder, ToXContent.Params params, int valueIndex) throws IOException {
                    return builder.value(((BooleanBlock)this.block).getBoolean(valueIndex));
                }
            };
            case DataType.VERSION -> new PositionToXContent(block){

                @Override
                protected XContentBuilder valueToXContent(XContentBuilder builder, ToXContent.Params params, int valueIndex) throws IOException {
                    BytesRef val = ((BytesRefBlock)this.block).getBytesRef(valueIndex, scratch);
                    return builder.value(EsqlDataTypeConverter.versionToString(val));
                }
            };
            case DataType.NULL, DataType.AGGREGATE_METRIC_DOUBLE -> new PositionToXContent(block){

                @Override
                protected XContentBuilder valueToXContent(XContentBuilder builder, ToXContent.Params params, int valueIndex) throws IOException {
                    return builder.nullValue();
                }
            };
            case DataType.UNSUPPORTED -> new PositionToXContent(block){

                @Override
                protected XContentBuilder valueToXContent(XContentBuilder builder, ToXContent.Params params, int valueIndex) throws IOException {
                    return builder.value((String)null);
                }
            };
            case DataType.SOURCE -> new PositionToXContent(block){

                @Override
                protected XContentBuilder valueToXContent(XContentBuilder builder, ToXContent.Params params, int valueIndex) throws IOException {
                    BytesRef val = ((BytesRefBlock)this.block).getBytesRef(valueIndex, scratch);
                    try (XContentParser parser = XContentHelper.createParser((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)new BytesArray(val));){
                        parser.nextToken();
                        XContentBuilder xContentBuilder = builder.copyCurrentStructure(parser);
                        return xContentBuilder;
                    }
                }
            };
            case DataType.DATE_PERIOD, DataType.TIME_DURATION, DataType.DOC_DATA_TYPE, DataType.TSID_DATA_TYPE, DataType.SHORT, DataType.BYTE, DataType.OBJECT, DataType.FLOAT, DataType.HALF_FLOAT, DataType.SCALED_FLOAT, DataType.PARTIAL_AGG -> throw new IllegalArgumentException("can't convert values of type [" + String.valueOf(columnInfo.type()) + "]");
        };
    }
}

