/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.entitlement.runtime.policy;

import java.lang.invoke.LambdaMetafactory;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.entitlement.bridge.Util;
import org.elasticsearch.entitlement.runtime.policy.FileAccessTree;
import org.elasticsearch.entitlement.runtime.policy.PathLookup;
import org.elasticsearch.entitlement.runtime.policy.Policy;
import org.elasticsearch.entitlement.runtime.policy.Scope;
import org.elasticsearch.entitlement.runtime.policy.entitlements.Entitlement;
import org.elasticsearch.entitlement.runtime.policy.entitlements.FilesEntitlement;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;

public class PolicyManager {
    public static final String ALL_UNNAMED = "ALL-UNNAMED";
    static final Logger generalLogger = LogManager.getLogger(PolicyManager.class);
    public static final Set<String> MODULES_EXCLUDED_FROM_SYSTEM_MODULES = Set.of("java.desktop", "java.xml");
    final Map<Module, ModuleEntitlements> moduleEntitlementsMap = new ConcurrentHashMap<Module, ModuleEntitlements>();
    private final Map<String, List<Entitlement>> serverEntitlements;
    private final List<Entitlement> apmAgentEntitlements;
    private final Map<String, Map<String, List<Entitlement>>> pluginsEntitlements;
    private final Function<Class<?>, PolicyScope> scopeResolver;
    private final PathLookup pathLookup;
    private static final Set<Module> SYSTEM_LAYER_MODULES = PolicyManager.findSystemLayerModules();
    public static final Set<Module> SERVER_LAYER_MODULES = ModuleLayer.boot().modules().stream().filter(m -> !SYSTEM_LAYER_MODULES.contains(m)).collect(Collectors.toUnmodifiableSet());
    private final Map<String, Path> sourcePaths;
    private final List<FileAccessTree.ExclusivePath> exclusivePaths;
    private static final ConcurrentHashMap<String, Logger> MODULE_LOGGERS = new ConcurrentHashMap();

    private FileAccessTree getDefaultFileAccess(Path componentPath) {
        return FileAccessTree.withoutExclusivePaths(FilesEntitlement.EMPTY, this.pathLookup, componentPath);
    }

    ModuleEntitlements defaultEntitlements(String componentName, Path componentPath, String moduleName) {
        return new ModuleEntitlements(componentName, Map.of(), this.getDefaultFileAccess(componentPath), PolicyManager.getLogger(componentName, moduleName));
    }

    ModuleEntitlements policyEntitlements(String componentName, Path componentPath, String moduleName, List<Entitlement> entitlements) {
        FilesEntitlement filesEntitlement = FilesEntitlement.EMPTY;
        for (Entitlement entitlement : entitlements) {
            if (!(entitlement instanceof FilesEntitlement)) continue;
            filesEntitlement = (FilesEntitlement)entitlement;
        }
        return new ModuleEntitlements(componentName, entitlements.stream().collect(Collectors.groupingBy((Function<Entitlement, Class>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getClass(), (Lorg/elasticsearch/entitlement/runtime/policy/entitlements/Entitlement;)Ljava/lang/Class;)())), FileAccessTree.of(componentName, moduleName, filesEntitlement, this.pathLookup, componentPath, this.exclusivePaths), PolicyManager.getLogger(componentName, moduleName));
    }

    private static Set<Module> findSystemLayerModules() {
        Set systemModulesDescriptors = ModuleFinder.ofSystem().findAll().stream().map(ModuleReference::descriptor).collect(Collectors.toUnmodifiableSet());
        return Stream.concat(Stream.of(PolicyManager.class.getModule()), ModuleLayer.boot().modules().stream().filter(m -> systemModulesDescriptors.contains(m.getDescriptor()) && !MODULES_EXCLUDED_FROM_SYSTEM_MODULES.contains(m.getName()))).collect(Collectors.toUnmodifiableSet());
    }

    public PolicyManager(Policy serverPolicy, List<Entitlement> apmAgentEntitlements, Map<String, Policy> pluginPolicies, Function<Class<?>, PolicyScope> scopeResolver, Map<String, Path> sourcePaths, PathLookup pathLookup) {
        this.serverEntitlements = PolicyManager.buildScopeEntitlementsMap(Objects.requireNonNull(serverPolicy));
        this.apmAgentEntitlements = apmAgentEntitlements;
        this.pluginsEntitlements = Objects.requireNonNull(pluginPolicies).entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, e -> PolicyManager.buildScopeEntitlementsMap((Policy)e.getValue())));
        this.scopeResolver = scopeResolver;
        this.sourcePaths = sourcePaths;
        this.pathLookup = Objects.requireNonNull(pathLookup);
        ArrayList<FileAccessTree.ExclusiveFileEntitlement> exclusiveFileEntitlements = new ArrayList<FileAccessTree.ExclusiveFileEntitlement>();
        for (Map.Entry<String, List<Entitlement>> entry : this.serverEntitlements.entrySet()) {
            PolicyManager.validateEntitlementsPerModule(ComponentKind.SERVER.componentName, entry.getKey(), entry.getValue(), exclusiveFileEntitlements);
        }
        PolicyManager.validateEntitlementsPerModule(ComponentKind.APM_AGENT.componentName, ALL_UNNAMED, apmAgentEntitlements, exclusiveFileEntitlements);
        for (Map.Entry<String, Object> entry : this.pluginsEntitlements.entrySet()) {
            for (Map.Entry m : ((Map)entry.getValue()).entrySet()) {
                PolicyManager.validateEntitlementsPerModule(entry.getKey(), (String)m.getKey(), (List)m.getValue(), exclusiveFileEntitlements);
            }
        }
        List<FileAccessTree.ExclusivePath> exclusivePaths = FileAccessTree.buildExclusivePathList(exclusiveFileEntitlements, pathLookup, FileAccessTree.DEFAULT_COMPARISON);
        FileAccessTree.validateExclusivePaths(exclusivePaths, FileAccessTree.DEFAULT_COMPARISON);
        this.exclusivePaths = exclusivePaths;
    }

    private static Map<String, List<Entitlement>> buildScopeEntitlementsMap(Policy policy) {
        return policy.scopes().stream().collect(Collectors.toUnmodifiableMap(Scope::moduleName, Scope::entitlements));
    }

    private static void validateEntitlementsPerModule(String componentName, String moduleName, List<Entitlement> entitlements, List<FileAccessTree.ExclusiveFileEntitlement> exclusiveFileEntitlements) {
        HashSet found = new HashSet();
        for (Entitlement e : entitlements) {
            if (found.contains(e.getClass())) {
                throw new IllegalArgumentException("[" + componentName + "] using module [" + moduleName + "] found duplicate entitlement [" + e.getClass().getName() + "]");
            }
            found.add(e.getClass());
            if (!(e instanceof FilesEntitlement)) continue;
            FilesEntitlement fe = (FilesEntitlement)e;
            exclusiveFileEntitlements.add(new FileAccessTree.ExclusiveFileEntitlement(componentName, moduleName, fe));
        }
    }

    private static Logger getLogger(String componentName, String moduleName) {
        String loggerSuffix = "." + componentName + "." + (moduleName == null ? ALL_UNNAMED : moduleName);
        return MODULE_LOGGERS.computeIfAbsent(PolicyManager.class.getName() + loggerSuffix, LogManager::getLogger);
    }

    ModuleEntitlements getEntitlements(Class<?> requestingClass) {
        return this.moduleEntitlementsMap.computeIfAbsent(requestingClass.getModule(), m -> this.computeEntitlements(requestingClass));
    }

    private ModuleEntitlements computeEntitlements(Class<?> requestingClass) {
        PolicyScope policyScope = this.scopeResolver.apply(requestingClass);
        String componentName = policyScope.componentName();
        String moduleName = policyScope.moduleName();
        switch (policyScope.kind().ordinal()) {
            case 1: {
                return this.getModuleScopeEntitlements(this.serverEntitlements, moduleName, ComponentKind.SERVER.componentName, PolicyManager.getComponentPathFromClass(requestingClass));
            }
            case 2: {
                return this.policyEntitlements(ComponentKind.APM_AGENT.componentName, PolicyManager.getComponentPathFromClass(requestingClass), ALL_UNNAMED, this.apmAgentEntitlements);
            }
            case 0: {
                return this.defaultEntitlements(ComponentKind.UNKNOWN.componentName, null, moduleName);
            }
        }
        assert (policyScope.kind() == ComponentKind.PLUGIN);
        Map<String, List<Entitlement>> pluginEntitlements = this.pluginsEntitlements.get(componentName);
        if (pluginEntitlements == null) {
            return this.defaultEntitlements(componentName, this.sourcePaths.get(componentName), moduleName);
        }
        return this.getModuleScopeEntitlements(pluginEntitlements, moduleName, componentName, this.sourcePaths.get(componentName));
    }

    static Path getComponentPathFromClass(Class<?> requestingClass) {
        CodeSource codeSource = requestingClass.getProtectionDomain().getCodeSource();
        if (codeSource == null) {
            return null;
        }
        try {
            return Paths.get(codeSource.getLocation().toURI());
        }
        catch (Exception e) {
            generalLogger.info("Cannot get component path for [{}]: [{}] cannot be converted to a valid Path", new Object[]{requestingClass.getName(), codeSource.getLocation().toString()});
            return null;
        }
    }

    private ModuleEntitlements getModuleScopeEntitlements(Map<String, List<Entitlement>> scopeEntitlements, String scopeName, String componentName, Path componentPath) {
        List<Entitlement> entitlements = scopeEntitlements.get(scopeName);
        if (entitlements == null) {
            return this.defaultEntitlements(componentName, componentPath, scopeName);
        }
        return this.policyEntitlements(componentName, componentPath, scopeName, entitlements);
    }

    boolean isTriviallyAllowed(Class<?> requestingClass) {
        if (generalLogger.isTraceEnabled()) {
            generalLogger.trace("Stack trace for upcoming trivially-allowed check", (Throwable)new Exception());
        }
        if (requestingClass == null) {
            generalLogger.debug("Entitlement trivially allowed: no caller frames outside the entitlement library");
            return true;
        }
        if (requestingClass == Util.NO_CLASS) {
            generalLogger.debug("Entitlement trivially allowed from outermost frame");
            return true;
        }
        if (SYSTEM_LAYER_MODULES.contains(requestingClass.getModule())) {
            generalLogger.debug("Entitlement trivially allowed from system module [{}]", new Object[]{requestingClass.getModule().getName()});
            return true;
        }
        generalLogger.trace("Entitlement not trivially allowed");
        return false;
    }

    public String toString() {
        return "PolicyManager{serverEntitlements=" + String.valueOf(this.serverEntitlements) + ", pluginsEntitlements=" + String.valueOf(this.pluginsEntitlements) + "}";
    }

    record ModuleEntitlements(String componentName, Map<Class<? extends Entitlement>, List<Entitlement>> entitlementsByType, FileAccessTree fileAccess, Logger logger) {
        public ModuleEntitlements {
            entitlementsByType = Map.copyOf(entitlementsByType);
        }

        public boolean hasEntitlement(Class<? extends Entitlement> entitlementClass) {
            return this.entitlementsByType.containsKey(entitlementClass);
        }

        public <E extends Entitlement> Stream<E> getEntitlements(Class<E> entitlementClass) {
            List<Entitlement> entitlements = this.entitlementsByType.get(entitlementClass);
            if (entitlements == null) {
                return Stream.empty();
            }
            return entitlements.stream().map(entitlementClass::cast);
        }
    }

    public static enum ComponentKind {
        UNKNOWN("(unknown)"),
        SERVER("(server)"),
        APM_AGENT("(APM agent)"),
        PLUGIN(null);

        public final String componentName;

        private ComponentKind(String componentName) {
            this.componentName = componentName;
        }
    }

    public record PolicyScope(ComponentKind kind, String componentName, String moduleName) {
        public PolicyScope {
            Objects.requireNonNull(kind);
            Objects.requireNonNull(componentName);
            Objects.requireNonNull(moduleName);
            assert (kind.componentName == null || kind.componentName.equals(componentName));
        }

        public static PolicyScope unknown(String moduleName) {
            return new PolicyScope(ComponentKind.UNKNOWN, ComponentKind.UNKNOWN.componentName, moduleName);
        }

        public static PolicyScope server(String moduleName) {
            return new PolicyScope(ComponentKind.SERVER, ComponentKind.SERVER.componentName, moduleName);
        }

        public static PolicyScope apmAgent(String moduleName) {
            return new PolicyScope(ComponentKind.APM_AGENT, ComponentKind.APM_AGENT.componentName, moduleName);
        }

        public static PolicyScope plugin(String componentName, String moduleName) {
            return new PolicyScope(ComponentKind.PLUGIN, componentName, moduleName);
        }
    }
}

