/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.entitlement.initialization;

import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.nio.channels.spi.SelectorProvider;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystems;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.elasticsearch.core.internal.provider.ProviderLocator;
import org.elasticsearch.entitlement.bridge.EntitlementChecker;
import org.elasticsearch.entitlement.instrumentation.CheckMethod;
import org.elasticsearch.entitlement.instrumentation.InstrumentationService;
import org.elasticsearch.entitlement.instrumentation.Instrumenter;
import org.elasticsearch.entitlement.instrumentation.MethodKey;
import org.elasticsearch.entitlement.instrumentation.Transformer;

class DynamicInstrumentation {
    private static final InstrumentationService INSTRUMENTATION_SERVICE = (InstrumentationService)new ProviderLocator("entitlement", InstrumentationService.class, "org.elasticsearch.entitlement.instrumentation", Set.of()).get();

    DynamicInstrumentation() {
    }

    static void initialize(Instrumentation inst, Class<?> checkerInterface, boolean verifyBytecode) throws ClassNotFoundException, NoSuchMethodException, UnmodifiableClassException {
        Map<MethodKey, CheckMethod> checkMethods = DynamicInstrumentation.getMethodsToInstrument(checkerInterface);
        Set<String> classesToTransform = checkMethods.keySet().stream().map(MethodKey::className).collect(Collectors.toSet());
        Instrumenter instrumenter = INSTRUMENTATION_SERVICE.newInstrumenter(checkerInterface, checkMethods);
        Transformer transformer = new Transformer(instrumenter, classesToTransform, verifyBytecode);
        inst.addTransformer(transformer, true);
        Class<?>[] classesToRetransform = DynamicInstrumentation.findClassesToRetransform(inst.getAllLoadedClasses(), classesToTransform);
        try {
            inst.retransformClasses(classesToRetransform);
        }
        catch (VerifyError e) {
            transformer.enableClassVerification();
            for (Class<?> classToRetransform : classesToRetransform) {
                inst.retransformClasses(classToRetransform);
            }
            throw e;
        }
    }

    private static Map<MethodKey, CheckMethod> getMethodsToInstrument(Class<?> checkerInterface) throws ClassNotFoundException, NoSuchMethodException {
        HashMap<MethodKey, CheckMethod> checkMethods = new HashMap<MethodKey, CheckMethod>(INSTRUMENTATION_SERVICE.lookupMethods(checkerInterface));
        Stream.of(DynamicInstrumentation.fileSystemProviderChecks(), DynamicInstrumentation.fileStoreChecks(), DynamicInstrumentation.pathChecks(), Stream.of(INSTRUMENTATION_SERVICE.lookupImplementationMethod(SelectorProvider.class, "inheritedChannel", SelectorProvider.provider().getClass(), EntitlementChecker.class, "checkSelectorProviderInheritedChannel", new Class[0]))).flatMap(Function.identity()).forEach(instrumentation -> checkMethods.put(instrumentation.targetMethod(), instrumentation.checkMethod()));
        return checkMethods;
    }

    private static Stream<InstrumentationService.InstrumentationInfo> fileSystemProviderChecks() throws ClassNotFoundException, NoSuchMethodException {
        final Class<?> fileSystemProviderClass = FileSystems.getDefault().provider().getClass();
        var instrumentation = new InstrumentationInfoFactory(){

            @Override
            public InstrumentationService.InstrumentationInfo of(String methodName, Class<?> ... parameterTypes) throws ClassNotFoundException, NoSuchMethodException {
                return INSTRUMENTATION_SERVICE.lookupImplementationMethod(FileSystemProvider.class, methodName, fileSystemProviderClass, EntitlementChecker.class, "check" + Character.toUpperCase(methodName.charAt(0)) + methodName.substring(1), parameterTypes);
            }
        };
        return Stream.of(instrumentation.of("newFileSystem", URI.class, Map.class), instrumentation.of("newFileSystem", Path.class, Map.class), instrumentation.of("newInputStream", Path.class, OpenOption[].class), instrumentation.of("newOutputStream", Path.class, OpenOption[].class), instrumentation.of("newFileChannel", Path.class, Set.class, FileAttribute[].class), instrumentation.of("newAsynchronousFileChannel", Path.class, Set.class, ExecutorService.class, FileAttribute[].class), instrumentation.of("newByteChannel", Path.class, Set.class, FileAttribute[].class), instrumentation.of("newDirectoryStream", Path.class, DirectoryStream.Filter.class), instrumentation.of("createDirectory", Path.class, FileAttribute[].class), instrumentation.of("createSymbolicLink", Path.class, Path.class, FileAttribute[].class), instrumentation.of("createLink", Path.class, Path.class), instrumentation.of("delete", Path.class), instrumentation.of("deleteIfExists", Path.class), instrumentation.of("readSymbolicLink", Path.class), instrumentation.of("copy", Path.class, Path.class, CopyOption[].class), instrumentation.of("move", Path.class, Path.class, CopyOption[].class), instrumentation.of("isSameFile", Path.class, Path.class), instrumentation.of("isHidden", Path.class), instrumentation.of("getFileStore", Path.class), instrumentation.of("checkAccess", Path.class, AccessMode[].class), instrumentation.of("getFileAttributeView", Path.class, Class.class, LinkOption[].class), instrumentation.of("readAttributes", Path.class, Class.class, LinkOption[].class), instrumentation.of("readAttributes", Path.class, String.class, LinkOption[].class), instrumentation.of("readAttributesIfExists", Path.class, Class.class, LinkOption[].class), instrumentation.of("setAttribute", Path.class, String.class, Object.class, LinkOption[].class), instrumentation.of("exists", Path.class, LinkOption[].class));
    }

    private static Stream<InstrumentationService.InstrumentationInfo> fileStoreChecks() {
        Stream<Class> fileStoreClasses = StreamSupport.stream(FileSystems.getDefault().getFileStores().spliterator(), false).map(Object::getClass).distinct();
        return fileStoreClasses.flatMap(fileStoreClass -> {
            var instrumentation = new InstrumentationInfoFactory((Class)fileStoreClass){
                final /* synthetic */ Class val$fileStoreClass;
                {
                    this.val$fileStoreClass = clazz;
                }

                @Override
                public InstrumentationService.InstrumentationInfo of(String methodName, Class<?> ... parameterTypes) throws ClassNotFoundException, NoSuchMethodException {
                    return INSTRUMENTATION_SERVICE.lookupImplementationMethod(FileStore.class, methodName, this.val$fileStoreClass, EntitlementChecker.class, "check" + Character.toUpperCase(methodName.charAt(0)) + methodName.substring(1), parameterTypes);
                }
            };
            try {
                return Stream.of(instrumentation.of("getFileStoreAttributeView", Class.class), instrumentation.of("getAttribute", String.class), instrumentation.of("getBlockSize", new Class[0]), instrumentation.of("getTotalSpace", new Class[0]), instrumentation.of("getUnallocatedSpace", new Class[0]), instrumentation.of("getUsableSpace", new Class[0]), instrumentation.of("isReadOnly", new Class[0]), instrumentation.of("name", new Class[0]), instrumentation.of("type", new Class[0]));
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static Stream<InstrumentationService.InstrumentationInfo> pathChecks() {
        Stream<Class> pathClasses = StreamSupport.stream(FileSystems.getDefault().getRootDirectories().spliterator(), false).map((Function<Path, Class>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getClass(), (Ljava/nio/file/Path;)Ljava/lang/Class;)()).distinct();
        return pathClasses.flatMap(pathClass -> {
            InstrumentationInfoFactory instrumentation = (methodName, parameterTypes) -> INSTRUMENTATION_SERVICE.lookupImplementationMethod(Path.class, methodName, (Class<?>)pathClass, EntitlementChecker.class, "checkPath" + Character.toUpperCase(methodName.charAt(0)) + methodName.substring(1), parameterTypes);
            try {
                return Stream.of(instrumentation.of("toRealPath", LinkOption[].class), instrumentation.of("register", WatchService.class, WatchEvent.Kind[].class), instrumentation.of("register", WatchService.class, WatchEvent.Kind[].class, WatchEvent.Modifier[].class));
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static Class<?>[] findClassesToRetransform(Class<?>[] loadedClasses, Set<String> classesToTransform) {
        ArrayList retransform = new ArrayList();
        for (Class<?> loadedClass : loadedClasses) {
            if (!classesToTransform.contains(loadedClass.getName().replace(".", "/"))) continue;
            retransform.add(loadedClass);
        }
        return retransform.toArray(new Class[0]);
    }

    static interface InstrumentationInfoFactory {
        public InstrumentationService.InstrumentationInfo of(String var1, Class<?> ... var2) throws ClassNotFoundException, NoSuchMethodException;
    }
}

