/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.logstash.rest;

import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestActionListener;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.logstash.Pipeline;
import org.elasticsearch.xpack.logstash.action.PutPipelineAction;
import org.elasticsearch.xpack.logstash.action.PutPipelineRequest;
import org.elasticsearch.xpack.logstash.action.PutPipelineResponse;

@ServerlessScope(value=Scope.PUBLIC)
public class RestPutPipelineAction
extends BaseRestHandler {
    private static final Pattern PIPELINE_ID_PATTERN = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_-]*");

    public String getName() {
        return "logstash_put_pipeline";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.PUT, "/_logstash/pipeline/{id}"));
    }

    private static void validatePipelineId(String id) {
        if (Strings.isEmpty((CharSequence)id)) {
            throw new IllegalArgumentException("Pipeline ID cannot be null or empty");
        }
        if (!PIPELINE_ID_PATTERN.matcher(id).matches()) {
            throw new IllegalArgumentException("Invalid pipeline [" + id + "] ID received. Pipeline ID must begin with a letter or underscore and can contain only letters, underscores, dashes, hyphens, and numbers");
        }
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String id = request.param("id");
        RestPutPipelineAction.validatePipelineId(id);
        try (XContentParser parser = request.contentParser();){
            Pipeline.PARSER.apply(parser, (Object)id);
        }
        return restChannel -> {
            String content = request.content().utf8ToString();
            client.execute((ActionType)PutPipelineAction.INSTANCE, (ActionRequest)new PutPipelineRequest(id, content, request.getXContentType()), (ActionListener)new RestActionListener<PutPipelineResponse>(this, restChannel){

                protected void processResponse(PutPipelineResponse putPipelineResponse) throws Exception {
                    this.channel.sendResponse(new RestResponse(putPipelineResponse.status(), XContentType.JSON.mediaType(), (BytesReference)BytesArray.EMPTY));
                }
            });
        };
    }
}

