/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.valid;

import java.util.Iterator;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geomgraph.GeometryGraph;
import org.locationtech.jts.geomgraph.index.SegmentIntersector;
import org.locationtech.jts.operation.relate.EdgeEndBundle;
import org.locationtech.jts.operation.relate.RelateNode;
import org.locationtech.jts.operation.relate.RelateNodeGraph;

public class ConsistentAreaTester {
    private final LineIntersector li = new RobustLineIntersector();
    private GeometryGraph geomGraph;
    private RelateNodeGraph nodeGraph = new RelateNodeGraph();
    private Coordinate invalidPoint;

    public ConsistentAreaTester(GeometryGraph geomGraph) {
        this.geomGraph = geomGraph;
    }

    public Coordinate getInvalidPoint() {
        return this.invalidPoint;
    }

    public boolean isNodeConsistentArea() {
        SegmentIntersector intersector = this.geomGraph.computeSelfNodes(this.li, true, true);
        if (intersector.hasProperIntersection()) {
            this.invalidPoint = intersector.getProperIntersectionPoint();
            return false;
        }
        this.nodeGraph.build(this.geomGraph);
        return this.isNodeEdgeAreaLabelsConsistent();
    }

    private boolean isNodeEdgeAreaLabelsConsistent() {
        Iterator nodeIt = this.nodeGraph.getNodeIterator();
        while (nodeIt.hasNext()) {
            RelateNode node = (RelateNode)nodeIt.next();
            if (node.getEdges().isAreaLabelsConsistent(this.geomGraph)) continue;
            this.invalidPoint = node.getCoordinate().copy();
            return false;
        }
        return true;
    }

    public boolean hasDuplicateRings() {
        Iterator nodeIt = this.nodeGraph.getNodeIterator();
        while (nodeIt.hasNext()) {
            RelateNode node = (RelateNode)nodeIt.next();
            Iterator i = node.getEdges().iterator();
            while (i.hasNext()) {
                EdgeEndBundle eeb = (EdgeEndBundle)i.next();
                if (eeb.getEdgeEnds().size() <= 1) continue;
                this.invalidPoint = eeb.getEdge().getCoordinate(0);
                return true;
            }
        }
        return false;
    }
}

