/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression.predicate.regex;

import java.io.IOException;
import java.util.Objects;
import java.util.regex.Pattern;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;

public class RegexProcessor
implements Processor {
    public static final String NAME = "rgx";
    private Pattern pattern;

    public RegexProcessor(String pattern) {
        this.pattern = pattern != null ? Pattern.compile(pattern) : null;
    }

    public String getWriteableName() {
        return NAME;
    }

    public RegexProcessor(StreamInput in) throws IOException {
        this(in.readOptionalString());
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.pattern != null ? this.pattern.toString() : null);
    }

    @Override
    public Object process(Object input) {
        return RegexOperation.match(input, this.pattern);
    }

    public int hashCode() {
        return Objects.hash(this.pattern);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RegexProcessor other = (RegexProcessor)obj;
        return Objects.equals(this.pattern, other.pattern);
    }

    public static class RegexOperation {
        public static Boolean match(Object value, Pattern pattern) {
            if (pattern == null) {
                return Boolean.TRUE;
            }
            if (value == null) {
                return null;
            }
            return pattern.matcher(value.toString()).matches();
        }

        public static Boolean match(Object value, String pattern) {
            return RegexOperation.match(value, pattern, Boolean.FALSE);
        }

        public static Boolean match(Object value, String pattern, Boolean caseInsensitive) {
            if (pattern == null) {
                return Boolean.TRUE;
            }
            if (value == null) {
                return null;
            }
            int flags = 0;
            if (Boolean.TRUE.equals(caseInsensitive)) {
                flags |= 2;
            }
            return Pattern.compile(pattern, flags).matcher(value.toString()).matches();
        }
    }
}

