/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression.function;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.xpack.ql.ParsingException;
import org.elasticsearch.xpack.ql.QlIllegalArgumentException;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.function.Function;
import org.elasticsearch.xpack.ql.expression.function.FunctionDefinition;
import org.elasticsearch.xpack.ql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.ql.expression.function.TwoOptionalArguments;
import org.elasticsearch.xpack.ql.session.Configuration;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.util.Check;

public class FunctionRegistry {
    private static final String[] NUM_NAMES = new String[]{"zero", "one", "two", "three", "four", "five"};
    private final Map<String, FunctionDefinition> defs = new LinkedHashMap<String, FunctionDefinition>();
    private final Map<String, String> aliases = new HashMap<String, String>();

    public FunctionRegistry() {
    }

    public FunctionRegistry(FunctionDefinition ... functions) {
        this.register(functions);
    }

    public FunctionRegistry(FunctionDefinition[] ... groupFunctions) {
        this.register(groupFunctions);
    }

    protected void register(FunctionDefinition[] ... groupFunctions) {
        for (FunctionDefinition[] group : groupFunctions) {
            this.register(group);
        }
    }

    protected void register(FunctionDefinition ... functions) {
        HashMap<String, FunctionDefinition> batchMap = new HashMap<String, FunctionDefinition>();
        for (FunctionDefinition f : functions) {
            batchMap.put(f.name(), f);
            for (String alias : f.aliases()) {
                FunctionDefinition old = batchMap.put(alias, f);
                if (old != null || this.defs.containsKey(alias)) {
                    throw new QlIllegalArgumentException("alias [" + alias + "] is used by [" + String.valueOf(old != null ? old : this.defs.get(alias).name()) + "] and [" + f.name() + "]");
                }
                this.aliases.put(alias, f.name());
            }
        }
        this.defs.putAll(batchMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new)));
    }

    public FunctionDefinition resolveFunction(String functionName) {
        FunctionDefinition def = this.defs.get(functionName);
        if (def == null) {
            throw new QlIllegalArgumentException("Cannot find function {}; this should have been caught during analysis", functionName);
        }
        return def;
    }

    protected String normalize(String name) {
        return name.toUpperCase(Locale.ROOT);
    }

    public String resolveAlias(String alias) {
        String normalized = this.normalize(alias);
        return this.aliases.getOrDefault(normalized, normalized);
    }

    public boolean functionExists(String functionName) {
        return this.defs.containsKey(functionName);
    }

    public Collection<FunctionDefinition> listFunctions() {
        return this.defs.values();
    }

    public Collection<FunctionDefinition> listFunctions(String pattern) {
        Pattern p = Strings.hasText((String)pattern) ? Pattern.compile(this.normalize(pattern)) : null;
        return this.defs.entrySet().stream().filter(e -> p == null || p.matcher((CharSequence)e.getKey()).matches()).map(e -> this.cloneDefinition((String)e.getKey(), (FunctionDefinition)e.getValue())).collect(Collectors.toList());
    }

    protected FunctionDefinition cloneDefinition(String name, FunctionDefinition definition) {
        return new FunctionDefinition(name, Collections.emptyList(), definition.clazz(), definition.builder());
    }

    protected static FunctionDefinition def(Class<? extends Function> function, FunctionBuilder builder, String ... names) {
        Check.isTrue(names.length > 0, "At least one name must be provided for the function");
        String primaryName = names[0];
        List<String> aliases = Arrays.asList(names).subList(1, names.length);
        FunctionDefinition.Builder realBuilder = (uf, cfg, extras) -> {
            if (!CollectionUtils.isEmpty((Object[])extras)) {
                throw new ParsingException(uf.source(), "Unused parameters {} detected when building [{}]", Arrays.toString(extras), primaryName);
            }
            try {
                return builder.build(uf.source(), uf.children(), cfg);
            }
            catch (QlIllegalArgumentException e) {
                throw new ParsingException((Exception)((Object)e), uf.source(), "error building [{}]: {}", primaryName, e.getMessage());
            }
        };
        return new FunctionDefinition(primaryName, Collections.unmodifiableList(aliases), function, realBuilder);
    }

    protected static <T extends Function> FunctionDefinition def(Class<T> function, java.util.function.Function<Source, T> ctorRef, String ... names) {
        FunctionBuilder builder = (source, children, cfg) -> {
            if (!children.isEmpty()) {
                throw new QlIllegalArgumentException("expects no arguments");
            }
            return (Function)ctorRef.apply(source);
        };
        return FunctionRegistry.def(function, builder, names);
    }

    public static <T extends Function> FunctionDefinition def(Class<T> function, BiFunction<Source, Expression, T> ctorRef, String ... names) {
        FunctionBuilder builder = (source, children, cfg) -> {
            if (children.size() != 1) {
                throw new QlIllegalArgumentException("expects exactly one argument");
            }
            return (Function)ctorRef.apply(source, (Expression)children.get(0));
        };
        return FunctionRegistry.def(function, builder, names);
    }

    protected <T extends Function> FunctionDefinition def(Class<T> function, NaryBuilder<T> ctorRef, String ... names) {
        FunctionBuilder builder = (source, children, cfg) -> (Function)ctorRef.build(source, children);
        return FunctionRegistry.def(function, builder, names);
    }

    protected static <T extends Function> FunctionDefinition def(Class<T> function, BinaryBuilder<T> ctorRef, String ... names) {
        FunctionBuilder builder = (source, children, cfg) -> {
            boolean isBinaryOptionalParamFunction = OptionalArgument.class.isAssignableFrom(function);
            if (isBinaryOptionalParamFunction && (children.size() > 2 || children.size() < 1)) {
                throw new QlIllegalArgumentException("expects one or two arguments");
            }
            if (!isBinaryOptionalParamFunction && children.size() != 2) {
                throw new QlIllegalArgumentException("expects exactly two arguments");
            }
            return (Function)ctorRef.build(source, (Expression)children.get(0), children.size() == 2 ? (Expression)children.get(1) : null);
        };
        return FunctionRegistry.def(function, builder, names);
    }

    protected static <T extends Function> FunctionDefinition def(Class<T> function, TernaryBuilder<T> ctorRef, String ... names) {
        FunctionBuilder builder = (source, children, cfg) -> {
            boolean hasMinimumTwo = OptionalArgument.class.isAssignableFrom(function);
            if (hasMinimumTwo && (children.size() > 3 || children.size() < 2)) {
                throw new QlIllegalArgumentException("expects two or three arguments");
            }
            if (!hasMinimumTwo && children.size() != 3) {
                throw new QlIllegalArgumentException("expects exactly three arguments");
            }
            return (Function)ctorRef.build(source, (Expression)children.get(0), (Expression)children.get(1), children.size() == 3 ? (Expression)children.get(2) : null);
        };
        return FunctionRegistry.def(function, builder, names);
    }

    protected static <T extends Function> FunctionDefinition def(Class<T> function, QuaternaryBuilder<T> ctorRef, String ... names) {
        FunctionBuilder builder = (source, children, cfg) -> {
            if (OptionalArgument.class.isAssignableFrom(function)) {
                if (children.size() > 4 || children.size() < 3) {
                    throw new QlIllegalArgumentException("expects three or four arguments");
                }
            } else if (TwoOptionalArguments.class.isAssignableFrom(function)) {
                if (children.size() > 4 || children.size() < 2) {
                    throw new QlIllegalArgumentException("expects minimum two, maximum four arguments");
                }
            } else if (children.size() != 4) {
                throw new QlIllegalArgumentException("expects exactly four arguments");
            }
            return (Function)ctorRef.build(source, (Expression)children.get(0), (Expression)children.get(1), children.size() > 2 ? (Expression)children.get(2) : null, children.size() > 3 ? (Expression)children.get(3) : null);
        };
        return FunctionRegistry.def(function, builder, names);
    }

    protected static <T extends Function> FunctionDefinition def(Class<T> function, QuinaryBuilder<T> ctorRef, int numOptionalParams, String ... names) {
        FunctionBuilder builder = (source, children, cfg) -> {
            int NUM_TOTAL_PARAMS = 5;
            boolean hasOptionalParams = OptionalArgument.class.isAssignableFrom(function);
            if (hasOptionalParams && (children.size() > 5 || children.size() < 5 - numOptionalParams)) {
                throw new QlIllegalArgumentException("expects between " + NUM_NAMES[5 - numOptionalParams] + " and " + NUM_NAMES[5] + " arguments");
            }
            if (!hasOptionalParams && children.size() != 5) {
                throw new QlIllegalArgumentException("expects exactly " + NUM_NAMES[5] + " arguments");
            }
            return (Function)ctorRef.build(source, children.size() > 0 ? (Expression)children.get(0) : null, children.size() > 1 ? (Expression)children.get(1) : null, children.size() > 2 ? (Expression)children.get(2) : null, children.size() > 3 ? (Expression)children.get(3) : null, children.size() > 4 ? (Expression)children.get(4) : null);
        };
        return FunctionRegistry.def(function, builder, names);
    }

    protected static <T extends Function> FunctionDefinition def(Class<T> function, UnaryVariadicBuilder<T> ctorRef, String ... names) {
        FunctionBuilder builder = (source, children, cfg) -> {
            boolean hasMinimumOne = OptionalArgument.class.isAssignableFrom(function);
            if (hasMinimumOne && children.size() < 1) {
                throw new QlIllegalArgumentException("expects at least one argument");
            }
            if (!hasMinimumOne && children.size() < 2) {
                throw new QlIllegalArgumentException("expects at least two arguments");
            }
            return (Function)ctorRef.build(source, (Expression)children.get(0), children.subList(1, children.size()));
        };
        return FunctionRegistry.def(function, builder, names);
    }

    protected static <T extends Function> FunctionDefinition def(Class<T> function, ConfigurationAwareBuilder<T> ctorRef, String ... names) {
        FunctionBuilder builder = (source, children, cfg) -> {
            if (!children.isEmpty()) {
                throw new QlIllegalArgumentException("expects no arguments");
            }
            return (Function)ctorRef.build(source, cfg);
        };
        return FunctionRegistry.def(function, builder, names);
    }

    protected static <T extends Function> FunctionDefinition def(Class<T> function, UnaryConfigurationAwareBuilder<T> ctorRef, String ... names) {
        FunctionBuilder builder = (source, children, cfg) -> {
            if (children.size() > 1) {
                throw new QlIllegalArgumentException("expects exactly one argument");
            }
            Expression ex = children.size() == 1 ? (Expression)children.get(0) : null;
            return (Function)ctorRef.build(source, ex, cfg);
        };
        return FunctionRegistry.def(function, builder, names);
    }

    protected static <T extends Function> FunctionDefinition def(Class<T> function, BinaryConfigurationAwareBuilder<T> ctorRef, String ... names) {
        FunctionBuilder builder = (source, children, cfg) -> {
            boolean isBinaryOptionalParamFunction = OptionalArgument.class.isAssignableFrom(function);
            if (isBinaryOptionalParamFunction && (children.size() > 2 || children.size() < 1)) {
                throw new QlIllegalArgumentException("expects one or two arguments");
            }
            if (!isBinaryOptionalParamFunction && children.size() != 2) {
                throw new QlIllegalArgumentException("expects exactly two arguments");
            }
            return (Function)ctorRef.build(source, (Expression)children.get(0), children.size() == 2 ? (Expression)children.get(1) : null, cfg);
        };
        return FunctionRegistry.def(function, builder, names);
    }

    protected <T extends Function> FunctionDefinition def(Class<T> function, TernaryConfigurationAwareBuilder<T> ctorRef, String ... names) {
        FunctionBuilder builder = (source, children, cfg) -> {
            boolean hasMinimumTwo = OptionalArgument.class.isAssignableFrom(function);
            if (hasMinimumTwo && (children.size() > 3 || children.size() < 2)) {
                throw new QlIllegalArgumentException("expects two or three arguments");
            }
            if (!hasMinimumTwo && children.size() != 3) {
                throw new QlIllegalArgumentException("expects exactly three arguments");
            }
            return (Function)ctorRef.build(source, (Expression)children.get(0), (Expression)children.get(1), children.size() == 3 ? (Expression)children.get(2) : null, cfg);
        };
        return FunctionRegistry.def(function, builder, names);
    }

    protected static Boolean asBool(Object[] extras) {
        if (CollectionUtils.isEmpty((Object[])extras)) {
            return null;
        }
        if (extras.length != 1 || !(extras[0] instanceof Boolean)) {
            throw new QlIllegalArgumentException("Invalid number and types of arguments given to function definition");
        }
        return (Boolean)extras[0];
    }

    protected static interface FunctionBuilder {
        public Function build(Source var1, List<Expression> var2, Configuration var3);
    }

    protected static interface NaryBuilder<T> {
        public T build(Source var1, List<Expression> var2);
    }

    protected static interface BinaryBuilder<T> {
        public T build(Source var1, Expression var2, Expression var3);
    }

    protected static interface TernaryBuilder<T> {
        public T build(Source var1, Expression var2, Expression var3, Expression var4);
    }

    protected static interface QuaternaryBuilder<T> {
        public T build(Source var1, Expression var2, Expression var3, Expression var4, Expression var5);
    }

    protected static interface QuinaryBuilder<T> {
        public T build(Source var1, Expression var2, Expression var3, Expression var4, Expression var5, Expression var6);
    }

    protected static interface UnaryVariadicBuilder<T> {
        public T build(Source var1, Expression var2, List<Expression> var3);
    }

    protected static interface ConfigurationAwareBuilder<T> {
        public T build(Source var1, Configuration var2);
    }

    protected static interface UnaryConfigurationAwareBuilder<T> {
        public T build(Source var1, Expression var2, Configuration var3);
    }

    protected static interface BinaryConfigurationAwareBuilder<T> {
        public T build(Source var1, Expression var2, Expression var3, Configuration var4);
    }

    protected static interface TernaryConfigurationAwareBuilder<T> {
        public T build(Source var1, Expression var2, Expression var3, Expression var4, Configuration var5);
    }
}

