/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.system_indices.task;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.DiffableUtils;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.system_indices.task.SingleFeatureMigrationResult;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;

public class FeatureMigrationResults
implements Metadata.Custom {
    public static final String TYPE = "system_index_migration";
    public static final TransportVersion MIGRATION_ADDED_VERSION = TransportVersions.V_8_0_0;
    static final ParseField RESULTS_FIELD = new ParseField("results", new String[0]);
    private final Map<String, SingleFeatureMigrationResult> featureStatuses;

    public FeatureMigrationResults(Map<String, SingleFeatureMigrationResult> featureStatuses) {
        this.featureStatuses = Objects.requireNonNullElse(featureStatuses, new HashMap());
    }

    public FeatureMigrationResults(StreamInput in) throws IOException {
        this.featureStatuses = in.readMap(SingleFeatureMigrationResult::new);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.featureStatuses, StreamOutput::writeWriteable);
    }

    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params ignored) {
        return ChunkedToXContentHelper.xContentObjectFields((String)RESULTS_FIELD.getPreferredName(), this.featureStatuses);
    }

    public Map<String, SingleFeatureMigrationResult> getFeatureStatuses() {
        return Collections.unmodifiableMap(this.featureStatuses);
    }

    public FeatureMigrationResults withResult(String featureName, SingleFeatureMigrationResult status) {
        HashMap<String, SingleFeatureMigrationResult> newMap = new HashMap<String, SingleFeatureMigrationResult>(this.featureStatuses);
        newMap.put(featureName, status);
        return new FeatureMigrationResults(newMap);
    }

    public EnumSet<Metadata.XContentContext> context() {
        return Metadata.ALL_CONTEXTS;
    }

    public String getWriteableName() {
        return TYPE;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return MIGRATION_ADDED_VERSION;
    }

    public String toString() {
        return "SystemIndexMigrationResult{featureStatuses=" + String.valueOf(this.featureStatuses) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FeatureMigrationResults)) {
            return false;
        }
        FeatureMigrationResults that = (FeatureMigrationResults)o;
        return this.featureStatuses.equals(that.featureStatuses);
    }

    public int hashCode() {
        return Objects.hash(this.featureStatuses);
    }

    public Diff<Metadata.Custom> diff(Metadata.Custom previousState) {
        return new ResultsDiff((FeatureMigrationResults)previousState, this);
    }

    public static NamedDiff<Metadata.Custom> readDiffFrom(StreamInput in) throws IOException {
        return new ResultsDiff(in);
    }

    public static class ResultsDiff
    implements NamedDiff<Metadata.Custom> {
        private final Diff<Map<String, SingleFeatureMigrationResult>> resultsDiff;

        public ResultsDiff(FeatureMigrationResults before, FeatureMigrationResults after) {
            this.resultsDiff = DiffableUtils.diff(before.featureStatuses, after.featureStatuses, (DiffableUtils.KeySerializer)DiffableUtils.getStringKeySerializer());
        }

        public ResultsDiff(StreamInput in) throws IOException {
            this.resultsDiff = DiffableUtils.readJdkMapDiff((StreamInput)in, (DiffableUtils.KeySerializer)DiffableUtils.getStringKeySerializer(), SingleFeatureMigrationResult::new, ResultsDiff::readDiffFrom);
        }

        public Metadata.Custom apply(Metadata.Custom part) {
            TreeMap<String, SingleFeatureMigrationResult> newResults = new TreeMap<String, SingleFeatureMigrationResult>((Map)this.resultsDiff.apply(((FeatureMigrationResults)part).featureStatuses));
            return new FeatureMigrationResults(newResults);
        }

        public String getWriteableName() {
            return FeatureMigrationResults.TYPE;
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.resultsDiff.writeTo(out);
        }

        static Diff<SingleFeatureMigrationResult> readDiffFrom(StreamInput in) throws IOException {
            return SimpleDiffable.readDiffFrom(SingleFeatureMigrationResult::new, (StreamInput)in);
        }

        public TransportVersion getMinimalSupportedVersion() {
            return MIGRATION_ADDED_VERSION;
        }
    }
}

