/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.analysis.kuromoji;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Locale;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.ja.JapaneseTokenizer;
import org.apache.lucene.analysis.ja.dict.UserDictionary;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenizerFactory;
import org.elasticsearch.index.analysis.Analysis;

public class KuromojiTokenizerFactory
extends AbstractTokenizerFactory {
    private static final String USER_DICT_PATH_OPTION = "user_dictionary";
    private static final String USER_DICT_RULES_OPTION = "user_dictionary_rules";
    private static final String NBEST_COST = "nbest_cost";
    private static final String NBEST_EXAMPLES = "nbest_examples";
    private static final String DISCARD_COMPOUND_TOKEN = "discard_compound_token";
    private static final String LENIENT = "lenient";
    private final UserDictionary userDictionary;
    private final JapaneseTokenizer.Mode mode;
    private final String nBestExamples;
    private final int nBestCost;
    private boolean discardPunctuation;
    private boolean discardCompoundToken;

    public KuromojiTokenizerFactory(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(name);
        this.mode = KuromojiTokenizerFactory.getMode(settings);
        this.userDictionary = KuromojiTokenizerFactory.getUserDictionary(env, settings);
        this.discardPunctuation = settings.getAsBoolean("discard_punctuation", Boolean.valueOf(true));
        this.nBestCost = settings.getAsInt(NBEST_COST, Integer.valueOf(-1));
        this.nBestExamples = settings.get(NBEST_EXAMPLES);
        this.discardCompoundToken = settings.getAsBoolean(DISCARD_COMPOUND_TOKEN, Boolean.valueOf(false));
    }

    public static UserDictionary getUserDictionary(Environment env, Settings settings) {
        UserDictionary userDictionary;
        if (settings.get(USER_DICT_PATH_OPTION) != null && settings.get(USER_DICT_RULES_OPTION) != null) {
            throw new IllegalArgumentException("It is not allowed to use [user_dictionary] in conjunction with [user_dictionary_rules]");
        }
        List ruleList = Analysis.getWordList((Environment)env, (Settings)settings, (String)USER_DICT_PATH_OPTION, (String)USER_DICT_RULES_OPTION, (String)LENIENT, (boolean)false, (boolean)true);
        if (ruleList == null || ruleList.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String line : ruleList) {
            sb.append(line).append(System.lineSeparator());
        }
        StringReader rulesReader = new StringReader(sb.toString());
        try {
            userDictionary = UserDictionary.open((Reader)rulesReader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)rulesReader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ElasticsearchException("failed to load kuromoji user dictionary", (Throwable)e, new Object[0]);
            }
        }
        ((Reader)rulesReader).close();
        return userDictionary;
    }

    public static JapaneseTokenizer.Mode getMode(Settings settings) {
        String modeSetting = settings.get("mode", JapaneseTokenizer.DEFAULT_MODE.name());
        return JapaneseTokenizer.Mode.valueOf((String)modeSetting.toUpperCase(Locale.ENGLISH));
    }

    public Tokenizer create() {
        JapaneseTokenizer t = new JapaneseTokenizer(this.userDictionary, this.discardPunctuation, this.discardCompoundToken, this.mode);
        int nBestCostValue = this.nBestCost;
        if (this.nBestExamples != null) {
            nBestCostValue = Math.max(nBestCostValue, t.calcNBestCost(this.nBestExamples));
        }
        t.setNBestCost(nBestCostValue);
        return t;
    }
}

