/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.spark.sql.streaming;

import org.apache.spark.TaskContext;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.types.StructType;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.serialization.BytesConverter;
import org.elasticsearch.hadoop.serialization.JdkBytesConverter;
import org.elasticsearch.hadoop.serialization.builder.ValueWriter;
import org.elasticsearch.hadoop.serialization.field.FieldExtractor;
import org.elasticsearch.spark.rdd.EsRDDWriter;
import org.elasticsearch.spark.rdd.EsRDDWriter$;
import org.elasticsearch.spark.sql.DataFrameFieldExtractor;
import org.elasticsearch.spark.sql.DataFrameValueWriter;
import org.elasticsearch.spark.sql.streaming.EsCommitProtocol;
import org.elasticsearch.spark.sql.streaming.TaskCommit;
import org.elasticsearch.spark.sql.streaming.TaskState;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005e!B\b\u0011\u0001IQ\u0002\"C\u0016\u0001\u0005\u0003\u0005\u000b\u0011B\u0017;\u0011!Y\u0004A!A!\u0002\u0013a\u0004\u0002\u0003\"\u0001\u0005\u0003\u0005\u000b\u0011B\"\t\u000b\u001d\u0003A\u0011\u0001%\t\u000b5\u0003A\u0011\u000b(\t\u000b=\u0004A\u0011\u000b9\t\u000bm\u0004A\u0011\u000b?\t\u0013\u0005M\u0001A1A\u0005\n\u0005U\u0001\u0002CA\u0016\u0001\u0001\u0006I!a\u0006\t\u0013\u00055\u0002A1A\u0005\n\u0005=\u0002\u0002CA \u0001\u0001\u0006I!!\r\t\u000f\u0005\u0005\u0003\u0001\"\u0011\u0002D!9\u0011Q\u000e\u0001\u0005\u0002\u0005=\u0004bBA>\u0001\u0011E\u0013Q\u0010\u0002\u0014\u000bN\u001cFO]3b[F+XM]=Xe&$XM\u001d\u0006\u0003#I\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005M!\u0012aA:rY*\u0011QCF\u0001\u0006gB\f'o\u001b\u0006\u0003/a\tQ\"\u001a7bgRL7m]3be\u000eD'\"A\r\u0002\u0007=\u0014xm\u0005\u0002\u00017A\u0019AdH\u0011\u000e\u0003uQ!A\b\u000b\u0002\u0007I$G-\u0003\u0002!;\tYQi\u001d*E\t^\u0013\u0018\u000e^3s!\t\u0011\u0013&D\u0001$\u0015\t!S%\u0001\u0005dCR\fG._:u\u0015\t\u0019bE\u0003\u0002\u0016O)\u0011\u0001\u0006G\u0001\u0007CB\f7\r[3\n\u0005)\u001a#aC%oi\u0016\u0014h.\u00197S_^\f!c]3sS\u0006d\u0017N_3e'\u0016$H/\u001b8hg\u000e\u0001\u0001C\u0001\u00188\u001d\tyS\u0007\u0005\u00021g5\t\u0011G\u0003\u00023Y\u00051AH]8pizR\u0011\u0001N\u0001\u0006g\u000e\fG.Y\u0005\u0003mM\na\u0001\u0015:fI\u00164\u0017B\u0001\u001d:\u0005\u0019\u0019FO]5oO*\u0011agM\u0005\u0003W}\taa]2iK6\f\u0007CA\u001fA\u001b\u0005q$BA &\u0003\u0015!\u0018\u0010]3t\u0013\t\teH\u0001\u0006TiJ,8\r\u001e+za\u0016\fabY8n[&$\bK]8u_\u000e|G\u000e\u0005\u0002E\u000b6\t\u0001#\u0003\u0002G!\t\u0001Ri]\"p[6LG\u000f\u0015:pi>\u001cw\u000e\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\t%S5\n\u0014\t\u0003\t\u0002AQa\u000b\u0003A\u00025BQa\u000f\u0003A\u0002qBQA\u0011\u0003A\u0002\r\u000b1B^1mk\u0016<&/\u001b;feV\tq\n\r\u0002Q+B\u0019a&U*\n\u0005IK$!B\"mCN\u001c\bC\u0001+V\u0019\u0001!\u0011BV\u0003\u0002\u0002\u0003\u0005)\u0011A,\u0003\u0007}#\u0013'\u0005\u0002Y9B\u0011\u0011LW\u0007\u0002g%\u00111l\r\u0002\b\u001d>$\b.\u001b8ha\ti\u0006\u000eE\u0002_K\u001el\u0011a\u0018\u0006\u0003A\u0006\fqAY;jY\u0012,'O\u0003\u0002cG\u0006i1/\u001a:jC2L'0\u0019;j_:T!\u0001\u001a\f\u0002\r!\fGm\\8q\u0013\t1wLA\u0006WC2,Xm\u0016:ji\u0016\u0014\bC\u0001+i\t%I'.!A\u0001\u0002\u000b\u00051NA\u0002`II\"\u0011BV\u0003\u0002\u0002\u0007\u0005)\u0011A,\u0012\u0005ac\u0007CA-n\u0013\tq7GA\u0002B]f\faBY=uKN\u001cuN\u001c<feR,'/F\u0001ra\t\u0011H\u000fE\u0002/#N\u0004\"\u0001\u0016;\u0005\u0013U4\u0011\u0011!A\u0001\u0006\u00031(aA0%gE\u0011\u0001l\u001e\t\u0003qfl\u0011!Y\u0005\u0003u\u0006\u0014aBQ=uKN\u001cuN\u001c<feR,'/\u0001\bgS\u0016dG-\u0012=ue\u0006\u001cGo\u001c:\u0016\u0003u\u00044A`A\u0001!\rq\u0013k \t\u0004)\u0006\u0005AaCA\u0002\u000f\u0005\u0005\t\u0011!B\u0001\u0003\u000b\u00111a\u0018\u00135#\rA\u0016q\u0001\t\u0005\u0003\u0013\ty!\u0004\u0002\u0002\f)\u0019\u0011QB1\u0002\u000b\u0019LW\r\u001c3\n\t\u0005E\u00111\u0002\u0002\u000f\r&,G\u000eZ#yiJ\f7\r^8s\u0003\u001d)gnY8eKJ,\"!a\u0006\u0011\r\u0005e\u0011qDA\u0012\u001b\t\tYBC\u0002\u0002\u001e\r\n\u0001\"\u001a8d_\u0012,'o]\u0005\u0005\u0003C\tYBA\tFqB\u0014Xm]:j_:,enY8eKJ\u0004B!!\n\u0002(5\tQ%C\u0002\u0002*\u0015\u00121AU8x\u0003!)gnY8eKJ\u0004\u0013\u0001\u00043fg\u0016\u0014\u0018.\u00197ju\u0016\u0014XCAA\u0019!\u0019\t\u0019$!\u000f\u0002$9!\u0011\u0011DA\u001b\u0013\u0011\t9$a\u0007\u0002#\u0015C\bO]3tg&|g.\u00128d_\u0012,'/\u0003\u0003\u0002<\u0005u\"\u0001\u0004#fg\u0016\u0014\u0018.\u00197ju\u0016\u0014(\u0002BA\u001c\u00037\tQ\u0002Z3tKJL\u0017\r\\5{KJ\u0004\u0013!B<sSR,GCBA#\u0003\u0017\n9\u0006E\u0002Z\u0003\u000fJ1!!\u00134\u0005\u0011)f.\u001b;\t\u000f\u00055C\u00021\u0001\u0002P\u0005YA/Y:l\u0007>tG/\u001a=u!\u0011\t\t&a\u0015\u000e\u0003\u0019J1!!\u0016'\u0005-!\u0016m]6D_:$X\r\u001f;\t\u000f\u0005eC\u00021\u0001\u0002\\\u0005!A-\u0019;b!\u0015\ti&a\u001a\"\u001d\u0011\ty&a\u0019\u000f\u0007A\n\t'C\u00015\u0013\r\t)gM\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tI'a\u001b\u0003\u0011%#XM]1u_JT1!!\u001a4\u0003\r\u0011XO\u001c\u000b\u0007\u0003c\n9(!\u001f\u0011\u0007\u0011\u000b\u0019(C\u0002\u0002vA\u0011!\u0002V1tW\u000e{W.\\5u\u0011\u001d\ti%\u0004a\u0001\u0003\u001fBq!!\u0017\u000e\u0001\u0004\tY&A\u0006qe>\u001cWm]:ECR\fGc\u00017\u0002\u0000!9\u0011\u0011\f\bA\u0002\u0005m\u0003")
public class EsStreamQueryWriter
extends EsRDDWriter<InternalRow> {
    private final StructType schema;
    private final EsCommitProtocol commitProtocol;
    private final ExpressionEncoder<Row> encoder;
    private final ExpressionEncoder.Deserializer<Row> deserializer;

    @Override
    public Class<? extends ValueWriter<?>> valueWriter() {
        return DataFrameValueWriter.class;
    }

    @Override
    public Class<? extends BytesConverter> bytesConverter() {
        return JdkBytesConverter.class;
    }

    @Override
    public Class<? extends FieldExtractor> fieldExtractor() {
        return DataFrameFieldExtractor.class;
    }

    private ExpressionEncoder<Row> encoder() {
        return this.encoder;
    }

    private ExpressionEncoder.Deserializer<Row> deserializer() {
        return this.deserializer;
    }

    @Override
    public void write(TaskContext taskContext, Iterator<InternalRow> data) {
        throw new EsHadoopIllegalArgumentException("Use run(taskContext, data) instead to retrieve the commit information");
    }

    public TaskCommit run(TaskContext taskContext, Iterator<InternalRow> data) {
        TaskState taskInfo = new TaskState(taskContext.partitionId(), this.settings().getResourceWrite());
        this.commitProtocol.initTask(taskInfo);
        try {
            super.write(taskContext, data);
        }
        catch (Throwable t) {
            this.commitProtocol.abortTask(taskInfo);
            throw t;
        }
        return this.commitProtocol.commitTask(taskInfo);
    }

    @Override
    public Object processData(Iterator<InternalRow> data) {
        Row row = (Row)this.deserializer().apply((InternalRow)data.next());
        this.commitProtocol.recordSeen();
        return new Tuple2((Object)row, (Object)this.schema);
    }

    public EsStreamQueryWriter(String serializedSettings, StructType schema, EsCommitProtocol commitProtocol) {
        this.schema = schema;
        this.commitProtocol = commitProtocol;
        super(serializedSettings, EsRDDWriter$.MODULE$.$lessinit$greater$default$2(), ClassTag$.MODULE$.apply(InternalRow.class));
        ExpressionEncoder qual$1 = RowEncoder$.MODULE$.apply(schema);
        Seq x$1 = qual$1.resolveAndBind$default$1();
        Analyzer x$2 = qual$1.resolveAndBind$default$2();
        this.encoder = qual$1.resolveAndBind(x$1, x$2);
        this.deserializer = this.encoder().createDeserializer();
    }
}

