/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.spark.deploy.yarn.security;

import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.spark.SparkConf;
import org.apache.spark.security.HadoopDelegationTokenProvider;
import org.elasticsearch.hadoop.cfg.CompositeSettings;
import org.elasticsearch.hadoop.cfg.HadoopSettingsManager;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.mr.security.EsTokenIdentifier;
import org.elasticsearch.hadoop.mr.security.HadoopUserProvider;
import org.elasticsearch.hadoop.rest.InitializationUtils;
import org.elasticsearch.hadoop.rest.RestClient;
import org.elasticsearch.hadoop.security.AuthenticationMethod;
import org.elasticsearch.hadoop.security.EsToken;
import org.elasticsearch.hadoop.security.User;
import org.elasticsearch.hadoop.security.UserProvider;
import org.elasticsearch.spark.cfg.SparkSettingsManager;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\r4AAB\u0004\u0001)!)1\u0005\u0001C\u0001I!1q\u0005\u0001Q\u0001\n!BQ\u0001\r\u0001\u0005BEBQ!\u0010\u0001\u0005ByBQA\u0015\u0001\u0005BM\u00131$R:TKJ4\u0018nY3De\u0016$WM\u001c;jC2\u0004&o\u001c<jI\u0016\u0014(B\u0001\u0005\n\u0003!\u0019XmY;sSRL(B\u0001\u0006\f\u0003\u0011I\u0018M\u001d8\u000b\u00051i\u0011A\u00023fa2|\u0017P\u0003\u0002\u000f\u001f\u0005)1\u000f]1sW*\u0011\u0001#E\u0001\u000eK2\f7\u000f^5dg\u0016\f'o\u00195\u000b\u0003I\t1a\u001c:h\u0007\u0001\u00192\u0001A\u000b\u001c!\t1\u0012$D\u0001\u0018\u0015\u0005A\u0012!B:dC2\f\u0017B\u0001\u000e\u0018\u0005\u0019\te.\u001f*fMB\u0011A$I\u0007\u0002;)\u0011\u0001B\b\u0006\u0003\u001d}Q!\u0001I\t\u0002\r\u0005\u0004\u0018m\u00195f\u0013\t\u0011SDA\u000fIC\u0012|w\u000e\u001d#fY\u0016<\u0017\r^5p]R{7.\u001a8Qe>4\u0018\u000eZ3s\u0003\u0019a\u0014N\\5u}Q\tQ\u0005\u0005\u0002'\u00015\tq!A\u0002M\u001f\u001e\u0003\"!\u000b\u0018\u000e\u0003)R!a\u000b\u0017\u0002\u000f1|wmZ5oO*\u0011QfH\u0001\bG>lWn\u001c8t\u0013\ty#FA\u0002M_\u001e\f1b]3sm&\u001cWMT1nKV\t!\u0007\u0005\u00024u9\u0011A\u0007\u000f\t\u0003k]i\u0011A\u000e\u0006\u0003oM\ta\u0001\u0010:p_Rt\u0014BA\u001d\u0018\u0003\u0019\u0001&/\u001a3fM&\u00111\b\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005e:\u0012\u0001\u00073fY\u0016<\u0017\r^5p]R{7.\u001a8t%\u0016\fX/\u001b:fIR\u0019qH\u0011%\u0011\u0005Y\u0001\u0015BA!\u0018\u0005\u001d\u0011un\u001c7fC:DQa\u0011\u0003A\u0002\u0011\u000b\u0011b\u001d9be.\u001cuN\u001c4\u0011\u0005\u00153U\"\u0001\u0010\n\u0005\u001ds\"!C*qCJ\\7i\u001c8g\u0011\u0015IE\u00011\u0001K\u0003)A\u0017\rZ8pa\u000e{gN\u001a\t\u0003\u0017Bk\u0011\u0001\u0014\u0006\u0003\u001b:\u000bAaY8oM*\u0011qjH\u0001\u0007Q\u0006$wn\u001c9\n\u0005Ec%!D\"p]\u001aLw-\u001e:bi&|g.\u0001\fpER\f\u0017N\u001c#fY\u0016<\u0017\r^5p]R{7.\u001a8t)\u0011!&l\u0017/\u0011\u0007Y)v+\u0003\u0002W/\t1q\n\u001d;j_:\u0004\"A\u0006-\n\u0005e;\"\u0001\u0002'p]\u001eDQ!S\u0003A\u0002)CQaQ\u0003A\u0002\u0011CQ!X\u0003A\u0002y\u000bQa\u0019:fIN\u0004\"aX1\u000e\u0003\u0001T!\u0001\u0003(\n\u0005\t\u0004'aC\"sK\u0012,g\u000e^5bYN\u0004")
public class EsServiceCredentialProvider
implements HadoopDelegationTokenProvider {
    private final Log LOG = LogFactory.getLog(EsServiceCredentialProvider.class);

    public String serviceName() {
        return "elasticsearch";
    }

    public boolean delegationTokensRequired(SparkConf sparkConf, Configuration hadoopConf) {
        Settings settings = sparkConf != null ? new CompositeSettings(Arrays.asList((Object[])new Settings[]{new SparkSettingsManager().load(sparkConf), new HadoopSettingsManager().load(hadoopConf)})) : HadoopSettingsManager.loadFrom(hadoopConf);
        boolean isSecurityEnabled = UserGroupInformation.isSecurityEnabled();
        AuthenticationMethod esAuthMethod = settings.getSecurityAuthenticationMethod();
        boolean required = isSecurityEnabled && AuthenticationMethod.KERBEROS.equals((Object)esAuthMethod);
        this.LOG.info((Object)new StringBuilder(28).append("Hadoop Security Enabled = [").append(isSecurityEnabled).append("]").toString());
        this.LOG.info((Object)new StringBuilder(19).append("ES Auth Method = [").append((Object)esAuthMethod).append("]").toString());
        this.LOG.info((Object)new StringBuilder(23).append("Are creds required = [").append(required).append("]").toString());
        return required;
    }

    public Option<Object> obtainDelegationTokens(Configuration hadoopConf, SparkConf sparkConf, Credentials creds) {
        Some some;
        CompositeSettings settings = new CompositeSettings(Arrays.asList((Object[])new Settings[]{new SparkSettingsManager().load(sparkConf), new HadoopSettingsManager().load(hadoopConf)}));
        InitializationUtils.setUserProviderIfNotSet(settings, HadoopUserProvider.class, LogFactory.getLog(EsServiceCredentialProvider.class));
        UserProvider userProvider = UserProvider.create(settings);
        try (RestClient client = new RestClient(settings);){
            User user = userProvider.getUser();
            EsToken esToken = user.doAs(new PrivilegedExceptionAction<EsToken>(null, client){
                private final RestClient client$1;

                public EsToken run() {
                    return this.client$1.createNewApiToken(new StringBuilder(9).append("ESHADOOP_").append(UUID.randomUUID().toString()).toString());
                }
                {
                    this.client$1 = client$1;
                }
            });
            if (this.LOG.isInfoEnabled()) {
                this.LOG.info((Object)new StringBuilder(65).append("getting token for: Elasticsearch[tokenName=").append(esToken.getName()).append(", ").append("clusterName=").append(esToken.getClusterName()).append(", user=").append(user).append("]").toString());
            }
            long expiration = esToken.getExpirationTime();
            Token<EsTokenIdentifier> token = EsTokenIdentifier.createTokenFrom(esToken);
            creds.addToken(token.getService(), token);
            some = new Some((Object)BoxesRunTime.boxToLong((long)expiration));
        }
        return some;
    }

    public EsServiceCredentialProvider() {
        this.LOG.info((Object)"Loaded EsServiceCredentialProvider");
    }
}

