/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.util;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.hadoop.util.IOUtils;

public abstract class Version {
    private static final String UNKNOWN = "Unknown";
    private static final String VER;
    private static final String HASH;
    private static final String SHORT_HASH;
    public static boolean printed;

    public static String version() {
        return "v" + Version.versionNumber() + " [" + Version.versionHashShort() + "]";
    }

    public static String versionNumber() {
        return VER;
    }

    public static String versionHash() {
        return HASH;
    }

    public static String versionHashShort() {
        return SHORT_HASH;
    }

    public static void logVersion() {
        if (!printed) {
            printed = true;
            LogFactory.getLog(Version.class).info((Object)("Elasticsearch Hadoop " + Version.version()));
            String javaVersion = System.getProperty("java.version");
            if (javaVersion.startsWith("1.") && !javaVersion.startsWith("1.8.")) {
                LogFactory.getLog(Version.class).warn((Object)("Using java version " + javaVersion + " is deprecated in Elasticsearch Hadoop"));
            }
        }
    }

    static {
        printed = false;
        String target = Version.class.getName().replace(".", "/").concat(".class");
        Enumeration<URL> res = null;
        try {
            res = Version.class.getClassLoader().getResources(target);
        }
        catch (IOException ex) {
            LogFactory.getLog(Version.class).warn((Object)"Cannot detect ES-Hadoop jar; it typically indicates a deployment issue...");
        }
        if (res != null) {
            ArrayList<URL> urls = Collections.list(res);
            LinkedHashMap<String, ArrayList<URL>> normalized = new LinkedHashMap<String, ArrayList<URL>>();
            for (URL url : urls) {
                String message;
                try {
                    String canonicalPath = IOUtils.toCanonicalFilePath(url);
                    List pathURLs = (ArrayList<URL>)normalized.get(canonicalPath);
                    if (pathURLs == null) {
                        pathURLs = new ArrayList<URL>();
                        normalized.put(canonicalPath, (ArrayList<URL>)pathURLs);
                    }
                    pathURLs.add(url);
                }
                catch (URISyntaxException e) {
                    message = "Could not parse classpath resource URI: " + url.toString();
                    throw new RuntimeException(message, e);
                }
                catch (IOException e) {
                    message = "Could not retrieve canonical path to classpath resource: " + url.toString();
                    throw new RuntimeException(message, e);
                }
            }
            int foundJars = 0;
            if (normalized.size() > 1) {
                StringBuilder sb = new StringBuilder("Multiple ES-Hadoop versions detected in the classpath; please use only one\n");
                for (List pathURLs : normalized.values()) {
                    String path = ((URL)pathURLs.get(0)).toString();
                    if (!path.contains("jar:")) continue;
                    ++foundJars;
                    sb.append(path.replace("!/" + target, ""));
                    sb.append("\n");
                }
                if (foundJars > 1) {
                    throw new RuntimeException(sb.toString());
                }
            }
        }
        Properties build = new Properties();
        try {
            build = IOUtils.propsFromString(IOUtils.asString(Version.class.getResourceAsStream("/esh-build.properties")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        VER = build.getProperty("version", UNKNOWN);
        HASH = build.getProperty("hash", UNKNOWN);
        SHORT_HASH = HASH.length() > 10 ? HASH.substring(0, 10) : HASH;
    }
}

