/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.json;

import java.io.IOException;
import java.util.Iterator;
import org.elasticsearch.hadoop.serialization.json.BackportedObjectReader;
import org.elasticsearch.hadoop.serialization.json.ObjectReader;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.JsonParser;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.ObjectMapper;
import org.elasticsearch.hadoop.util.ObjectUtils;

public abstract class JsonFactory {
    private static final boolean HAS_OBJECT_READER = ObjectUtils.isClassPresent("org.codehaus.jackson.map.ObjectReader", JsonFactory.class.getClassLoader());

    public static <T> ObjectReader objectReader(ObjectMapper mapper, Class<T> clazz) {
        return HAS_OBJECT_READER ? JacksonObjectReader.reader(mapper, clazz) : BackportedObjectReader.create(mapper, clazz);
    }

    private static class JacksonObjectReader {
        private JacksonObjectReader() {
        }

        public static <E> ObjectReader reader(final ObjectMapper mapper, final Class<E> clazz) {
            return new ObjectReader(){
                private final org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.ObjectReader or;
                {
                    this.or = mapper.reader(clazz);
                }

                @Override
                public <T> Iterator<T> readValues(JsonParser parser) throws IOException {
                    return this.or.readValues(parser);
                }
            };
        }
    }
}

