"use strict";
/**
 * MIT License
 *
 * Copyright (c) 2020-present, Elastic NV
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.runner = exports.after = exports.before = exports.afterAll = exports.beforeAll = exports.monitor = exports.step = exports.journey = void 0;
const dsl_1 = require("../dsl");
const globals_1 = require("./globals");
const helpers_1 = require("../helpers");
const logger_1 = require("./logger");
const createJourney = (type) => (0, helpers_1.wrapFnWithLocation)((location, options, callback) => {
    (0, logger_1.log)(`Journey register: ${JSON.stringify(options)}`);
    if (typeof options === 'string') {
        options = { name: options, id: options };
    }
    const j = new dsl_1.Journey(options, callback, location);
    if (type) {
        j[type] = true;
    }
    exports.runner._addJourney(j);
    return j;
});
exports.journey = createJourney();
exports.journey.skip = createJourney('skip');
exports.journey.only = createJourney('only');
const createStep = (type) => (0, helpers_1.wrapFnWithLocation)((location, name, callback) => {
    (0, logger_1.log)(`Step register: ${name}`);
    const step = exports.runner.currentJourney?._addStep(name, callback, location);
    if (type) {
        step[type] = true;
    }
    return step;
});
exports.step = createStep();
exports.step.skip = createStep('skip');
exports.step.soft = createStep('soft');
exports.step.only = createStep('only');
exports.monitor = {
    use: (0, helpers_1.wrapFnWithLocation)((location, config) => {
        /**
         * If the context is inside journey, then set it to journey context
         * otherwise set to the global monitor which will be used for all journeys
         */
        if (exports.runner.currentJourney) {
            exports.runner.currentJourney._updateMonitor(config);
        }
        else {
            exports.runner._updateMonitor(config);
        }
    }),
};
const beforeAll = (callback) => {
    exports.runner._addHook('beforeAll', callback);
};
exports.beforeAll = beforeAll;
const afterAll = (callback) => {
    exports.runner._addHook('afterAll', callback);
};
exports.afterAll = afterAll;
const before = (callback) => {
    if (!exports.runner.currentJourney) {
        throw new Error('before is called outside of the journey context');
    }
    return exports.runner.currentJourney._addHook('before', callback);
};
exports.before = before;
const after = (callback) => {
    if (!exports.runner.currentJourney) {
        throw new Error('after is called outside of the journey context');
    }
    return exports.runner.currentJourney._addHook('after', callback);
};
exports.after = after;
exports.runner = globals_1.runner;
//# sourceMappingURL=index.js.map